/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.nio.channels.spi.SelectorProvider;
import java.security.AccessController;
import sun.nio.ch.DevPollSelectorProvider;
import sun.nio.ch.EPollSelectorProvider;
import sun.nio.ch.PollSelectorProvider;
import sun.security.action.GetPropertyAction;

public class DefaultSelectorProvider {
    private static final String os_name = AccessController.doPrivileged(new GetPropertyAction("os.name"));

    private DefaultSelectorProvider() {
    }

    public static SelectorProvider create() {
        String string;
        String[] stringArray;
        if ("HP-UX".compareTo(os_name) == 0) {
            if (DefaultSelectorProvider.isDevPollSupported()) {
                return new DevPollSelectorProvider();
            }
            return new PollSelectorProvider();
        }
        if (os_name.equals("OpenVMS") || os_name.equals("OSF1")) {
            return new PollSelectorProvider();
        }
        String string2 = AccessController.doPrivileged(new GetPropertyAction("os.name"));
        if ("SunOS".equals(string2)) {
            return new DevPollSelectorProvider();
        }
        if ("Linux".equals(string2) && (stringArray = (string = AccessController.doPrivileged(new GetPropertyAction("os.version"))).split("\\.", 0)).length >= 2) {
            try {
                int n = Integer.parseInt(stringArray[0]);
                int n2 = Integer.parseInt(stringArray[1]);
                if (n > 2 || n == 2 && n2 >= 6) {
                    return new EPollSelectorProvider();
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return new PollSelectorProvider();
    }

    private static native boolean isDevPollSupported();

    static {
        try {
            System.loadLibrary("nio");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.err.println("Error: Failed to load library, caught exception: " + unsatisfiedLinkError.getMessage());
        }
    }
}

