/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.cmm.lcms;

import java.awt.image.BufferedImage;
import sun.awt.image.ByteComponentRaster;
import sun.awt.image.IntegerComponentRaster;
import sun.awt.image.ShortComponentRaster;

class LCMSImageLayout {
    public static final int SWAPFIRST = 16384;
    public static final int DOSWAP = 1024;
    public static final int PT_RGB_8 = LCMSImageLayout.CHANNELS_SH(3) | LCMSImageLayout.BYTES_SH(1);
    public static final int PT_GRAY_8 = LCMSImageLayout.CHANNELS_SH(1) | LCMSImageLayout.BYTES_SH(1);
    public static final int PT_GRAY_16 = LCMSImageLayout.CHANNELS_SH(1) | LCMSImageLayout.BYTES_SH(2);
    public static final int PT_RGBA_8 = LCMSImageLayout.EXTRA_SH(1) | LCMSImageLayout.CHANNELS_SH(3) | LCMSImageLayout.BYTES_SH(1);
    public static final int PT_ARGB_8 = LCMSImageLayout.EXTRA_SH(1) | LCMSImageLayout.CHANNELS_SH(3) | LCMSImageLayout.BYTES_SH(1) | 0x4000;
    public static final int PT_BGR_8 = 0x400 | LCMSImageLayout.CHANNELS_SH(3) | LCMSImageLayout.BYTES_SH(1);
    public static final int PT_ABGR_8 = 0x400 | LCMSImageLayout.EXTRA_SH(1) | LCMSImageLayout.CHANNELS_SH(3) | LCMSImageLayout.BYTES_SH(1);
    public static final int PT_BGRA_8 = LCMSImageLayout.EXTRA_SH(1) | LCMSImageLayout.CHANNELS_SH(3) | LCMSImageLayout.BYTES_SH(1) | 0x400 | 0x4000;
    public static final int DT_BYTE = 0;
    public static final int DT_SHORT = 1;
    public static final int DT_INT = 2;
    public static final int DT_DOUBLE = 3;
    boolean isIntPacked = false;
    int pixelType;
    int dataType;
    int width;
    int height;
    int nextRowOffset;
    private int nextPixelOffset;
    int offset;
    Object dataArray;
    private int dataArrayLength;

    public static int BYTES_SH(int n) {
        return n;
    }

    public static int EXTRA_SH(int n) {
        return n << 7;
    }

    public static int CHANNELS_SH(int n) {
        return n << 3;
    }

    private LCMSImageLayout(int n, int n2, int n3) throws ImageLayoutException {
        this.pixelType = n2;
        this.width = n;
        this.height = 1;
        this.nextPixelOffset = n3;
        this.nextRowOffset = LCMSImageLayout.safeMult(n3, n);
        this.offset = 0;
    }

    private LCMSImageLayout(int n, int n2, int n3, int n4) throws ImageLayoutException {
        this.pixelType = n3;
        this.width = n;
        this.height = n2;
        this.nextPixelOffset = n4;
        this.nextRowOffset = LCMSImageLayout.safeMult(n4, n);
        this.offset = 0;
    }

    public LCMSImageLayout(byte[] byArray, int n, int n2, int n3) throws ImageLayoutException {
        this(n, n2, n3);
        this.dataType = 0;
        this.dataArray = byArray;
        this.dataArrayLength = byArray.length;
        this.verify();
    }

    public LCMSImageLayout(short[] sArray, int n, int n2, int n3) throws ImageLayoutException {
        this(n, n2, n3);
        this.dataType = 1;
        this.dataArray = sArray;
        this.dataArrayLength = 2 * sArray.length;
        this.verify();
    }

    public LCMSImageLayout(int[] nArray, int n, int n2, int n3) throws ImageLayoutException {
        this(n, n2, n3);
        this.dataType = 2;
        this.dataArray = nArray;
        this.dataArrayLength = 4 * nArray.length;
        this.verify();
    }

    public LCMSImageLayout(double[] dArray, int n, int n2, int n3) throws ImageLayoutException {
        this(n, n2, n3);
        this.dataType = 3;
        this.dataArray = dArray;
        this.dataArrayLength = 8 * dArray.length;
        this.verify();
    }

    public LCMSImageLayout(BufferedImage bufferedImage) throws ImageLayoutException {
        switch (bufferedImage.getType()) {
            case 1: {
                this.pixelType = PT_ARGB_8;
                this.isIntPacked = true;
                break;
            }
            case 2: {
                this.pixelType = PT_ARGB_8;
                this.isIntPacked = true;
                break;
            }
            case 4: {
                this.pixelType = PT_ABGR_8;
                this.isIntPacked = true;
                break;
            }
            case 5: {
                this.pixelType = PT_BGR_8;
                break;
            }
            case 6: {
                this.pixelType = PT_ABGR_8;
                break;
            }
            case 10: {
                this.pixelType = PT_GRAY_8;
                break;
            }
            case 11: {
                this.pixelType = PT_GRAY_16;
                break;
            }
            default: {
                throw new IllegalArgumentException("CMMImageLayout - bad image type passed to constructor");
            }
        }
        this.width = bufferedImage.getWidth();
        this.height = bufferedImage.getHeight();
        switch (bufferedImage.getType()) {
            case 1: 
            case 2: 
            case 4: {
                IntegerComponentRaster integerComponentRaster = (IntegerComponentRaster)bufferedImage.getRaster();
                this.nextRowOffset = LCMSImageLayout.safeMult(4, integerComponentRaster.getScanlineStride());
                this.nextPixelOffset = LCMSImageLayout.safeMult(4, integerComponentRaster.getPixelStride());
                this.offset = LCMSImageLayout.safeMult(4, integerComponentRaster.getDataOffset(0));
                this.dataArray = integerComponentRaster.getDataStorage();
                this.dataArrayLength = 4 * integerComponentRaster.getDataStorage().length;
                this.dataType = 2;
                break;
            }
            case 5: 
            case 6: {
                ByteComponentRaster byteComponentRaster = (ByteComponentRaster)bufferedImage.getRaster();
                this.nextRowOffset = byteComponentRaster.getScanlineStride();
                this.nextPixelOffset = byteComponentRaster.getPixelStride();
                int n = bufferedImage.getSampleModel().getNumBands() - 1;
                this.offset = byteComponentRaster.getDataOffset(n);
                this.dataArray = byteComponentRaster.getDataStorage();
                this.dataArrayLength = byteComponentRaster.getDataStorage().length;
                this.dataType = 0;
                break;
            }
            case 10: {
                ByteComponentRaster byteComponentRaster = (ByteComponentRaster)bufferedImage.getRaster();
                this.nextRowOffset = byteComponentRaster.getScanlineStride();
                this.nextPixelOffset = byteComponentRaster.getPixelStride();
                this.offset = byteComponentRaster.getDataOffset(0);
                this.dataArray = byteComponentRaster.getDataStorage();
                this.dataArrayLength = byteComponentRaster.getDataStorage().length;
                this.dataType = 0;
                break;
            }
            case 11: {
                ShortComponentRaster shortComponentRaster = (ShortComponentRaster)bufferedImage.getRaster();
                this.nextRowOffset = LCMSImageLayout.safeMult(2, shortComponentRaster.getScanlineStride());
                this.nextPixelOffset = LCMSImageLayout.safeMult(2, shortComponentRaster.getPixelStride());
                this.offset = LCMSImageLayout.safeMult(2, shortComponentRaster.getDataOffset(0));
                this.dataArray = shortComponentRaster.getDataStorage();
                this.dataArrayLength = 2 * shortComponentRaster.getDataStorage().length;
                this.dataType = 1;
            }
        }
        this.verify();
    }

    public static boolean isSupported(BufferedImage bufferedImage) {
        switch (bufferedImage.getType()) {
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: {
                return true;
            }
        }
        return false;
    }

    private void verify() throws ImageLayoutException {
        if (this.offset < 0 || this.offset >= this.dataArrayLength) {
            throw new ImageLayoutException("Invalid image layout");
        }
        if (this.nextPixelOffset != LCMSImageLayout.getBytesPerPixel(this.pixelType)) {
            throw new ImageLayoutException("Invalid image layout");
        }
        int n = LCMSImageLayout.safeMult(this.nextRowOffset, this.height - 1);
        int n2 = LCMSImageLayout.safeMult(this.nextPixelOffset, this.width - 1);
        int n3 = LCMSImageLayout.safeAdd(this.offset, n2 = LCMSImageLayout.safeAdd(n2, n));
        if (n3 < 0 || n3 >= this.dataArrayLength) {
            throw new ImageLayoutException("Invalid image layout");
        }
    }

    static int safeAdd(int n, int n2) throws ImageLayoutException {
        long l = n;
        if ((l += (long)n2) < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
            throw new ImageLayoutException("Invalid image layout");
        }
        return (int)l;
    }

    static int safeMult(int n, int n2) throws ImageLayoutException {
        long l = n;
        if ((l *= (long)n2) < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
            throw new ImageLayoutException("Invalid image layout");
        }
        return (int)l;
    }

    private static int getBytesPerPixel(int n) {
        int n2 = 7 & n;
        int n3 = 0xF & n >> 3;
        int n4 = 7 & n >> 7;
        return n2 * (n3 + n4);
    }

    public static class ImageLayoutException
    extends Exception {
        public ImageLayoutException(String string) {
            super(string);
        }
    }
}

