/*
 * Decompiled with CFR 0.152.
 */
package sun.io;

import java.io.UnsupportedEncodingException;
import java.lang.ref.SoftReference;
import java.security.AccessController;
import java.util.Properties;
import sun.io.CharacterEncoding;
import sun.misc.VM;
import sun.security.action.GetPropertyAction;

@Deprecated
public class Converters {
    private static Object lock = Converters.class;
    private static String converterPackageName = null;
    private static String defaultEncoding = null;
    public static final int BYTE_TO_CHAR = 0;
    public static final int CHAR_TO_BYTE = 1;
    private static final String[] converterPrefix = new String[]{"ByteToChar", "CharToByte"};
    private static Class ctbDefault;
    private static Class btcDefault;
    private static final int CACHE_SIZE = 3;
    private static final Object DEFAULT_NAME;
    private static SoftReference<Object[]>[][] classCache;

    private Converters() {
    }

    private static void moveToFront(Object[] objectArray, int n) {
        Object object = objectArray[n];
        for (int i = n; i > 0; --i) {
            objectArray[i] = objectArray[i - 1];
        }
        objectArray[0] = object;
    }

    private static Class<?> cache(int n, Object object) {
        Object[] objectArray = classCache[n];
        for (int i = 0; i < 3; ++i) {
            SoftReference<Object[]> softReference = objectArray[i];
            if (softReference == null) continue;
            Object[] objectArray2 = softReference.get();
            if (objectArray2 == null) {
                objectArray[i] = null;
                continue;
            }
            if (!objectArray2[1].equals(object)) continue;
            Converters.moveToFront(objectArray, i);
            return (Class)objectArray2[0];
        }
        return null;
    }

    private static Class<?> cache(int n, Object object, Class<?> clazz) {
        Object[] objectArray = classCache[n];
        objectArray[2] = new SoftReference<Object[]>(new Object[]{clazz, object});
        Converters.moveToFront(objectArray, 2);
        return clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isCached(int n, String string) {
        Object object = lock;
        synchronized (object) {
            SoftReference<Object[]>[] softReferenceArray = classCache[n];
            for (int i = 0; i < 3; ++i) {
                SoftReference<Object[]> softReference = softReferenceArray[i];
                if (softReference == null) continue;
                Object[] objectArray = softReference.get();
                if (objectArray == null) {
                    softReferenceArray[i] = null;
                    continue;
                }
                if (!objectArray[1].equals(string)) continue;
                return true;
            }
            return false;
        }
    }

    private static String getConverterPackageName() {
        String string = converterPackageName;
        if (string != null) {
            return string;
        }
        GetPropertyAction getPropertyAction = new GetPropertyAction("file.encoding.pkg");
        string = AccessController.doPrivileged(getPropertyAction);
        if (string != null) {
            converterPackageName = string;
        } else {
            string = "sun.io";
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDefaultEncodingName() {
        Object object = lock;
        synchronized (object) {
            if (defaultEncoding == null) {
                GetPropertyAction getPropertyAction = new GetPropertyAction("file.encoding");
                defaultEncoding = AccessController.doPrivileged(getPropertyAction);
            }
        }
        return defaultEncoding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetDefaultEncodingName() {
        if (VM.isBooted()) {
            return;
        }
        Object object = lock;
        synchronized (object) {
            defaultEncoding = "ISO-8859-1";
            Properties properties = System.getProperties();
            properties.setProperty("file.encoding", defaultEncoding);
            System.setProperties(properties);
        }
    }

    private static Class<?> getConverterClass(int n, String string) throws UnsupportedEncodingException {
        String string2 = null;
        if (!string.equals("ISO8859_1")) {
            string2 = string.equals("8859_1") ? "ISO8859_1" : (string.equals("ISO8859-1") ? "ISO8859_1" : (string.equals("646") ? "ASCII" : CharacterEncoding.aliasName(string)));
        }
        if (string2 == null) {
            string2 = string;
        }
        try {
            return Class.forName(Converters.getConverterPackageName() + "." + converterPrefix[n] + string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new UnsupportedEncodingException(string2);
        }
    }

    private static Object newConverter(String string, Class<?> clazz) throws UnsupportedEncodingException {
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw new UnsupportedEncodingException(string);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new UnsupportedEncodingException(string);
        }
    }

    static Object newConverter(int n, String string) throws UnsupportedEncodingException {
        Class<?> clazz = Converters.getConverterClass(n, string);
        return Converters.newConverter(string, clazz);
    }

    private static Class<?> getDefaultConverterClass(int n) {
        Class<?> clazz;
        boolean bl = false;
        Class<Object> clazz2 = clazz = n == 0 ? btcDefault : ctbDefault;
        if (clazz != null) {
            return clazz;
        }
        String string = Converters.getDefaultEncodingName();
        if (string != null) {
            bl = true;
        } else {
            string = "ISO8859_1";
        }
        try {
            clazz = Converters.getConverterClass(n, string);
            if (bl) {
                if (n == 0) {
                    btcDefault = clazz;
                } else {
                    ctbDefault = clazz;
                }
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            try {
                clazz = Converters.getConverterClass(n, "ISO8859_1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException2) {
                throw new InternalError("Cannot find default " + converterPrefix[n] + " converter class");
            }
        }
        return clazz;
    }

    static Object newDefaultConverter(int n) {
        Class<?> clazz = Converters.getDefaultConverterClass(n);
        try {
            return Converters.newConverter("", clazz);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new InternalError("Cannot instantiate default converter class " + clazz.getName());
        }
    }

    static {
        DEFAULT_NAME = new Object();
        classCache = new SoftReference[][]{new SoftReference[3], new SoftReference[3]};
    }
}

