/*
 * Decompiled with CFR 0.152.
 */
package java.lang.ref;

import java.lang.ref.FinalReference;
import java.lang.ref.Reference;
import sun.misc.VM;

public class ReferenceQueue<T> {
    static ReferenceQueue NULL = new Null();
    static ReferenceQueue ENQUEUED = new Null();
    private Lock lock = new Lock();
    private volatile Reference<? extends T> head = null;
    private long queueLength = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean enqueue(Reference<? extends T> reference) {
        Reference<? extends T> reference2 = reference;
        synchronized (reference2) {
            if (reference.queue == ENQUEUED) {
                return false;
            }
            Lock lock = this.lock;
            synchronized (lock) {
                reference.queue = ENQUEUED;
                reference.next = this.head == null ? reference : this.head;
                this.head = reference;
                ++this.queueLength;
                if (reference instanceof FinalReference) {
                    VM.addFinalRefCount(1);
                }
                this.lock.notifyAll();
                return true;
            }
        }
    }

    private Reference<? extends T> reallyPoll() {
        if (this.head != null) {
            Reference<? extends T> reference = this.head;
            this.head = reference.next == reference ? null : reference.next;
            reference.queue = NULL;
            reference.next = reference;
            --this.queueLength;
            if (reference instanceof FinalReference) {
                VM.addFinalRefCount(-1);
            }
            return reference;
        }
        return null;
    }

    long getQueueDepth() {
        long l = 0L;
        if (this.head != null) {
            Reference reference = this.head;
            while (reference.next != reference) {
                reference = reference.next;
                ++l;
            }
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reference<? extends T> poll() {
        if (this.head == null) {
            return null;
        }
        Lock lock = this.lock;
        synchronized (lock) {
            return this.reallyPoll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reference<? extends T> remove(long l) throws IllegalArgumentException, InterruptedException {
        if (l < 0L) {
            throw new IllegalArgumentException("Negative timeout value");
        }
        Lock lock = this.lock;
        synchronized (lock) {
            Reference<T> reference = this.reallyPoll();
            if (reference != null) {
                return reference;
            }
            do {
                this.lock.wait(l);
                reference = this.reallyPoll();
                if (reference == null) continue;
                return reference;
            } while (l == 0L);
            return null;
        }
    }

    public Reference<? extends T> remove() throws InterruptedException {
        return this.remove(0L);
    }

    private static class Lock {
        private Lock() {
        }
    }

    private static class Null
    extends ReferenceQueue {
        private Null() {
        }

        boolean enqueue(Reference reference) {
            return false;
        }
    }
}

