/*
 * Decompiled with CFR 0.152.
 */
package com.eg.ch.qos.logback.classic.db;

import com.eg.ch.qos.logback.classic.db.DBHelper;
import com.eg.ch.qos.logback.classic.db.SQLBuilder;
import com.eg.ch.qos.logback.classic.db.names.DBNameResolver;
import com.eg.ch.qos.logback.classic.db.names.DefaultDBNameResolver;
import com.eg.ch.qos.logback.classic.spi.CallerData;
import com.eg.ch.qos.logback.classic.spi.ILoggingEvent;
import com.eg.ch.qos.logback.classic.spi.IThrowableProxy;
import com.eg.ch.qos.logback.classic.spi.StackTraceElementProxy;
import com.eg.ch.qos.logback.classic.spi.ThrowableProxyUtil;
import com.eg.ch.qos.logback.core.db.DBAppenderBase;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBAppender
extends DBAppenderBase<ILoggingEvent> {
    protected String insertPropertiesSQL;
    protected String insertExceptionSQL;
    protected String insertSQL;
    protected static final Method GET_GENERATED_KEYS_METHOD;
    private DBNameResolver dbNameResolver;
    static final int TIMESTMP_INDEX = 1;
    static final int FORMATTED_MESSAGE_INDEX = 2;
    static final int LOGGER_NAME_INDEX = 3;
    static final int LEVEL_STRING_INDEX = 4;
    static final int THREAD_NAME_INDEX = 5;
    static final int REFERENCE_FLAG_INDEX = 6;
    static final int ARG0_INDEX = 7;
    static final int ARG1_INDEX = 8;
    static final int ARG2_INDEX = 9;
    static final int ARG3_INDEX = 10;
    static final int CALLER_FILENAME_INDEX = 11;
    static final int CALLER_CLASS_INDEX = 12;
    static final int CALLER_METHOD_INDEX = 13;
    static final int CALLER_LINE_INDEX = 14;
    static final int EVENT_ID_INDEX = 15;
    static final StackTraceElement EMPTY_CALLER_DATA;

    public void setDbNameResolver(DBNameResolver dBNameResolver) {
        this.dbNameResolver = dBNameResolver;
    }

    @Override
    public void start() {
        if (this.dbNameResolver == null) {
            this.dbNameResolver = new DefaultDBNameResolver();
        }
        this.insertExceptionSQL = SQLBuilder.buildInsertExceptionSQL(this.dbNameResolver);
        this.insertPropertiesSQL = SQLBuilder.buildInsertPropertiesSQL(this.dbNameResolver);
        this.insertSQL = SQLBuilder.buildInsertSQL(this.dbNameResolver);
        super.start();
    }

    @Override
    protected void subAppend(ILoggingEvent iLoggingEvent, Connection connection, PreparedStatement preparedStatement) throws Throwable {
        this.bindLoggingEventWithInsertStatement(preparedStatement, iLoggingEvent);
        this.bindLoggingEventArgumentsWithPreparedStatement(preparedStatement, iLoggingEvent.getArgumentArray());
        this.bindCallerDataWithPreparedStatement(preparedStatement, iLoggingEvent.getCallerData());
        int n2 = preparedStatement.executeUpdate();
        if (n2 != 1) {
            this.addWarn("Failed to insert loggingEvent");
        }
    }

    @Override
    protected void secondarySubAppend(ILoggingEvent iLoggingEvent, Connection connection, long l2) throws Throwable {
        Map<String, String> map = this.mergePropertyMaps(iLoggingEvent);
        this.insertProperties(map, connection, l2);
        if (iLoggingEvent.getThrowableProxy() != null) {
            this.insertThrowable(iLoggingEvent.getThrowableProxy(), connection, l2);
        }
    }

    void bindLoggingEventWithInsertStatement(PreparedStatement preparedStatement, ILoggingEvent iLoggingEvent) throws SQLException {
        preparedStatement.setLong(1, iLoggingEvent.getTimeStamp());
        preparedStatement.setString(2, iLoggingEvent.getFormattedMessage());
        preparedStatement.setString(3, iLoggingEvent.getLoggerName());
        preparedStatement.setString(4, iLoggingEvent.getLevel().toString());
        preparedStatement.setString(5, iLoggingEvent.getThreadName());
        preparedStatement.setShort(6, DBHelper.computeReferenceMask(iLoggingEvent));
    }

    void bindLoggingEventArgumentsWithPreparedStatement(PreparedStatement preparedStatement, Object[] objectArray) throws SQLException {
        int n2;
        int n3 = objectArray != null ? objectArray.length : 0;
        for (n2 = 0; n2 < n3 && n2 < 4; ++n2) {
            preparedStatement.setString(7 + n2, this.asStringTruncatedTo254(objectArray[n2]));
        }
        if (n3 < 4) {
            for (n2 = n3; n2 < 4; ++n2) {
                preparedStatement.setString(7 + n2, null);
            }
        }
    }

    String asStringTruncatedTo254(Object object) {
        String string = null;
        if (object != null) {
            string = object.toString();
        }
        if (string == null) {
            return null;
        }
        if (string.length() <= 254) {
            return string;
        }
        return string.substring(0, 254);
    }

    void bindCallerDataWithPreparedStatement(PreparedStatement preparedStatement, StackTraceElement[] stackTraceElementArray) throws SQLException {
        StackTraceElement stackTraceElement = this.extractFirstCaller(stackTraceElementArray);
        preparedStatement.setString(11, stackTraceElement.getFileName());
        preparedStatement.setString(12, stackTraceElement.getClassName());
        preparedStatement.setString(13, stackTraceElement.getMethodName());
        preparedStatement.setString(14, Integer.toString(stackTraceElement.getLineNumber()));
    }

    private StackTraceElement extractFirstCaller(StackTraceElement[] stackTraceElementArray) {
        StackTraceElement stackTraceElement = EMPTY_CALLER_DATA;
        if (this.hasAtLeastOneNonNullElement(stackTraceElementArray)) {
            stackTraceElement = stackTraceElementArray[0];
        }
        return stackTraceElement;
    }

    private boolean hasAtLeastOneNonNullElement(StackTraceElement[] stackTraceElementArray) {
        return stackTraceElementArray != null && stackTraceElementArray.length > 0 && stackTraceElementArray[0] != null;
    }

    Map<String, String> mergePropertyMaps(ILoggingEvent iLoggingEvent) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Map<String, String> map = iLoggingEvent.getLoggerContextVO().getPropertyMap();
        Map<String, String> map2 = iLoggingEvent.getMDCPropertyMap();
        if (map != null) {
            hashMap.putAll(map);
        }
        if (map2 != null) {
            hashMap.putAll(map2);
        }
        return hashMap;
    }

    @Override
    protected Method getGeneratedKeysMethod() {
        return GET_GENERATED_KEYS_METHOD;
    }

    @Override
    protected String getInsertSQL() {
        return this.insertSQL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void insertProperties(Map<String, String> map, Connection connection, long l2) throws SQLException {
        Set<String> set = map.keySet();
        if (set.size() > 0) {
            PreparedStatement preparedStatement;
            block5: {
                preparedStatement = null;
                try {
                    preparedStatement = connection.prepareStatement(this.insertPropertiesSQL);
                    for (String string : set) {
                        String string2 = map.get(string);
                        preparedStatement.setLong(1, l2);
                        preparedStatement.setString(2, string);
                        preparedStatement.setString(3, string2);
                        if (this.cnxSupportsBatchUpdates) {
                            preparedStatement.addBatch();
                            continue;
                        }
                        preparedStatement.execute();
                    }
                    if (!this.cnxSupportsBatchUpdates) break block5;
                    preparedStatement.executeBatch();
                }
                catch (Throwable throwable) {
                    com.eg.ch.qos.logback.core.db.DBHelper.closeStatement(preparedStatement);
                    throw throwable;
                }
            }
            com.eg.ch.qos.logback.core.db.DBHelper.closeStatement(preparedStatement);
        }
    }

    void updateExceptionStatement(PreparedStatement preparedStatement, String string, short s2, long l2) throws SQLException {
        preparedStatement.setLong(1, l2);
        preparedStatement.setShort(2, s2);
        preparedStatement.setString(3, string);
        if (this.cnxSupportsBatchUpdates) {
            preparedStatement.addBatch();
        } else {
            preparedStatement.execute();
        }
    }

    short buildExceptionStatement(IThrowableProxy iThrowableProxy, short s2, PreparedStatement preparedStatement, long l2) throws SQLException {
        StringBuilder stringBuilder = new StringBuilder();
        ThrowableProxyUtil.subjoinFirstLine(stringBuilder, iThrowableProxy);
        short s3 = s2;
        s2 = (short)(s2 + 1);
        this.updateExceptionStatement(preparedStatement, stringBuilder.toString(), s3, l2);
        int n2 = iThrowableProxy.getCommonFrames();
        StackTraceElementProxy[] stackTraceElementProxyArray = iThrowableProxy.getStackTraceElementProxyArray();
        for (int i2 = 0; i2 < stackTraceElementProxyArray.length - n2; ++i2) {
            StringBuilder stringBuilder2 = new StringBuilder();
            stringBuilder2.append('\t');
            ThrowableProxyUtil.subjoinSTEP(stringBuilder2, stackTraceElementProxyArray[i2]);
            short s4 = s2;
            s2 = (short)(s2 + 1);
            this.updateExceptionStatement(preparedStatement, stringBuilder2.toString(), s4, l2);
        }
        if (n2 > 0) {
            StringBuilder stringBuilder3 = new StringBuilder();
            stringBuilder3.append('\t').append("... ").append(n2).append(" common frames omitted");
            short s5 = s2;
            s2 = (short)(s2 + 1);
            this.updateExceptionStatement(preparedStatement, stringBuilder3.toString(), s5, l2);
        }
        return s2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void insertThrowable(IThrowableProxy iThrowableProxy, Connection connection, long l2) throws SQLException {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(this.insertExceptionSQL);
            short s2 = 0;
            while (iThrowableProxy != null) {
                s2 = this.buildExceptionStatement(iThrowableProxy, s2, preparedStatement, l2);
                iThrowableProxy = iThrowableProxy.getCause();
            }
            if (this.cnxSupportsBatchUpdates) {
                preparedStatement.executeBatch();
            }
        }
        catch (Throwable throwable) {
            com.eg.ch.qos.logback.core.db.DBHelper.closeStatement(preparedStatement);
            throw throwable;
        }
        com.eg.ch.qos.logback.core.db.DBHelper.closeStatement(preparedStatement);
    }

    static {
        Method method;
        EMPTY_CALLER_DATA = CallerData.naInstance();
        try {
            method = PreparedStatement.class.getMethod("getGeneratedKeys", null);
        }
        catch (Exception exception) {
            method = null;
        }
        GET_GENERATED_KEYS_METHOD = method;
    }
}

