/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.transport.ormi;

import com.evermind.server.ThreadState;
import com.evermind.server.ejb.AbstractEJBHome;
import com.evermind.server.ejb.AbstractEJBObject;
import com.evermind.server.ejb.EJBUtils;
import com.evermind.server.ejb.EvermindHomeHandle;
import com.evermind.server.rmi.RMIServerConfig;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Enumeration;
import javax.ejb.EJBHome;
import javax.ejb.EJBObject;
import javax.ejb.Handle;
import javax.ejb.HomeHandle;
import javax.ejb.spi.HandleDelegate;
import javax.naming.Context;
import javax.rmi.CORBA.Stub;
import oracle.oc4j.transport.ApplicationTransportConfig;
import oracle.oc4j.transport.TransportManager;

public class OrmiTransportManager
extends TransportManager {
    private RMIServerConfig m_serverConfig;

    public OrmiTransportManager(RMIServerConfig serverConfig) {
        this.m_serverConfig = serverConfig;
    }

    public String getProviderUrl(String applicationName) {
        return "ormi://" + this.getHost() + ":" + this.m_serverConfig.getPort() + "/" + applicationName;
    }

    private String getHost() {
        String hostName = this.m_serverConfig.getAddress().getHostName();
        if (hostName.equals("0.0.0.0")) {
            hostName = "127.0.0.1";
        }
        return hostName;
    }

    public boolean supports(ApplicationTransportConfig config) {
        return !config.isIiopEnabled();
    }

    public boolean supports(Thread thread) {
        return true;
    }

    public HomeHandle getHomeHandle(AbstractEJBHome home) {
        return new EvermindHomeHandle(home.OC4J_getBindingPath(), (EJBHome)home);
    }

    public Handle getHandle(AbstractEJBObject ejbObject) throws RemoteException {
        return ejbObject.newOrmiHandle();
    }

    public Object exportObject(AbstractEJBObject obj) {
        return obj;
    }

    public void exportDBEntityObjectCollection(Collection wrappers) {
    }

    public Enumeration exportDBEntityObjectEnumeration(Enumeration wrappers) {
        return wrappers;
    }

    public void deactivateObject(AbstractEJBObject ejbObject, byte[] ejbKey) {
    }

    public boolean isIdentical(AbstractEJBObject ejbObject, Stub stub) {
        return false;
    }

    public boolean isRmiCall() {
        return ThreadState.getCurrentState().isCallerORMI();
    }

    public Object getTransportSpecificResponseObject(Object obj) {
        return obj;
    }

    public void createTransportApplicationContext(String appName, Context ctx) throws InstantiationException {
    }

    public Object cloneArray(Object array, AbstractEJBHome home) throws RemoteException {
        return EJBUtils.cloneArray(array, array.getClass(), home);
    }

    protected HandleDelegate doGetHandleDelegate() {
        return new HandleDelegate(){

            public void writeEJBObject(EJBObject ejbObject, ObjectOutputStream objectOutputStream) {
            }

            public EJBObject readEJBObject(ObjectInputStream objectInputStream) {
                return null;
            }

            public void writeEJBHome(EJBHome ejbHome, ObjectOutputStream objectOutputStream) {
            }

            public EJBHome readEJBHome(ObjectInputStream objectInputStream) {
                return null;
            }
        };
    }

    public void undeployApplication(String name) {
    }
}

