/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.sql.mbean;

import com.evermind.server.ApplicationServer;
import java.sql.SQLException;
import java.util.Map;
import oracle.dms.instrument.NounIntf;
import oracle.dms.instrument.Sensor;
import oracle.dms.instrument.SensorIntf;
import oracle.dms.instrument.State;
import oracle.dms.instrument.StateIntf;
import oracle.j2ee.datasource.DataSourceMessages;
import oracle.oc4j.admin.management.shared.statistic.dms.DMSBoundedRangeStatistic;
import oracle.oc4j.admin.management.shared.statistic.dms.DMSCountStatistic;
import oracle.oc4j.admin.management.shared.statistic.dms.DMSMetric;
import oracle.oc4j.admin.management.shared.statistic.dms.DMSStatistic;
import oracle.oc4j.sql.DataSourceConnectionPool;
import oracle.oc4j.sql.DataSourceException;
import oracle.oc4j.sql.mbean.DMSJDBCConnectionStats;

public class DMSJDBCConnectionPoolStats
extends DMSJDBCConnectionStats {
    public static final String STAT_NAME_CLOSE_CONNECTION_COUNT = "CloseConnectionCount";
    public static final String STAT_NAME_CREATE_CONNECTION_COUNT = "CreateConnectionCount";
    public static final String STAT_NAME_FREE_POOL_SIZE = "FreePoolSize";
    public static final String STAT_NAME_FREE_POOL_SIZE_UPPER_BOUND = "FreePoolSizeUpperBound";
    public static final String STAT_NAME_POOL_SIZE = "PoolSize";
    public static final String STAT_NAME_POOL_SIZE_LOWER_BOUND = "PoolSizeLowerBound";
    public static final String STAT_NAME_POOL_SIZE_UPPER_BOUND = "PoolSizeUpperBound";
    public static final String STAT_NAME_WAITING_THREAD_COUNT = "WaitingThreadCount";
    public static final String UNIT_NAME_CONNECTIONS = "connections";
    public static final String UNIT_NAME_THREADS = "threads";
    public static final String DMS_TYPE_JDBC_CONNECTION_POOL_CONNECTION_STATS = "jdbc_connection_pool_stats";
    private DataSourceConnectionPool m_dataSourceConnectionPool = null;
    private StateIntf m_createConnectionCountState;
    private StateIntf m_closeConnectionCountState;
    private StateIntf m_freePoolSizeUpperBoundState;
    private StateIntf m_freePoolSizeState;
    private StateIntf m_poolSizeLowerBoundState;
    private StateIntf m_poolSizeUpperBoundState;
    private StateIntf m_poolSizeState;
    private StateIntf m_waitingThreadCountState;
    private long m_freePoolSize = -1L;
    private long m_freePoolSizeUpperBound = 0L;
    private long m_poolSize = -1L;
    private long m_poolSizeLowerBound = -1L;
    private long m_poolSizeUpperBound = -1L;
    private long m_lastNumAvailableConnections = 0L;
    private long m_lastNumUsedConnections = 0L;
    private long m_lastMaxConnections = 0L;
    private long m_createConnectionCount = 0L;
    private long m_closeConnectionCount = 0L;
    private long m_waitingThreadCount = 0L;
    private long m_useTime = 0L;

    public DMSJDBCConnectionPoolStats(NounIntf parentNoun, DataSourceConnectionPool dataSourceConnectionPool) {
        super(parentNoun, dataSourceConnectionPool.getName(), DMS_TYPE_JDBC_CONNECTION_POOL_CONNECTION_STATS);
        this.m_dataSourceConnectionPool = dataSourceConnectionPool;
        this.updatePoolSizeLowerBound();
        this.updatePoolSizeUpperBound();
    }

    private void incrementCreateConnectionCount(long count) {
        if (this.m_createConnectionCountState != null) {
            this.m_createConnectionCountState.increment(count);
        }
    }

    private void updateCreateConnectionCount(long count) {
        if (this.m_createConnectionCountState != null) {
            this.m_createConnectionCountState.update(count);
        }
    }

    private void incrementCloseConnectionCount(long count) {
        if (this.m_closeConnectionCountState != null) {
            this.m_closeConnectionCountState.increment(count);
        }
    }

    private void updateCloseConnectionCount(long count) {
        if (this.m_closeConnectionCountState != null) {
            this.m_closeConnectionCountState.update(count);
        }
    }

    private void updateFreePoolSize(long freePoolSize) {
        if (this.m_freePoolSizeState != null && this.m_freePoolSize != freePoolSize) {
            this.m_freePoolSizeState.update(freePoolSize);
            this.m_freePoolSize = freePoolSize;
        }
    }

    private void updateFreePoolSizeUpperBound(long upperBound) {
        if (this.m_freePoolSizeUpperBoundState != null && this.m_freePoolSizeUpperBound != upperBound) {
            this.m_freePoolSizeUpperBoundState.update(upperBound);
            this.m_freePoolSizeUpperBound = upperBound;
        }
    }

    private void updatePoolSizeUpperBound() {
        if (this.m_poolSizeUpperBoundState != null && this.m_dataSourceConnectionPool != null) {
            long maxConnections = Integer.MAX_VALUE;
            try {
                maxConnections = this.m_dataSourceConnectionPool.getMaxConnections();
                if (maxConnections < 0L) {
                    maxConnections = Integer.MAX_VALUE;
                }
            }
            catch (DataSourceException e) {
                DataSourceMessages.warningUpdatePoolSizeUpperBoundGetMaxConnections(this.m_dataSourceConnectionPool.getName(), e);
            }
            if (this.m_poolSizeUpperBound != maxConnections) {
                this.m_poolSizeUpperBoundState.update(maxConnections);
                this.m_poolSizeUpperBound = maxConnections;
            }
        }
    }

    private void updatePoolSizeLowerBound() {
        if (this.m_poolSizeLowerBoundState != null && this.m_dataSourceConnectionPool != null) {
            long minConnections = 0L;
            try {
                minConnections = this.m_dataSourceConnectionPool.getMinConnections();
            }
            catch (DataSourceException e) {
                DataSourceMessages.warningUpdatePoolSizeLowerBoundGetMinConnections(this.m_dataSourceConnectionPool.getName(), e);
            }
            if (this.m_poolSizeLowerBound != minConnections) {
                this.m_poolSizeLowerBoundState.update(minConnections);
                this.m_poolSizeLowerBound = minConnections;
            }
        }
    }

    private void updatePoolSize(long poolSize) {
        if (this.m_poolSizeState != null && this.m_poolSize != poolSize) {
            this.m_poolSizeState.update(poolSize);
            this.m_poolSize = poolSize;
        }
    }

    public DMSStatistic[] getDMSStatisticDefinitions() {
        if (this.getDmsNoun() != null) {
            DMSMetric closeConnectionCountStateMetric = new DMSMetric((Sensor)((State)this.m_closeConnectionCountState), STAT_NAME_CLOSE_CONNECTION_COUNT, this.m_statsLocalizationHelper.getLocalizedMessage("stats_jdbcconnectionpoolstats_closeconnectioncount"), null);
            DMSMetric createConnectionCountStateMetric = new DMSMetric((Sensor)((State)this.m_createConnectionCountState), STAT_NAME_CREATE_CONNECTION_COUNT, this.m_statsLocalizationHelper.getLocalizedMessage("stats_jdbcconnectionpoolstats_createconnectioncount"), null);
            DMSMetric freePoolMetric = new DMSMetric((Sensor)((State)this.m_freePoolSizeState), -1, STAT_NAME_FREE_POOL_SIZE, this.m_statsLocalizationHelper.getLocalizedMessage("stats_jdbcconnectionpoolstats_freepoolsize"), null, null, null, this.getMetricName((SensorIntf)this.m_freePoolSizeUpperBoundState, ".value"), null);
            DMSMetric poolMetric = new DMSMetric((Sensor)((State)this.m_poolSizeState), -1, STAT_NAME_POOL_SIZE, this.m_statsLocalizationHelper.getLocalizedMessage("stats_jdbcconnectionpoolstats_poolsize"), null, null, null, this.getMetricName((SensorIntf)this.m_poolSizeUpperBoundState, ".value"), this.getMetricName((SensorIntf)this.m_poolSizeLowerBoundState, ".value"));
            DMSMetric waitingThreadCountMetric = new DMSMetric((Sensor)((State)this.m_waitingThreadCountState), -1, STAT_NAME_WAITING_THREAD_COUNT, this.m_statsLocalizationHelper.getLocalizedMessage("stats_jdbcconnectionpoolstats_waitingthreadcount"), null, null, null, null, null);
            DMSStatistic[] superStats = super.getDMSStatisticDefinitions();
            DMSStatistic[] stats = new DMSStatistic[superStats.length + 5];
            for (int i = 0; i < superStats.length; ++i) {
                stats[i] = superStats[i];
            }
            stats[superStats.length + 0] = new DMSCountStatistic(closeConnectionCountStateMetric);
            stats[superStats.length + 1] = new DMSCountStatistic(createConnectionCountStateMetric);
            stats[superStats.length + 2] = new DMSBoundedRangeStatistic(freePoolMetric);
            stats[superStats.length + 3] = new DMSBoundedRangeStatistic(poolMetric);
            stats[superStats.length + 4] = new DMSBoundedRangeStatistic(waitingThreadCountMetric);
            return stats;
        }
        return new DMSStatistic[0];
    }

    private String getMetricName(SensorIntf sensor, String metric) {
        return "/" + this.getParentNoun().getName() + "/" + this.getDmsNoun().getName() + "/" + sensor.getName() + metric;
    }

    protected void createStats() {
        super.createStats();
        NounIntf dmsNoun = this.getDmsNoun();
        if (dmsNoun != null) {
            this.m_createConnectionCountState = ApplicationServer.stateFactory().create(dmsNoun, STAT_NAME_CREATE_CONNECTION_COUNT, (byte)2, UNIT_NAME_CONNECTIONS, this.m_statsLocalizationHelper.getLocalizedMessage("stats_jdbcconnectionpoolstats_createconnectioncount"));
            this.m_createConnectionCountState.deriveMetric(1);
            this.m_closeConnectionCountState = ApplicationServer.stateFactory().create(dmsNoun, STAT_NAME_CLOSE_CONNECTION_COUNT, (byte)2, UNIT_NAME_CONNECTIONS, this.m_statsLocalizationHelper.getLocalizedMessage("stats_jdbcconnectionpoolstats_closeconnectioncount"));
            this.m_closeConnectionCountState.deriveMetric(1);
            this.m_freePoolSizeUpperBoundState = ApplicationServer.stateFactory().create(dmsNoun, STAT_NAME_FREE_POOL_SIZE_UPPER_BOUND, (byte)2, UNIT_NAME_CONNECTIONS, this.m_statsLocalizationHelper.getLocalizedMessage("stats_jdbcconnectionpoolstats_freepoolsizeupperbound"));
            this.m_freePoolSizeUpperBoundState.deriveMetric(1);
            this.m_freePoolSizeState = ApplicationServer.stateFactory().create(dmsNoun, STAT_NAME_FREE_POOL_SIZE, (byte)2, UNIT_NAME_CONNECTIONS, this.m_statsLocalizationHelper.getLocalizedMessage("stats_jdbcconnectionpoolstats_freepoolsize"));
            this.m_freePoolSizeState.deriveMetric(13);
            this.m_poolSizeLowerBoundState = ApplicationServer.stateFactory().create(dmsNoun, STAT_NAME_POOL_SIZE_LOWER_BOUND, (byte)2, UNIT_NAME_CONNECTIONS, this.m_statsLocalizationHelper.getLocalizedMessage("stats_jdbcconnectionpoolstats_poolsizelowerbound"));
            this.m_poolSizeLowerBoundState.deriveMetric(1);
            this.updatePoolSizeLowerBound();
            this.m_poolSizeUpperBoundState = ApplicationServer.stateFactory().create(dmsNoun, STAT_NAME_POOL_SIZE_UPPER_BOUND, (byte)2, UNIT_NAME_CONNECTIONS, this.m_statsLocalizationHelper.getLocalizedMessage("stats_jdbcconnectionpoolstats_poolsizeupperbound"));
            this.m_poolSizeUpperBoundState.deriveMetric(1);
            this.updatePoolSizeUpperBound();
            this.m_poolSizeState = ApplicationServer.stateFactory().create(dmsNoun, STAT_NAME_POOL_SIZE, (byte)2, UNIT_NAME_CONNECTIONS, this.m_statsLocalizationHelper.getLocalizedMessage("stats_jdbcconnectionpoolstats_poolsize"));
            this.m_poolSizeState.deriveMetric(13);
            this.m_waitingThreadCountState = ApplicationServer.stateFactory().create(dmsNoun, STAT_NAME_WAITING_THREAD_COUNT, (byte)2, UNIT_NAME_THREADS, this.m_statsLocalizationHelper.getLocalizedMessage("stats_jdbcconnectionpoolstats_waitingthreadcount"));
            this.m_waitingThreadCountState.deriveMetric(13);
            this.m_waitingThreadCountState.update(0);
        }
    }

    public synchronized void connectionCreated() {
        ++this.m_createConnectionCount;
    }

    public synchronized void connectionClosed() {
        ++this.m_closeConnectionCount;
    }

    public synchronized void incrementWaitingThreadCount(long count) {
        this.m_waitingThreadCount += count;
    }

    public synchronized void incrementUseTime(long useTime) {
        this.m_useTime += useTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDMSStats() {
        long numAvailableConnections = 0L;
        long numUsedConnections = 0L;
        long maxConnections = 0L;
        Object object = this.m_dataSourceConnectionPool;
        synchronized (object) {
            try {
                numAvailableConnections = this.m_dataSourceConnectionPool.getNumAvailableConnections();
                numUsedConnections = this.m_dataSourceConnectionPool.getNumUsedConnections();
                maxConnections = this.m_dataSourceConnectionPool.getMaxConnections();
            }
            catch (Exception e) {
                DataSourceMessages.warningUpdatePoolSizesGetPoolSizes(this.m_dataSourceConnectionPool.getName(), e);
            }
        }
        object = this;
        synchronized (object) {
            if (this.m_lastNumAvailableConnections != numAvailableConnections || this.m_lastNumUsedConnections != numUsedConnections || this.m_lastMaxConnections != maxConnections) {
                this.updateFreePoolSize(numAvailableConnections);
                this.updateFreePoolSizeUpperBound(maxConnections);
                this.updatePoolSize(numAvailableConnections + numUsedConnections);
                this.updatePoolSizeLowerBound();
                this.updatePoolSizeUpperBound();
                this.m_lastNumAvailableConnections = numAvailableConnections;
                this.m_lastNumUsedConnections = numUsedConnections;
                this.m_lastMaxConnections = maxConnections;
            }
            if (this.m_dataSourceConnectionPool.isICC()) {
                Object occm = this.m_dataSourceConnectionPool.getCacheManager();
                int closedCount = 0;
                int createdCount = 0;
                if (occm != null) {
                    String cacheName = this.m_dataSourceConnectionPool.getCacheName();
                    Map map = null;
                    try {
                        try {
                            Class[] paramTypes = new Class[]{String.class};
                            Object[] args = new Object[]{cacheName};
                            map = (Map)occm.getClass().getMethod("getStatistics", paramTypes).invoke(occm, args);
                        }
                        catch (Exception e) {
                            SQLException se = new SQLException(e.toString());
                            se.initCause(e);
                            throw se;
                        }
                        if (map != null) {
                            Class<?> OracleConnectionCacheManagerClass = Class.forName("oracle.jdbc.pool.OracleConnectionCacheManager", true, occm.getClass().getClassLoader());
                            String key = (String)OracleConnectionCacheManagerClass.getField("PHYSICAL_CONNECTION_CLOSED_COUNT").get(null);
                            Integer count = (Integer)map.get(key);
                            if (count != null) {
                                closedCount = count;
                            }
                            if ((count = (Integer)map.get(key = (String)OracleConnectionCacheManagerClass.getField("PHYSICAL_CONNECTION_CREATED_COUNT").get(null))) != null) {
                                createdCount = count;
                            }
                        }
                    }
                    catch (Exception e) {
                        DataSourceMessages.warningGettingICCStatistics(cacheName, e);
                    }
                }
                if ((long)closedCount != this.m_closeConnectionCount) {
                    this.m_closeConnectionCount = closedCount;
                    this.updateCloseConnectionCount(this.m_closeConnectionCount);
                }
                if ((long)createdCount != this.m_createConnectionCount) {
                    this.m_createConnectionCount = createdCount;
                    this.updateCreateConnectionCount(this.m_createConnectionCount);
                }
            } else {
                if (this.m_closeConnectionCount > 0L) {
                    this.incrementCloseConnectionCount(this.m_closeConnectionCount);
                    this.m_closeConnectionCount = 0L;
                }
                if (this.m_createConnectionCount > 0L) {
                    this.incrementCreateConnectionCount(this.m_createConnectionCount);
                    this.m_createConnectionCount = 0L;
                }
            }
            if (this.m_waitingThreadCount != 0L) {
                if (this.m_waitingThreadCountState != null) {
                    this.m_waitingThreadCountState.increment(this.m_waitingThreadCount);
                }
                this.m_waitingThreadCount = 0L;
            }
            if (this.m_useTime != 0L) {
                super.incrementUseTime(this.m_useTime);
                this.m_useTime = 0L;
            }
        }
    }

    protected DataSourceConnectionPool getDataSourceConnectionPool() {
        return this.m_dataSourceConnectionPool;
    }

    public long getFreePoolSize() {
        return this.m_freePoolSize;
    }

    public long getFreePoolSizeUpperBound() {
        return this.m_freePoolSizeUpperBound;
    }

    public long getPoolSize() {
        return this.m_poolSize;
    }

    public long getPoolSizeLowerBound() {
        return this.m_poolSizeLowerBound;
    }

    public long getPoolSizeUpperBound() {
        return this.m_poolSizeUpperBound;
    }

    public long getLastNumAvailableConnections() {
        return this.m_lastNumAvailableConnections;
    }

    public long getLastNumUsedConnections() {
        return this.m_lastNumUsedConnections;
    }

    public long getLastMaxConnections() {
        return this.m_lastMaxConnections;
    }

    public long getCreateConnectionCount() {
        return this.m_createConnectionCount;
    }

    public long getCloseConnectionCount() {
        return this.m_closeConnectionCount;
    }

    public long getWaitingThreadCount() {
        return this.m_waitingThreadCount;
    }

    public long getUseTime() {
        return this.m_useTime;
    }
}

