/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.sql.config;

import com.evermind.security.SecuritySensitive;
import com.evermind.xml.XMLUtils;
import java.io.StringWriter;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLInput;
import java.sql.SQLOutput;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import oracle.j2ee.datasource.DataSourceMessages;
import oracle.oc4j.sql.DataSourceConnectionFactory;
import oracle.oc4j.sql.DataSourceConnectionFactoryImpl;
import oracle.oc4j.sql.DataSourceConnectionPoolDataSource;
import oracle.oc4j.sql.DataSourceException;
import oracle.oc4j.sql.DataSourceUtils;
import oracle.oc4j.sql.DriverDataSource;
import oracle.oc4j.sql.config.ConfigObject;
import oracle.oc4j.sql.config.ConnectionFactoryConfig;
import oracle.oc4j.sql.config.ConnectionPoolConfig;
import oracle.oc4j.sql.config.DataSourceConfigException;
import oracle.oc4j.sql.config.ErrorCodeConfig;
import oracle.oc4j.sql.config.FatalErrorCodesConfig;
import oracle.oc4j.sql.config.ManagedDataSourceConfig;
import oracle.oc4j.sql.config.NativeDataSourceConfig;
import oracle.oc4j.sql.config.PropertyConfig;
import oracle.oc4j.sql.config.ProxyInterfaceConfig;
import oracle.oc4j.sql.config.XARecoveryConfig;
import oracle.oc4j.sql.xa.EmulatedXADataSource;
import oracle.oc4j.sql.xa.GenericRecoverableCommitStrategy;
import oracle.oc4j.sql.xa.ICCXADataSource;
import oracle.oc4j.sql.xa.OracleRecoverableCommitStrategy;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DataSourceConfigUtils {
    public static boolean doesPropertyExist(PropertyConfig[] existingProperties, PropertyConfig property) {
        if (property == null) {
            return false;
        }
        return DataSourceConfigUtils.doesPropertyExist(existingProperties, property.getName());
    }

    public static boolean doesPropertyExist(PropertyConfig[] existingProperties, String propertyName) {
        if (existingProperties == null || propertyName == null) {
            return false;
        }
        for (int i = 0; i < existingProperties.length; ++i) {
            if (!existingProperties[i].getName().equals(propertyName)) continue;
            return true;
        }
        return false;
    }

    public static String getPropertyValue(PropertyConfig[] existingProperties, String propertyName, String defaultValue) {
        if (existingProperties == null || propertyName == null) {
            return defaultValue;
        }
        for (int i = 0; i < existingProperties.length; ++i) {
            if (!existingProperties[i].getName().equals(propertyName)) continue;
            return existingProperties[i].getValue();
        }
        return defaultValue;
    }

    public static String getAttribute(Node node, String attributeName) {
        String attribute = XMLUtils.getNodeAttribute(node, attributeName);
        if (attribute == null) {
            attribute = "";
        }
        return attribute.trim();
    }

    public static int getIntAttribute(Node node, String attributeName, int defaultValue) throws DataSourceConfigException {
        return DataSourceConfigUtils.getIntAttribute(node, attributeName, true, defaultValue);
    }

    public static int getIntAttribute(Node node, String attributeName, boolean emptyAllowed, int defaultValue) throws DataSourceConfigException {
        String attribute = XMLUtils.getNodeAttribute(node, attributeName);
        if (attribute == null) {
            attribute = "";
        }
        if ((attribute = attribute.trim()).length() == 0) {
            if (emptyAllowed) {
                return defaultValue;
            }
            throw new DataSourceConfigException("The " + attributeName + " cannot be empty.");
        }
        int value = defaultValue;
        try {
            value = new Integer(attribute);
        }
        catch (NumberFormatException numberFormatException) {
            throw new DataSourceConfigException(numberFormatException.getMessage());
        }
        return value;
    }

    public static boolean getBooleanAttribute(Node node, String attributeName, boolean defaultValue) {
        String attribute = XMLUtils.getNodeAttribute(node, attributeName);
        if (attribute == null) {
            attribute = "";
        }
        if ((attribute = attribute.trim()).length() == 0) {
            return defaultValue;
        }
        return new Boolean(attribute);
    }

    public static PropertyConfig[] getPropertyConfigs(Node parentNode, String propertyNodeName) throws DataSourceConfigException {
        if (parentNode == null) {
            return new PropertyConfig[0];
        }
        Vector<PropertyConfig> properties = new Vector<PropertyConfig>();
        NodeList nodes = parentNode.getChildNodes();
        if (nodes != null) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                String name = node.getNodeName();
                if (!name.equals(propertyNodeName)) continue;
                properties.add(new PropertyConfig(node));
            }
        }
        int numProperties = properties.size();
        PropertyConfig[] propertyConnfigs = new PropertyConfig[numProperties];
        for (int i = 0; i < numProperties; ++i) {
            propertyConnfigs[i] = (PropertyConfig)properties.get(i);
        }
        return propertyConnfigs;
    }

    public static String trimEmptyNotAllowed(String configItem, String configItemName) throws DataSourceConfigException {
        if (configItemName == null) {
            configItemName = "";
        }
        if (configItem == null) {
            configItem = "";
        }
        if ((configItem = configItem.trim()).length() == 0) {
            throw new DataSourceConfigException("The " + configItemName + " cannot be empty.");
        }
        return configItem;
    }

    public static String trim(String configItem) {
        if (configItem == null) {
            configItem = "";
        }
        return configItem.trim();
    }

    public static DataSourceConnectionFactory createConnectionFactory(ConnectionFactoryConfig connectionFactoryConfig, ClassLoader loader) throws DataSourceConfigException, DataSourceException {
        PropertyConfig[] connectionProperties;
        String user = connectionFactoryConfig.getUser();
        String password = connectionFactoryConfig.getPassword();
        String url = connectionFactoryConfig.getUrl();
        int loginTimeout = connectionFactoryConfig.getLoginTimeout();
        Object connectionFactory = null;
        Class<?> clazz = null;
        try {
            clazz = Class.forName(connectionFactoryConfig.getFactoryClass(), true, loader);
            connectionFactory = clazz.newInstance();
        }
        catch (Exception exception) {
            throw new DataSourceConfigException("Unable to create : " + connectionFactoryConfig.getFactoryClass(), exception);
        }
        XADataSource xaDataSource = null;
        ConnectionPoolDataSource connectionPoolDataSource = null;
        boolean isOracleDataSource = DataSourceUtils.isClass(connectionFactory.getClass(), "oracle.jdbc.pool.OracleDataSource");
        if (connectionFactory instanceof XADataSource) {
            String propertyValue = DataSourceConfigUtils.getPropertyValue(connectionFactoryConfig.getProperties(), "connectionCachingEnabled", "true");
            boolean connectionCachingEnabled = new Boolean(propertyValue);
            boolean driverUsesICC = false;
            boolean isOracleXADataSource = false;
            if (connectionCachingEnabled) {
                driverUsesICC = true;
                isOracleXADataSource = DataSourceUtils.isClass(connectionFactory.getClass(), "oracle.jdbc.xa.client.OracleXADataSource");
                if (isOracleXADataSource) {
                    try {
                        Class[] paramTypes = new Class[]{Boolean.TYPE};
                        Object[] args = new Object[]{new Boolean(false)};
                        connectionFactory.getClass().getMethod("setConnectionCachingEnabled", paramTypes).invoke(connectionFactory, args);
                    }
                    catch (Exception e) {
                        driverUsesICC = false;
                    }
                }
            }
            xaDataSource = (XADataSource)connectionFactory;
            DataSourceUtils.setUser(xaDataSource, user);
            DataSourceUtils.setPassword(xaDataSource, password);
            DataSourceUtils.setUrl(xaDataSource, url);
            DataSourceConfigUtils.setLoginTimeout(xaDataSource, loginTimeout, connectionFactoryConfig);
            DataSourceUtils.setProperties(connectionFactory, connectionFactoryConfig.getProperties());
            if (isOracleXADataSource && driverUsesICC) {
                xaDataSource = new ICCXADataSource((DataSource)connectionFactory);
            }
        } else if (connectionFactory instanceof ConnectionPoolDataSource) {
            connectionPoolDataSource = (ConnectionPoolDataSource)connectionFactory;
            DataSourceUtils.setUser(connectionPoolDataSource, user);
            DataSourceUtils.setPassword(connectionPoolDataSource, password);
            DataSourceUtils.setUrl(connectionPoolDataSource, url);
            DataSourceConfigUtils.setLoginTimeout(connectionPoolDataSource, loginTimeout, connectionFactoryConfig);
            DataSourceUtils.setProperties(connectionFactory, connectionFactoryConfig.getProperties());
        } else if (connectionFactory instanceof DataSource) {
            DataSource ds = (DataSource)connectionFactory;
            DataSourceUtils.setUser(ds, user);
            DataSourceUtils.setPassword(ds, password);
            DataSourceUtils.setUrl(ds, url);
            DataSourceConfigUtils.setLoginTimeout(ds, loginTimeout, connectionFactoryConfig);
            DataSourceUtils.setProperties(connectionFactory, connectionFactoryConfig.getProperties());
            connectionPoolDataSource = new DataSourceConnectionPoolDataSource(ds);
        } else if (connectionFactory instanceof Driver) {
            connectionPoolDataSource = new DataSourceConnectionPoolDataSource(DataSourceConfigUtils.createDriverDataSource((Driver)connectionFactory, connectionFactoryConfig));
        } else {
            throw new DataSourceException("Connection Factory must be one of: Driver, DataSource, ConnectionPoolDataSource, or XADataSource.  It is: " + clazz.getName());
        }
        if (connectionPoolDataSource != null) {
            GenericRecoverableCommitStrategy strategy = isOracleDataSource ? new OracleRecoverableCommitStrategy(connectionFactoryConfig.getCommitRecordTableName()) : new GenericRecoverableCommitStrategy(connectionFactoryConfig.getCommitRecordTableName());
            xaDataSource = new EmulatedXADataSource(connectionPoolDataSource, strategy);
        }
        if ((connectionProperties = connectionFactoryConfig.getConnectionPropertiesConfig().getProperties()).length > 0 && isOracleDataSource) {
            Properties properties = new Properties();
            for (int i = 0; i < connectionProperties.length; ++i) {
                properties.put(connectionProperties[i].getName(), connectionProperties[i].getValue());
            }
            try {
                Class[] paramTypes = new Class[]{Properties.class};
                Object[] args = new Object[]{properties};
                connectionFactory.getClass().getMethod("setConnectionProperties", paramTypes).invoke(connectionFactory, args);
            }
            catch (Exception e) {
                throw new DataSourceException("Exception occurred setting the connection properties.", e);
            }
        }
        return new DataSourceConnectionFactoryImpl(xaDataSource, connectionFactory, connectionFactoryConfig);
    }

    protected static DriverDataSource createDriverDataSource(Driver driver, ConnectionFactoryConfig connectionFactoryConfig) throws DataSourceConfigException, DataSourceException {
        DriverDataSource driverDataSource = new DriverDataSource(driver);
        driverDataSource.setUser(connectionFactoryConfig.getUser());
        String password = connectionFactoryConfig.getPassword();
        SecuritySensitive securitySensitive = SecuritySensitive.global();
        if (securitySensitive != null) {
            password = securitySensitive.decode(password, null);
        }
        driverDataSource.setPassword(password);
        driverDataSource.setUrl(connectionFactoryConfig.getUrl());
        try {
            driverDataSource.setLoginTimeout(connectionFactoryConfig.getLoginTimeout());
        }
        catch (SQLException sqlException) {
            String msg = DataSourceMessages.severeCreateDriverDataSourceException(connectionFactoryConfig.getFactoryClass(), sqlException);
            throw new DataSourceConfigException(msg, sqlException);
        }
        PropertyConfig[] properties = connectionFactoryConfig.getProperties();
        for (int i = 0; i < properties.length; ++i) {
            driverDataSource.setDriverProperty(properties[i].getName(), properties[i].getValue());
        }
        return driverDataSource;
    }

    public static DataSource createDataSource(String dataSourceClassName) throws DataSourceException {
        DataSource dataSource = null;
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> clazz = Class.forName(dataSourceClassName, true, loader);
            dataSource = (DataSource)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new DataSourceException("Unable to create: " + dataSourceClassName, exception);
        }
        return dataSource;
    }

    private static void setLoginTimeout(DataSource ds, int loginTimeout, ConnectionFactoryConfig connectionFactoryConfig) throws DataSourceException {
        try {
            ds.setLoginTimeout(loginTimeout);
        }
        catch (SQLException sqlException) {
            String msg = DataSourceMessages.severeSetDataSourceLoginTimeout(connectionFactoryConfig.getFactoryClass(), sqlException);
            throw new DataSourceException(msg, sqlException);
        }
    }

    private static void setLoginTimeout(ConnectionPoolDataSource connectionPoolDataSource, int loginTimeout, ConnectionFactoryConfig connectionFactoryConfig) throws DataSourceException {
        try {
            connectionPoolDataSource.setLoginTimeout(loginTimeout);
        }
        catch (SQLException sqlException) {
            String msg = DataSourceMessages.severeSetConnectionPoolDataSourceLoginTimeout(connectionFactoryConfig.getFactoryClass(), sqlException);
            throw new DataSourceException(msg);
        }
    }

    private static void setLoginTimeout(XADataSource xaDataSource, int loginTimeout, ConnectionFactoryConfig connectionFactoryConfig) throws DataSourceConfigException {
        try {
            xaDataSource.setLoginTimeout(loginTimeout);
        }
        catch (SQLException sqlException) {
            String msg = DataSourceMessages.severeSetXADataSourceLoginTimeout(connectionFactoryConfig.getFactoryClass(), sqlException);
            throw new DataSourceConfigException(msg);
        }
    }

    public static Map createProxyInterfaceMap(ProxyInterfaceConfig[] proxies) {
        HashMap map = new HashMap();
        if (proxies == null) {
            return map;
        }
        HashSet arrayProxies = null;
        HashSet blobProxies = null;
        HashSet callableStatementProxies = null;
        HashSet clobProxies = null;
        HashSet connectionProxies = null;
        HashSet databaseMetaDataProxies = null;
        HashSet parameterMetaDataProxies = null;
        HashSet preparedStatementProxies = null;
        HashSet refProxies = null;
        HashSet resultSetProxies = null;
        HashSet resultSetMetaDataProxies = null;
        HashSet savepointProxies = null;
        HashSet sqlDataProxies = null;
        HashSet sqlInputProxies = null;
        HashSet sqlOutputProxies = null;
        HashSet statementProxies = null;
        HashSet structProxies = null;
        for (int i = 0; i < proxies.length; ++i) {
            ProxyInterfaceConfig proxy = proxies[i];
            String sqlObject = proxy.getSqlObject();
            String interfaceName = proxy.getInterface();
            if (sqlObject.equals("Array")) {
                arrayProxies = DataSourceConfigUtils.makeProxyInterfaceEntry(arrayProxies, interfaceName);
                continue;
            }
            if (sqlObject.equals("Blob")) {
                blobProxies = DataSourceConfigUtils.makeProxyInterfaceEntry(blobProxies, interfaceName);
                continue;
            }
            if (sqlObject.equals("CallableStatement")) {
                callableStatementProxies = DataSourceConfigUtils.makeProxyInterfaceEntry(callableStatementProxies, interfaceName);
                continue;
            }
            if (sqlObject.equals("Clob")) {
                clobProxies = DataSourceConfigUtils.makeProxyInterfaceEntry(clobProxies, interfaceName);
                continue;
            }
            if (sqlObject.equals("Connection")) {
                connectionProxies = DataSourceConfigUtils.makeProxyInterfaceEntry(connectionProxies, interfaceName);
                continue;
            }
            if (sqlObject.equals("DatabaseMetaData")) {
                databaseMetaDataProxies = DataSourceConfigUtils.makeProxyInterfaceEntry(databaseMetaDataProxies, interfaceName);
                continue;
            }
            if (sqlObject.equals("ParameterMetaData")) {
                parameterMetaDataProxies = DataSourceConfigUtils.makeProxyInterfaceEntry(parameterMetaDataProxies, interfaceName);
                continue;
            }
            if (sqlObject.equals("PreparedStatement")) {
                preparedStatementProxies = DataSourceConfigUtils.makeProxyInterfaceEntry(preparedStatementProxies, interfaceName);
                continue;
            }
            if (sqlObject.equals("Ref")) {
                refProxies = DataSourceConfigUtils.makeProxyInterfaceEntry(refProxies, interfaceName);
                continue;
            }
            if (sqlObject.equals("ResultSet")) {
                resultSetProxies = DataSourceConfigUtils.makeProxyInterfaceEntry(resultSetProxies, interfaceName);
                continue;
            }
            if (sqlObject.equals("ResultSetMetaData")) {
                resultSetMetaDataProxies = DataSourceConfigUtils.makeProxyInterfaceEntry(resultSetMetaDataProxies, interfaceName);
                continue;
            }
            if (sqlObject.equals("Savepoint")) {
                savepointProxies = DataSourceConfigUtils.makeProxyInterfaceEntry(savepointProxies, interfaceName);
                continue;
            }
            if (sqlObject.equals("SQLData")) {
                sqlDataProxies = DataSourceConfigUtils.makeProxyInterfaceEntry(sqlDataProxies, interfaceName);
                continue;
            }
            if (sqlObject.equals("SQLInput")) {
                sqlInputProxies = DataSourceConfigUtils.makeProxyInterfaceEntry(sqlInputProxies, interfaceName);
                continue;
            }
            if (sqlObject.equals("SQLOutput")) {
                sqlOutputProxies = DataSourceConfigUtils.makeProxyInterfaceEntry(sqlOutputProxies, interfaceName);
                continue;
            }
            if (sqlObject.equals("Statement")) {
                statementProxies = DataSourceConfigUtils.makeProxyInterfaceEntry(statementProxies, interfaceName);
                continue;
            }
            if (sqlObject.equals("Struct")) {
                structProxies = DataSourceConfigUtils.makeProxyInterfaceEntry(structProxies, interfaceName);
                continue;
            }
            DataSourceMessages.warningExceptionSettingProxyInterfaces(sqlObject, interfaceName);
        }
        DataSourceConfigUtils.addToMap(map, Array.class, arrayProxies);
        DataSourceConfigUtils.addToMap(map, Blob.class, blobProxies);
        DataSourceConfigUtils.addToMap(map, CallableStatement.class, callableStatementProxies);
        DataSourceConfigUtils.addToMap(map, Clob.class, clobProxies);
        DataSourceConfigUtils.addToMap(map, Connection.class, connectionProxies);
        DataSourceConfigUtils.addToMap(map, DatabaseMetaData.class, databaseMetaDataProxies);
        DataSourceConfigUtils.addToMap(map, ParameterMetaData.class, parameterMetaDataProxies);
        DataSourceConfigUtils.addToMap(map, PreparedStatement.class, preparedStatementProxies);
        DataSourceConfigUtils.addToMap(map, Ref.class, refProxies);
        DataSourceConfigUtils.addToMap(map, ResultSet.class, resultSetProxies);
        DataSourceConfigUtils.addToMap(map, ResultSetMetaData.class, resultSetMetaDataProxies);
        DataSourceConfigUtils.addToMap(map, Savepoint.class, savepointProxies);
        DataSourceConfigUtils.addToMap(map, SQLData.class, sqlDataProxies);
        DataSourceConfigUtils.addToMap(map, SQLInput.class, sqlInputProxies);
        DataSourceConfigUtils.addToMap(map, SQLOutput.class, sqlOutputProxies);
        DataSourceConfigUtils.addToMap(map, Statement.class, statementProxies);
        DataSourceConfigUtils.addToMap(map, Struct.class, structProxies);
        return map;
    }

    private static void addToMap(Map map, Class key, HashSet proxySet) {
        if (proxySet != null) {
            int size = proxySet.size();
            Class[] array = new Class[size];
            int i = 0;
            Iterator iter = proxySet.iterator();
            while (iter.hasNext()) {
                array[i++] = (Class)iter.next();
            }
            map.put(key, array);
        }
    }

    private static HashSet makeProxyInterfaceEntry(HashSet proxies, String interfaceName) {
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> clazz = Class.forName(interfaceName, true, loader);
            if (proxies == null) {
                proxies = new HashSet();
            }
            proxies.add(clazz);
        }
        catch (ClassNotFoundException cnfe) {
            DataSourceMessages.warningClassNotFoundExceptionCreatingProxyInterface(interfaceName, cnfe);
        }
        return proxies;
    }

    public static PropertyConfig[] removePropertyConfig(PropertyConfig[] propertyConfigs, String propertyConfigName) {
        if (propertyConfigs == null) {
            return new PropertyConfig[0];
        }
        if (propertyConfigName == null) {
            return propertyConfigs;
        }
        for (int i = 0; i < propertyConfigs.length; ++i) {
            if (!propertyConfigs[i].getName().equals(propertyConfigName)) continue;
            PropertyConfig[] newPropertyConfigs = new PropertyConfig[propertyConfigs.length - 1];
            if (propertyConfigs.length > 1) {
                System.arraycopy(propertyConfigs, 0, newPropertyConfigs, 0, i);
                if (i < propertyConfigs.length - 1) {
                    System.arraycopy(propertyConfigs, i + 1, newPropertyConfigs, i, propertyConfigs.length - (i + 1));
                }
            }
            return newPropertyConfigs;
        }
        return propertyConfigs;
    }

    public static boolean usernameAttributeExists(Node node) {
        return XMLUtils.getNodeAttribute(node, "username") != null;
    }

    public static String createXMLString(ConfigObject config, boolean omitXMLDeclaration) throws DataSourceConfigException {
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Node node = config.createXML(document);
            document.appendChild(node);
            StringWriter writer = new StringWriter();
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            String omit = "yes";
            if (!omitXMLDeclaration) {
                omit = "no";
            }
            transformer.setOutputProperty("omit-xml-declaration", omit);
            transformer.transform(new DOMSource(node), new StreamResult(writer));
            return writer.getBuffer().toString();
        }
        catch (Exception exception) {
            String msg = DataSourceMessages.severeConfigCreateXMLException(config.getRootNodeName(), exception);
            throw new DataSourceConfigException(msg, exception);
        }
    }

    public static String createNativeDataSourceConfigString(NativeDataSourceConfig config) {
        StringBuffer sb = new StringBuffer();
        if (config != null) {
            sb.append("name: " + config.getName() + "\n");
            sb.append("jndi-name: " + config.getJndiName() + "\n");
            sb.append("login-timeout: " + config.getLoginTimeout() + "\n");
            sb.append("user: " + config.getUser() + "\n");
            sb.append("password: " + config.getPassword() + "\n");
            sb.append("data-source-class: " + config.getDataSourceClass() + "\n");
            sb.append("url: " + config.getUrl() + "\n");
            sb.append("\nProperties \n");
            sb.append(DataSourceConfigUtils.createPropertyConfigString(config.getProperties()));
        }
        return sb.toString();
    }

    public static String createManagedDataSourceConfigString(ManagedDataSourceConfig config) {
        StringBuffer sb = new StringBuffer();
        if (config != null) {
            sb.append("name: " + config.getName() + "\n");
            sb.append("jndi-name: " + config.getJndiName() + "\n");
            sb.append("login-timeout: " + config.getLoginTimeout() + "\n");
            sb.append("user: " + config.getUser() + "\n");
            sb.append("password: " + config.getPassword() + "\n");
            sb.append("connection-pool-name: " + config.getConnectionPoolName() + "\n");
            sb.append("schema: " + config.getDatabaseSchemaPath() + "\n");
            sb.append("tx-level: " + config.getTxLevel() + "\n");
            sb.append("manage-local-transactions: " + config.getManageLocalTransactions() + "\n");
            sb.append("manage-sql-objects: " + config.getManageSqlObjects() + "\n");
        }
        return sb.toString();
    }

    public static String createConnectionPoolConfigString(ConnectionPoolConfig config) {
        StringBuffer sb = new StringBuffer();
        if (config != null) {
            sb.append("name: " + config.getName() + "\n");
            sb.append("abandoned-connection-timeout: " + config.getAbandonedConnectionTimeout() + "\n");
            sb.append("connection-retry-interval: " + config.getConnectionRetryInterval() + "\n");
            sb.append("inactivity-timeout: " + config.getInactivityTimeout() + "\n");
            sb.append("initial-limit: " + config.getInitialLimit() + "\n");
            sb.append("lower-threshold-limit: " + config.getLowerThresholdLimit() + "\n");
            sb.append("proxy-sessions: " + config.isProxySessions() + "\n");
            sb.append("max-connect-attempts: " + config.getMaxConnectAttempts() + "\n");
            sb.append("max-connections: " + config.getMaxConnections() + "\n");
            sb.append("min-connections: " + config.getMinConnections() + "\n");
            sb.append("num-cached-statements: " + config.getNumCachedStatements() + "\n");
            sb.append("property-check-interval: " + config.getPropertyCheckInterval() + "\n");
            sb.append("time-to-live-timeout: " + config.getTimeToLiveTimeout() + "\n");
            sb.append("used-connection-wait-timeout: " + config.getUsedConnectionWaitTimeout() + "\n");
            sb.append("dedicated-thread-connections: " + config.isDedicatedThreadConnections() + "\n");
            sb.append("validate-connection: " + config.isValidateConnection() + "\n");
            sb.append("validate-connection-statement: " + config.getValidateConnectionStatement() + "\n");
            sb.append("global-instance-name: " + config.getGlobalInstanceName() + "\n");
            sb.append("\nConnection Factory\n");
            sb.append(DataSourceConfigUtils.createConnectionFactoryConfigString(config.getConnectionFactoryConfig()));
        }
        return sb.toString();
    }

    private static String createConnectionFactoryConfigString(ConnectionFactoryConfig config) {
        StringBuffer sb = new StringBuffer();
        if (config != null) {
            sb.append("factory-class: " + config.getFactoryClass() + "\n");
            sb.append("user: " + config.getUser() + "\n");
            sb.append("password: " + config.getPassword() + "\n");
            sb.append("url: " + config.getUrl() + "\n");
            sb.append("commit-record-table-name: " + config.getCommitRecordTableName() + "\n");
            sb.append("login-timeout: " + config.getLoginTimeout() + "\n");
            sb.append("\nProperties\n");
            sb.append(DataSourceConfigUtils.createPropertyConfigString(config.getProperties()));
            sb.append("\nProxy Interfaces\n");
            ProxyInterfaceConfig[] allIcs = config.getProxyInterfaces();
            for (int i = 0; i < allIcs.length; ++i) {
                sb.append("SQL Object: " + allIcs[i].getSqlObject() + " Interface: " + allIcs[i].getInterface() + "\n");
            }
            XARecoveryConfig xaConfig = config.getXARecoveryConfig();
            if (xaConfig != null) {
                sb.append("XA Recovery User: " + xaConfig.getUsername() + "\n");
                sb.append("XA Recovery Password: " + xaConfig.getPassword() + "\n");
            }
            sb.append("\nFatal Error Codes\n");
            FatalErrorCodesConfig fec = config.getFatalErrorCodesConfig();
            ErrorCodeConfig[] allErrorCodes = fec.getErrorCodes();
            for (int i = 0; i < allErrorCodes.length; ++i) {
                sb.append("Error Code: " + allErrorCodes[i].getCode() + "\n");
            }
            sb.append("\nConnection Properties\n");
            sb.append(DataSourceConfigUtils.createPropertyConfigString(config.getConnectionPropertiesConfig().getProperties()));
        }
        return sb.toString();
    }

    private static String createPropertyConfigString(PropertyConfig[] properties) {
        StringBuffer sb = new StringBuffer();
        if (properties != null) {
            for (int i = 0; i < properties.length; ++i) {
                sb.append("name: " + properties[i].getName() + " " + "value" + ": " + properties[i].getValue() + "\n");
            }
        }
        return sb.toString();
    }
}

