/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.sql;

import com.evermind.security.SecuritySensitive;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import oracle.oc4j.sql.DataSourceException;

public abstract class BaseDataSource
implements DataSource {
    private PrintWriter m_logWriter = null;
    private int m_loginTimeout = 0;
    private String m_user = null;
    private String m_password = null;
    private String m_dataSourceName = null;
    private String m_url = null;

    public abstract Connection getConnection() throws SQLException;

    public abstract Connection getConnection(String var1, String var2) throws SQLException;

    public PrintWriter getLogWriter() throws SQLException {
        return this.m_logWriter;
    }

    public void setLogWriter(PrintWriter logWriter) throws SQLException {
        this.m_logWriter = logWriter;
    }

    public void setLoginTimeout(int loginTimeout) throws SQLException {
        this.m_loginTimeout = loginTimeout;
    }

    public int getLoginTimeout() throws SQLException {
        return this.m_loginTimeout;
    }

    public String getUser() {
        return this.m_user;
    }

    public void setUser(String user) throws DataSourceException {
        this.m_user = user;
    }

    public String getPassword() {
        SecuritySensitive securitySensitive = SecuritySensitive.global();
        if (securitySensitive != null) {
            return securitySensitive.decode(this.m_password, null);
        }
        return this.m_password;
    }

    public void setPassword(String password) throws DataSourceException {
        this.m_password = password;
    }

    public String getUrl() {
        return this.m_url;
    }

    public void setUrl(String url) throws DataSourceException {
        this.m_url = url;
    }

    public String getDataSourceName() {
        return this.m_dataSourceName;
    }

    public void setDataSourceName(String dataSourceName) {
        this.m_dataSourceName = dataSourceName;
    }
}

