/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.rmi.interceptors;

import com.evermind.security.User;
import com.evermind.security.UserManager;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import oracle.j2ee.util.TraceLogger;
import oracle.oc4j.common.CommonThreadState;
import oracle.oc4j.rmi.interceptors.PropagatedIdentity;

public class IdentityPropagationHandler {
    static final IdentityPropagationHandler s_singleton = new IdentityPropagationHandler();
    static Logger s_logger = TraceLogger.getLogger(IdentityPropagationHandler.class);

    protected IdentityPropagationHandler() {
    }

    public static IdentityPropagationHandler getInstance() {
        return s_singleton;
    }

    public PropagatedIdentity getCurrentIdentity() {
        try {
            User anonymousUser;
            CommonThreadState cts = CommonThreadState.getCurrent();
            UserManager activeUM = cts.getContextUserManager();
            User activeUser = cts.getUser();
            User user = anonymousUser = null == activeUM ? null : activeUM.getAnonymousUser();
            if (null != anonymousUser && null != activeUser && anonymousUser.equals(activeUser)) {
                return null;
            }
            PropagatedIdentity iat = null == activeUser ? null : new PropagatedIdentity(activeUser);
            return iat;
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }

    public void handleIdentityAssertion(PropagatedIdentity iat) {
        try {
            User user;
            CommonThreadState cts = CommonThreadState.getCurrent();
            UserManager um = cts.getContextUserManager();
            String userName = iat.getUserName();
            User user2 = user = null == um ? null : um.getUser(userName);
            if (null == user) {
                s_logger.log(Level.FINE, "failed to assert identity {0} - user not found in user manager {1}", new Object[]{userName, um});
            } else {
                cts.setPropagatedUser(user);
                cts.setActiveUser(user);
            }
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }
}

