/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.rmi;

import com.evermind.io.ClassLoaderObjectInputStream;
import com.evermind.io.IOUtils;
import com.evermind.net.NetworkConnection;
import com.evermind.server.rmi.Credentials;
import com.evermind.server.rmi.RMIConnection;
import com.evermind.server.rmi.RMILoginFailedException;
import com.evermind.server.rmi.RMIOutputStream;
import com.evermind.server.rmi.RMIProtocol;
import com.evermind.server.rmi.RMIServerConnection;
import com.evermind.server.rmi.RMIServerOutputStream;
import com.evermind.server.rmi.SpecialRMIInputStream;
import com.evermind.util.ByteString;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import oracle.oc4j.rmi.Authenticatable;
import oracle.oc4j.rmi.RmiTransport;
import oracle.oc4j.rmi.ServerSocketRmiTransport;

public abstract class ServerRmiTransport
extends RmiTransport {
    public static final int MAX_BYTE_STRING_SIZE = 10240;

    public static ServerRmiTransport createRmiTransport(NetworkConnection connection) {
        return new ServerSocketRmiTransport(connection);
    }

    protected ServerRmiTransport(NetworkConnection connection) {
        super(connection);
    }

    public void openConnection(NetworkConnection connection, RMIProtocol protocol) throws IOException {
        super.openConnection(connection);
        protocol.writeConnectionHeader(this.getOutputStream());
        this.getOutputStream().flush();
    }

    public int getProtocolType(RMIProtocol protocol) throws IOException, RMILoginFailedException {
        return protocol.readConnectionHeader(this.getInputStream(), new RMIProtocol.ConnectionTypeValidation(){

            public void validateConnectionType(int type) throws RMILoginFailedException {
                if (type != 228) {
                    throw new RMILoginFailedException("Invalid protocol verification, illegal ORMI request or request performed with an incompatible version of this protocol");
                }
            }
        });
    }

    public void acceptClientHandshake(RMIProtocol protocol, Authenticatable authenticatable, RMIConnection connection) throws IOException, RMILoginFailedException {
        this.readAndIgnoreConnectionData();
        Credentials credentials = this.readCredentials(protocol);
        String domainName = this.readDomainName();
        this.recordConnectionCredentials(credentials, domainName);
        authenticatable.authenticateConnection(domainName, credentials);
        this.writeConnectionConfirmation(12, 0, 1);
        this.createObjectOutputStream(connection);
        this.verifyClientSerializationType(this.getObjectOutputStream(), 1);
        this.readConnectionStreamHeader();
    }

    public ClassLoaderObjectInputStream createObjectInputStream(InputStream in, RMIConnection connection) throws IOException {
        return new SpecialRMIInputStream(in, ((RMIServerConnection)connection).getHandler());
    }

    protected RMIOutputStream createOutputStream(OutputStream out, RMIConnection connection) throws IOException {
        return new RMIServerOutputStream(out, ((RMIServerConnection)connection).getHandler());
    }

    public RmiTransport.MessageOut createDiscreteMessageOut(RMIConnection connection) throws IOException {
        return null;
    }

    public abstract void reclaimResources();

    protected void recordConnectionCredentials(Credentials credentials, String domainName) {
    }

    protected void readAndIgnoreConnectionData() throws IOException {
        while (IOUtils.readBoolean(this.getInputStream())) {
            ByteString.read(this.getInputStream(), 10240);
        }
    }

    public String getClusteredApplicationName() throws IOException {
        this.readOldIslandId();
        return this.readDomainName();
    }

    protected Credentials readCredentials(RMIProtocol protocol) throws IOException {
        return protocol.receiveCredentials(this.getInputStream(), this.getOutputStream());
    }

    protected String readDomainName() throws IOException {
        return IOUtils.readUTF(this.getInputStream());
    }

    protected String readOldIslandId() throws IOException {
        return IOUtils.readUTF(this.getInputStream());
    }

    protected void writeConnectionConfirmation(int status, int idleTimeout, int serializationType) throws IOException {
        IOUtils.writeCompressedInt(this.getOutputStream(), status);
        IOUtils.writeCompressedInt(this.getOutputStream(), idleTimeout);
        IOUtils.writeCompressedInt(this.getOutputStream(), serializationType);
    }

    protected void verifyClientSerializationType(OutputStream out, int expectedType) throws IOException {
        out.flush();
        int actualType = IOUtils.readCompressedInt(this.getInputStream());
        if (actualType != expectedType) {
            throw new IOException("Unsupported serialization type: " + actualType);
        }
    }

    public InetAddress getAddress() {
        return this.getAddressContainer().getInetAddress();
    }
}

