/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.peek;

import com.evermind.server.http.HttpDateFormat;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import oracle.classloader.ClassLoaderQuery;
import oracle.classloader.PolicyClassLoader;
import oracle.classloader.SharedCodeSource;
import oracle.classloader.util.ArrayUtils;
import oracle.oc4j.peek.CodeSourceHandler;
import oracle.oc4j.peek.LoaderHandler;
import oracle.oc4j.peek.PageHandler;
import oracle.oc4j.peek.Peek;
import oracle.oc4j.query.util.ClassFormatter;

public class ResourceHandler
extends PageHandler {
    public static final long MILLIS_PER_YEAR = 31536000000L;
    public static final String ONE_YEAR_AGO = HttpDateFormat.format(System.currentTimeMillis() - 31536000000L);
    public static final String ONE_YEAR_FROM_NOW = HttpDateFormat.format(System.currentTimeMillis() + 31536000000L);
    public static final String SELF_LAST_MODIFIED = ResourceHandler.getLastModified();
    public static final String LAST_MODIFIED = "Last-Modified";
    public static final String EXPIRES = "Expires";
    private static final String CLASS_HEADER_BEGIN = "<h3>Class ";
    private static final String CLASS_HEADER_END = "</h3>\n";

    protected static String getLastModified() {
        long lastMod = ClassLoaderQuery.getCodeSourceFileFor((Class)Peek.class).lastModified();
        return HttpDateFormat.format(lastMod);
    }

    public String getURISuffix() {
        return "resource";
    }

    public void handleRequest(String pathArgument, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (pathArgument != null) {
            if (ResourceHandler.handleInline(pathArgument)) {
                ResourceHandler.setHeaders(response);
                this.pageBegin(pathArgument, request, response);
                this.resource(pathArgument, false, request, response);
                ResourceHandler.pageEnd(response);
            } else {
                this.resource(pathArgument, true, request, response);
            }
        }
    }

    public static String getLinkTo(Class clz) {
        String resourcePath = clz.getName().replace('.', '/') + ".class";
        SharedCodeSource source = ClassLoaderQuery.getCodeSourceFor((Class)clz);
        PolicyClassLoader loader = ClassLoaderQuery.getLoaderFor((Class)clz);
        return ResourceHandler.getLinkTo(resourcePath, clz.getName(), loader, source);
    }

    public static String getLinkTo(String resource, PolicyClassLoader loader, SharedCodeSource source) {
        return ResourceHandler.getLinkTo(resource, resource, loader, source);
    }

    public static String getLinkTo(String resource, String displayPath, PolicyClassLoader loader, SharedCodeSource source) {
        boolean inline = ResourceHandler.handleInline(resource);
        StringBuffer buf = new StringBuffer(128);
        if (inline) {
            buf.append("<a href=\"");
        } else {
            buf.append("<a href=\"");
        }
        buf.append(Peek.getContextRoot());
        buf.append("resource/");
        buf.append(resource);
        if (source != null) {
            buf.append("?cs=");
            buf.append(CodeSourceHandler.getDisplayPath(source));
        } else {
            buf.append("?l=");
            buf.append(loader.getDisplayName());
        }
        buf.append("\">");
        buf.append(displayPath);
        buf.append("</a>");
        return buf.toString();
    }

    protected void pageBody(String pathArgument, HttpServletRequest request, HttpServletResponse response) throws Exception {
    }

    private static boolean handleInline(String resource) {
        String suffix = ResourceHandler.getSuffix(resource);
        if (suffix == null) {
            return true;
        }
        return suffix.equalsIgnoreCase(".txt") || suffix.equalsIgnoreCase(".properties") || suffix.equalsIgnoreCase(".mf") || suffix.equalsIgnoreCase(".class");
    }

    private void resource(String resource, boolean separatePage, HttpServletRequest request, HttpServletResponse response) throws Exception {
        InputStream in = null;
        PolicyClassLoader loader = LoaderHandler.getLoader(request);
        if (loader != null) {
            in = loader.getResourceAsStream(resource);
        } else {
            SharedCodeSource source;
            String cs = request.getParameter("cs");
            if (cs != null && (source = CodeSourceHandler.getCodeSource(cs = cs.startsWith("$") ? cs : "/" + cs)) != null) {
                loader = source.getSubscribers().getFirstSubscriber();
                URL res = source.getResource(resource);
                in = res.openStream();
            }
        }
        if (in == null) {
            throw new Error("Resource not found: " + resource);
        }
        String suffix = ResourceHandler.getSuffix(resource);
        if (suffix != null && suffix.equals(".class")) {
            String className = resource.substring(0, resource.length() - ".class".length());
            className = className.replace('/', '.');
            this.writeClass(in, className, separatePage, loader, request, response);
        } else {
            ResourceHandler.writeData(in, resource, suffix, separatePage, response);
        }
    }

    private void writeClass(InputStream data, String className, boolean externalWindow, PolicyClassLoader loader, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ClassFormatter formatter = ClassFormatter.initFormatter(data, new LinkedClass(loader));
        PrintWriter out = response.getWriter();
        if (externalWindow) {
            response.setHeader(LAST_MODIFIED, SELF_LAST_MODIFIED);
            response.setHeader(EXPIRES, ONE_YEAR_FROM_NOW);
            response.setContentType("text/html");
            this.pageHeader(request, response);
        }
        ((Writer)out).write(CLASS_HEADER_BEGIN);
        ((Writer)out).write(className);
        ((Writer)out).write(CLASS_HEADER_END);
        ((Writer)out).write("<div class=\"code\">");
        formatter.write(out);
        ((Writer)out).write("</div>");
        if (externalWindow) {
            ((Writer)out).write("</body>\n</html>\n");
        }
    }

    private static void writeData(InputStream data, String resource, String suffix, boolean externalWindow, HttpServletResponse response) throws Exception {
        byte[] bytes = ArrayUtils.read((InputStream)data);
        if (externalWindow) {
            response.setHeader(LAST_MODIFIED, SELF_LAST_MODIFIED);
            response.setHeader(EXPIRES, ONE_YEAR_FROM_NOW);
            response.setContentLength(bytes.length);
            response.setContentType(ResourceHandler.getContentType(suffix));
            ServletOutputStream out = response.getOutputStream();
            out.write(bytes);
            out.flush();
            out.close();
        } else {
            PrintWriter out = response.getWriter();
            ResourceHandler.writeHeading3(resource, out);
            ((Writer)out).write("<pre>\n");
            if (bytes.length == 0) {
                ((Writer)out).write("&lt;empty&gt;");
            } else {
                ((Writer)out).write(new String(bytes));
            }
            ((Writer)out).write("</pre>\n");
        }
    }

    private static class LinkedClass
    extends ClassFormatter.HTMLClassFormatter {
        private PolicyClassLoader loader;

        LinkedClass(PolicyClassLoader l) {
            this.loader = l;
        }

        protected void writeClass(String unqualifiedName, String fullyQualifiedName, Writer out) throws Exception {
            if (fullyQualifiedName != null) {
                String displayName = unqualifiedName;
                if (displayName == null) {
                    displayName = fullyQualifiedName;
                }
                String resourceName = fullyQualifiedName.replace('.', '/') + ".class";
                String link = ResourceHandler.getLinkTo(resourceName, displayName, this.loader, null);
                out.write(link);
            } else {
                out.write(unqualifiedName);
            }
        }
    }
}

