/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.peek;

import com.evermind.server.ApplicationServer;
import java.io.PrintWriter;
import java.io.Writer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import oracle.oc4j.peek.Peek;
import oracle.oc4j.peek.PeekHandler;
import oracle.oc4j.peek.SkinHandler;

public abstract class PageHandler
extends PeekHandler {
    private static final String VERSION_NUMBER = "0.9";
    private static final String HEADER_BEGIN_0 = "<?xml version=\"1.0\" encoding=\"iso-8859-1\"?>\n";
    private static final String HEADER_BEGIN_1 = "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\n<html>\n<head>\n";
    private static final String PAGE_BEGIN_0 = "<title>Peek: OC4J Runtime Inspector</title>\n";
    private static final String[] SCRIPT_FILES = new String[]{"peek.js", "jquery.js", "tablesorter.js"};
    private static final String SCRIPT_BEGIN = "<script type=\"text/javascript\" src=\"";
    private static final String SCRIPT_END = "\"></script>\n";
    private static final String PAGE_BEGIN_1 = "<link rel=\"stylesheet\" href=\"";
    private static final String PAGE_BEGIN_2 = "\"/>\n";
    private static final String MSIE_STYLE_0 = "<link rel=\"stylesheet\" href=\"";
    private static final String MSIE_STYLE_1 = "ie.css\"/>\n";
    private static final String HEADER_END = "</head>\n<body>\n";
    private static final String MAIN_BODY_BEGIN = "<div class=\"header\">\n<div class=\"header-image\" onclick=\"window.location='/peek/'\"></div>\n</div>\n<div class=\"menu-bar\">\n<form method=\"get\" action=\"";
    private static final String MAIN_BODY_0 = "query\">\n<input type=\"text\" id=\"text\" name=\"q\" value=\"";
    private static final String MAIN_BODY_1 = "\" maxlength=\"1024\"/>\n<input type=\"submit\" id=\"submit\" value=\"go\" />\n</form>\n";
    private static final String MENU_BEGIN = "<span class=\"menu-box\">\n<span class=\"menu\">\n<ul>\n<li><a href=\"";
    private static final String MENU_1 = "\">View<!--[if IE 7]><!--></a><!--<![endif]-->\n<!--[if lte IE 6]><table><tr><td><![endif]-->\n    <ul>\n";
    private static final String MENU_ITEM_LINK = "<li><a href=\"";
    private static final String MENU_ITEM_TITLE = "\" title=\"";
    private static final String MENU_ITEM_NAME = "\">";
    private static final String MENU_ITEM_END = "</a></li>\n";
    private static final String MENU_END = "    </ul>\n<!--[if lte IE 6]></td></tr></table></a><![endif]-->\n</li>\n</ul>\n</span>\n</span>\n</div>\n<div class=\"result\">\n";
    private static final String MAIN_BODY_END = "<br />\n</div>\n";
    protected static final String PAGE_END = "</body>\n</html>\n";
    private static final String CACHE_CONTROL = "Cache-Control";
    private static final String CONTENT_TYPE = "text/html";
    private static final String USER_AGENT = "USER-AGENT";
    private static final String MSIE_USER_AGENT_5 = "MSIE 5";
    private static final String MSIE_USER_AGENT_6 = "MSIE 6";
    protected static final String LAST_QUERY_ATTRIBUTE = "last-query";
    protected static final String[] C1_CLASSES = new String[]{"lightbg1", "lightbg2"};

    public void handleRequest(String pathArgument, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PageHandler.setHeaders(response);
        this.pageBegin(pathArgument, request, response);
        this.pageBody(pathArgument, request, response);
        PageHandler.pageEnd(response);
    }

    protected static void setHeaders(HttpServletResponse response) throws Exception {
        response.setHeader(CACHE_CONTROL, "private");
        response.setContentType(CONTENT_TYPE);
    }

    protected void pageHeader(HttpServletRequest request, HttpServletResponse response) throws Exception {
        PrintWriter out = response.getWriter();
        ((Writer)out).write(HEADER_BEGIN_0);
        ((Writer)out).write(HEADER_BEGIN_1);
        ((Writer)out).write(PAGE_BEGIN_0);
        String filesRoot = Peek.getFilesRoot();
        for (int i = 0; i < SCRIPT_FILES.length; ++i) {
            String js = SCRIPT_FILES[i];
            ((Writer)out).write(SCRIPT_BEGIN);
            ((Writer)out).write(filesRoot);
            ((Writer)out).write(js);
            ((Writer)out).write(SCRIPT_END);
        }
        ((Writer)out).write("<link rel=\"stylesheet\" href=\"");
        ((Writer)out).write(SkinHandler.getRelativeURI(request));
        ((Writer)out).write(PAGE_BEGIN_2);
        String userAgent = request.getHeader(USER_AGENT);
        if (userAgent.indexOf(MSIE_USER_AGENT_6) > 0 || userAgent.indexOf(MSIE_USER_AGENT_5) > 0) {
            ((Writer)out).write("<link rel=\"stylesheet\" href=\"");
            ((Writer)out).write(Peek.getFilesRoot());
            ((Writer)out).write(MSIE_STYLE_1);
        }
        this.extraHeaders(request, response);
        ((Writer)out).write(HEADER_END);
    }

    protected void extraHeaders(HttpServletRequest request, HttpServletResponse response) throws Exception {
    }

    protected void pageBegin(String pathArgument, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.pageHeader(request, response);
        PrintWriter out = response.getWriter();
        ((Writer)out).write(MAIN_BODY_BEGIN);
        ((Writer)out).write(Peek.getContextRoot());
        ((Writer)out).write(MAIN_BODY_0);
        String value = this.getQueryFieldValue(pathArgument, request);
        value = PageHandler.filterQueryString(value);
        if (value != null) {
            ((Writer)out).write(value);
        }
        ((Writer)out).write(MAIN_BODY_1);
        ((Writer)out).write(MENU_BEGIN);
        ((Writer)out).write(Peek.getContextRoot());
        ((Writer)out).write(MENU_1);
        this.writeMenuItem("Loaders", "Class loader tree", "loader-tree", out);
        this.writeMenuItem("Loggers", "Loggers", "loggers", out);
        this.writeMenuItem("Help", "Help", "", out);
        ((Writer)out).write(MENU_END);
    }

    private void writeMenuItem(String itemName, String title, String uriSuffix, Writer out) throws Exception {
        out.write(MENU_ITEM_LINK);
        out.write(Peek.getContextRoot());
        out.write(uriSuffix);
        out.write(MENU_ITEM_TITLE);
        out.write(title);
        out.write(MENU_ITEM_NAME);
        out.write(itemName);
        out.write(MENU_ITEM_END);
    }

    protected String getQueryFieldValue(String pathArgument, HttpServletRequest request) {
        HttpSession session = request.getSession();
        String lastQuery = (String)session.getAttribute(LAST_QUERY_ATTRIBUTE);
        return lastQuery;
    }

    protected abstract void pageBody(String var1, HttpServletRequest var2, HttpServletResponse var3) throws Exception;

    protected static void pageEnd(HttpServletResponse response) throws Exception {
        PrintWriter out = response.getWriter();
        ((Writer)out).write(MAIN_BODY_END);
        ((Writer)out).write("<div class=\"footer\">\n<hr />\n");
        ((Writer)out).write("<i><b>Peek v");
        ((Writer)out).write(VERSION_NUMBER);
        ((Writer)out).write("</b></i>. OC4J build ");
        String buildNum = ApplicationServer.getBuildNumber();
        ((Writer)out).write(buildNum != null ? buildNum : "unknown");
        ((Writer)out).write(" in ");
        ((Writer)out).write(System.getProperty("oracle.home"));
        ((Writer)out).write(".</div>");
        ((Writer)out).write(PAGE_END);
    }

    protected static void writeHeading3(String heading, Writer out) throws Exception {
        out.write("<h3>");
        out.write(heading);
        out.write("</h3>\n");
    }

    protected static void writePreformatted(String text, Writer out) throws Exception {
        out.write("<pre>");
        out.write(text);
        out.write("</pre>\n");
    }

    protected static void beginTable(Writer out) throws Exception {
        out.write("<table>\n");
    }

    protected static void writeTableRow(Object c0, Object c1, Writer out) throws Exception {
        PageHandler.beginTableRow(c0, null, out);
        PageHandler.endTableRow(c1, out);
    }

    protected static int writeTableRow(Object c0, Object c1, String[] c1Classes, int currentC1Class, Writer out) throws Exception {
        currentC1Class = PageHandler.beginTableRow(c0, c1Classes, currentC1Class, out);
        PageHandler.endTableRow(c1, out);
        return currentC1Class;
    }

    protected static int beginTableRow(Object c0, String[] c1Classes, int currentC1Class, Writer out) throws Exception {
        PageHandler.beginTableRow(c0, c1Classes[currentC1Class++], out);
        if (currentC1Class >= c1Classes.length) {
            currentC1Class = 0;
        }
        return currentC1Class;
    }

    protected static void beginTableRow(Object c0, String c1Class, Writer out) throws Exception {
        out.write("<tr><td class=\"label\" valign=\"top\">");
        out.write(c0.toString());
        out.write("</td><td");
        if (c1Class != null) {
            out.write(" class=\"");
            out.write(c1Class);
            out.write(34);
        }
        out.write(62);
    }

    protected static void endTableRow(Object c1, Writer out) throws Exception {
        out.write(c1.toString());
        out.write("</td></tr>\n");
    }

    protected static void endTableRow(Writer out) throws Exception {
        out.write("</td></tr>\n");
    }

    protected static void endTable(Writer out) throws Exception {
        out.write("</table>\n");
    }

    protected static void writeImage(String imageName, Writer out) throws Exception {
        out.write("<img src=\"");
        out.write(Peek.getFilesRoot());
        out.write(imageName);
        out.write("\"/>");
    }
}

