/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.peek;

import java.io.PrintWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import oracle.classloader.ClassLoaderQuery;
import oracle.classloader.ConfigurationOrigin;
import oracle.classloader.PolicyClassLoader;
import oracle.classloader.SharedCodeSource;
import oracle.classloader.SubscriberSet;
import oracle.classloader.util.ClassLoadEnvironment;
import oracle.classloader.util.FileUtils;
import oracle.oc4j.peek.HelpHandler;
import oracle.oc4j.peek.LoaderHandler;
import oracle.oc4j.peek.Peek;
import oracle.oc4j.peek.ResourceHandler;

public class CodeSourceHandler
extends HelpHandler {
    private static final String BEGIN = "<div class=\"tree\">\n";
    private static final String END = "</div>\n";

    public static String getDisplayPath(SharedCodeSource cs) {
        return ClassLoadEnvironment.getDisplayPath((String)cs.getLocation().getPath());
    }

    public static SharedCodeSource getCodeSource(String codeSourcePath) {
        try {
            codeSourcePath = FileUtils.doPropertyReplacement((String)codeSourcePath);
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        SharedCodeSource source = ClassLoaderQuery.findCodeSource((String)codeSourcePath);
        return source;
    }

    public String getURISuffix() {
        return "code-source";
    }

    protected String getQueryFieldValue(String pathArgument, HttpServletRequest request) {
        return null;
    }

    public static String getLinkTo(SharedCodeSource source) {
        PolicyClassLoader loader = source.getSubscribers().getFirstSubscriber();
        return CodeSourceHandler.getLinkTo(source, loader);
    }

    public static String getLinkTo(SharedCodeSource source, PolicyClassLoader loader) {
        String displayPath = CodeSourceHandler.getDisplayPath(source);
        return CodeSourceHandler.getLinkTo(displayPath, displayPath, loader);
    }

    private static String getLinkTo(String codeSourcePath, String displayPath, PolicyClassLoader loader) {
        StringBuffer buf = new StringBuffer(128);
        buf.append("<a href=\"");
        buf.append(Peek.getContextRoot());
        buf.append("code-source/");
        buf.append(codeSourcePath);
        if (loader != null) {
            buf.append('?');
            buf.append("l");
            buf.append('=');
            buf.append(loader.getDisplayName());
        }
        buf.append("\">");
        buf.append(displayPath);
        buf.append("</a>");
        return buf.toString();
    }

    protected void pageBody(String codeSource, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PrintWriter out = response.getWriter();
        codeSource = codeSource.startsWith("$") ? codeSource : "/" + codeSource;
        SharedCodeSource source = CodeSourceHandler.getCodeSource(codeSource);
        PolicyClassLoader loader = LoaderHandler.getLoader(request);
        if (source == null) {
            throw new Error("Unknown code-source: " + codeSource);
        }
        ((Writer)out).write(BEGIN);
        CodeSourceHandler.writeHeading3("Code Source " + codeSource, out);
        CodeSourceHandler.beginTable(out);
        int c1Index = 0;
        SubscriberSet subscribers = source.getSubscribers();
        PolicyClassLoader[] loaders = subscribers.getSubscribers();
        if (loaders != null) {
            if (loaders.length == 1) {
                c1Index = CodeSourceHandler.writeTableRow("Referenced by", LoaderHandler.getLinkTo(loaders[0]), C1_CLASSES, c1Index, out);
                ConfigurationOrigin origin = subscribers.getFirstOriginFor(loaders[0]);
                c1Index = CodeSourceHandler.writeTableRow("Origin", CodeSourceHandler.cleanText(origin.toString()), C1_CLASSES, c1Index, out);
            } else {
                StringBuffer loadersBuf = new StringBuffer();
                StringBuffer originsBuf = new StringBuffer();
                for (int i = 0; i < loaders.length; ++i) {
                    if (loaders[i] == null) continue;
                    String origin = subscribers.getFirstOriginFor(loaders[i]).toString();
                    if (i > 0) {
                        loadersBuf.append("<br />\n");
                        originsBuf.append("<br />\n");
                    }
                    loadersBuf.append(LoaderHandler.getLinkTo(loaders[i]));
                    originsBuf.append(CodeSourceHandler.cleanText(origin));
                }
                c1Index = CodeSourceHandler.writeTableRow("Referenced by", loadersBuf.toString(), C1_CLASSES, c1Index, out);
                c1Index = CodeSourceHandler.writeTableRow("Origin", originsBuf.toString(), C1_CLASSES, c1Index, out);
            }
        }
        CodeSourceHandler.beginTableRow("Contents", C1_CLASSES, c1Index, out);
        Object[] paths = source.listFilePaths();
        Arrays.sort(paths);
        for (int i = 0; i < paths.length; ++i) {
            Object path = paths[i];
            ((Writer)out).write(ResourceHandler.getLinkTo((String)path, loader, source));
            ((Writer)out).write("<br />\n");
        }
        CodeSourceHandler.endTableRow(out);
        CodeSourceHandler.endTable(out);
        ((Writer)out).write(END);
    }
}

