/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.corba.transport;

import com.evermind.server.ejb.EntityEJBHome;
import com.evermind.server.ejb.StatefulSessionEJBHome;
import com.evermind.server.ejb.StatelessSessionEJBHome;
import com.evermind.server.ejb.logging.EJBIiopMessages;
import java.util.HashMap;
import java.util.Map;
import javax.ejb.EJBHome;
import javax.ejb.EJBObject;
import oracle.oc4j.corba.ORBInitializationException;
import oracle.oc4j.corba.POAPolicyCreationStrategy;
import oracle.oc4j.corba.transport.CorbaEJBHome;
import oracle.oc4j.corba.transport.CorbaEJBObject;
import oracle.oc4j.corba.transport.CorbaReferenceGenerator;
import oracle.oc4j.corba.transport.EJBObjectReferenceGenerator;
import oracle.oc4j.corba.transport.HomeReferenceGenerator;
import org.omg.PortableServer.POA;

class CorbaReferenceGeneratorImpl
implements CorbaReferenceGenerator {
    private static Map s_appLocators = new HashMap();
    private HashMap m_homeRefGenerators = new HashMap();
    private HashMap m_ejbRefGenerators = new HashMap();
    protected POA m_rootPoa = null;
    private POAPolicyCreationStrategy m_policyStrategy = null;

    CorbaReferenceGeneratorImpl(POA rootPoa, POAPolicyCreationStrategy policyStrategy) {
        this.m_rootPoa = rootPoa;
        this.m_policyStrategy = policyStrategy;
    }

    public EJBHome getHomeReference(CorbaEJBHome homeImplementation) throws ORBInitializationException {
        return this.getHomeReferenceGenerator(homeImplementation).getHomeReference(homeImplementation);
    }

    public boolean isIdentical(EJBHome clientReference, CorbaEJBHome ejbHome) throws ORBInitializationException {
        return this.getHomeReferenceGenerator(ejbHome).isIdentical(clientReference, ejbHome);
    }

    public boolean isIdentical(EJBObject clientReference, CorbaEJBObject ejbObject) {
        try {
            return this.getEjbReferenceGenerator(ejbObject.getCorbaHome()).isIdentical(clientReference, ejbObject);
        }
        catch (ORBInitializationException e) {
            EJBIiopMessages.warningUnableToPerformIdentityCheck(e);
            return false;
        }
    }

    synchronized void deployHome(CorbaEJBHome home) throws ORBInitializationException {
        CorbaReferenceGeneratorImpl.put(home.getApplicationName(), home.getLocation(), home);
        this.getHomeReferenceGenerator(home).deploy(home);
    }

    synchronized EJBObject deployEjb(CorbaEJBHome home, EJBObject ejb) throws ORBInitializationException {
        if (home instanceof StatefulSessionEJBHome) {
            return this.getEjbReferenceGenerator(home).getReference((StatefulSessionEJBHome)home, ejb);
        }
        if (home instanceof StatelessSessionEJBHome) {
            return this.getEjbReferenceGenerator(home).getReference((StatelessSessionEJBHome)home, ejb);
        }
        if (home instanceof EntityEJBHome) {
            return this.getEjbReferenceGenerator(home).getReference((EntityEJBHome)home, ejb);
        }
        if (home instanceof CorbaEJBHome) {
            return this.getEjbReferenceGenerator(home).getReference(home, ejb);
        }
        return null;
    }

    private HomeReferenceGenerator getHomeReferenceGenerator(CorbaEJBHome home) throws ORBInitializationException {
        String appName = home.getApplicationName();
        HomeReferenceGenerator result = (HomeReferenceGenerator)this.m_homeRefGenerators.get(appName);
        if (result == null) {
            result = new HomeReferenceGenerator(this.m_rootPoa, this.m_policyStrategy, home);
            this.m_homeRefGenerators.put(appName, result);
        }
        return result;
    }

    private EJBObjectReferenceGenerator getEjbReferenceGenerator(CorbaEJBHome home) throws ORBInitializationException {
        EJBObjectReferenceGenerator result = (EJBObjectReferenceGenerator)this.m_ejbRefGenerators.get(home.getApplicationName());
        if (result == null) {
            result = new EJBObjectReferenceGenerator(this.m_rootPoa, this.m_policyStrategy, home);
            this.m_ejbRefGenerators.put(home.getApplicationName(), result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void put(String applicationName, String location, CorbaEJBHome home) {
        Map map = s_appLocators;
        synchronized (map) {
            CorbaReferenceGeneratorImpl.getApplicationLocator(applicationName).put(location, home);
        }
    }

    static Map getApplicationLocator(String applicationName) {
        HashMap appMap = (HashMap)s_appLocators.get(applicationName);
        if (appMap == null) {
            appMap = new HashMap();
            s_appLocators.put(applicationName, appMap);
        }
        return appMap;
    }

    public void undeployApplication(String appName) {
        EJBObjectReferenceGenerator eorg;
        HomeReferenceGenerator hrg = (HomeReferenceGenerator)this.m_homeRefGenerators.remove(appName);
        if (hrg != null) {
            hrg.undeploy();
        }
        if ((eorg = (EJBObjectReferenceGenerator)this.m_ejbRefGenerators.remove(appName)) != null) {
            eorg.undeploy();
        }
        s_appLocators.remove(appName);
    }
}

