/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.corba.iiop.security;

import com.sun.corba.ee.org.omg.CSI.AuthorizationElement;
import com.sun.corba.ee.org.omg.CSI.EstablishContext;
import com.sun.corba.ee.org.omg.CSI.GSS_NT_ExportedNameHelper;
import com.sun.corba.ee.org.omg.CSI.IdentityToken;
import com.sun.corba.ee.org.omg.CSI.SASContextBody;
import com.sun.corba.ee.org.omg.CSI.SASContextBodyHelper;
import com.sun.corba.ee.org.omg.CSI.X501DistinguishedNameHelper;
import com.sun.corba.ee.org.omg.CSI.X509CertificateChainHelper;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.Set;
import oracle.j2ee.corba.security.CSIV2Messages;
import oracle.oc4j.corba.iiop.security.AnonCredential;
import oracle.oc4j.corba.iiop.security.ClientCsiv2Manager;
import oracle.oc4j.corba.iiop.security.ClientSecurityService;
import oracle.oc4j.corba.iiop.security.GSSUPName;
import oracle.oc4j.corba.iiop.security.GSSUPToken;
import oracle.oc4j.corba.iiop.security.InvalidIdentityTokenException;
import oracle.oc4j.corba.iiop.security.InvalidMechanismException;
import oracle.oc4j.corba.iiop.security.SecurityContext;
import oracle.oc4j.corba.iiop.security.SvcContextUtils;
import oracle.oc4j.corba.orb.OrbManager;
import oracle.oc4j.corba.security.auth.login.PasswordCredential;
import oracle.oc4j.corba.security.auth.login.X509CertificateCredential;
import oracle.oc4j.corba.util.LocalStringManagerImpl;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.IOP.Codec;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.ClientRequestInfo;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.ForwardRequest;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.X500Name;

public class SecClientRequestInterceptor
extends LocalObject
implements ClientRequestInterceptor {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(SecClientRequestInterceptor.class);
    protected String name;
    protected String prname;
    protected Codec codec;
    private ORB orb;
    protected static final int SECURITY_ATTRIBUTE_SERVICE_ID = 15;

    public SecClientRequestInterceptor(String name, Codec codec) {
        this.name = name;
        this.codec = codec;
        this.prname = name + "::";
    }

    public String name() {
        return this.name;
    }

    private java.lang.Object getCred(Set credset, Class c) {
        java.lang.Object cred = null;
        String clsname = c.getName();
        CSIV2Messages.fineMsg("Checking for a single instance of class in subject");
        CSIV2Messages.fineMsg("    Classname = " + clsname);
        if (credset.size() != 1) {
            CSIV2Messages.severeMsg("Found " + credset.size() + " instances of class ( " + clsname);
            throw new SecurityException(localStrings.getLocalString("secclientreqinterceptor.inv_credlist_size", "Credential list size is not 1."));
        }
        Iterator iter = credset.iterator();
        while (iter.hasNext()) {
            cred = iter.next();
        }
        CSIV2Messages.fineMsg("Verified single instance of class ( " + clsname + " )");
        return cred;
    }

    private byte[] createAuthToken(java.lang.Object cred, Class cls) throws Exception {
        byte[] gsstoken = new byte[]{};
        if (PasswordCredential.class.isAssignableFrom(cls)) {
            CSIV2Messages.fineMsg("Constructing a PasswordCredential client auth token");
            PasswordCredential pwdcred = (PasswordCredential)cred;
            GSSUPToken tok = new GSSUPToken(this.orb, this.codec, pwdcred);
            gsstoken = tok.getGSSToken();
        }
        return gsstoken;
    }

    private IdentityToken createIdToken(java.lang.Object cred, Class cls) throws Exception {
        IdentityToken idtok = null;
        DerOutputStream dos = new DerOutputStream();
        DerValue[] derval = new DerValue[]{};
        Any any = this.orb.create_any();
        idtok = new IdentityToken();
        if (X500Name.class.isAssignableFrom(cls)) {
            CSIV2Messages.fineMsg("Constructing an X500 DN Identity Token");
            X500Name name = (X500Name)cred;
            name.encode(dos);
            X501DistinguishedNameHelper.insert((Any)any, (byte[])dos.toByteArray());
            idtok.dn(this.codec.encode_value(any));
        } else if (X509CertificateCredential.class.isAssignableFrom(cls)) {
            CSIV2Messages.fineMsg("Constructing an X509 Certificate Chain Identity Token");
            X509CertificateCredential certcred = (X509CertificateCredential)cred;
            X509Certificate[] certchain = certcred.getX509CertificateChain();
            CSIV2Messages.fineMsg("Certchain length = " + certchain.length);
            derval = new DerValue[certchain.length];
            for (int i = 0; i < certchain.length; ++i) {
                derval[i] = new DerValue(certchain[i].getEncoded());
            }
            dos.putSequence(derval);
            X509CertificateChainHelper.insert((Any)any, (byte[])dos.toByteArray());
            idtok.certificate_chain(this.codec.encode_value(any));
        } else if (AnonCredential.class.isAssignableFrom(cls)) {
            CSIV2Messages.fineMsg("Constructing an Anonymous Identity Token");
            idtok.anonymous(true);
        } else if (GSSUPName.class.isAssignableFrom(cls)) {
            CSIV2Messages.fineMsg("Constructing a GSS Exported name Identity Token");
            GSSUPName gssname = (GSSUPName)cred;
            byte[] expname = gssname.getExportedName();
            GSS_NT_ExportedNameHelper.insert((Any)any, (byte[])expname);
            idtok.principal_name(this.codec.encode_value(any));
        }
        return idtok;
    }

    public void send_request(ClientRequestInfo ri) throws ForwardRequest {
        long cContextId = 0L;
        AuthorizationElement[] cAuthzElem = new AuthorizationElement[]{};
        IdentityToken cIdentityToken = null;
        byte[] cAuthenticationToken = new byte[]{};
        byte[] cdr_encoded_saselm = new byte[]{};
        java.lang.Object cred = null;
        CSIV2Messages.finestMsg(this.prname + "send_request");
        SecurityContext secctxt = null;
        this.getSecurityService();
        this.orb = OrbManager.getClientOrb();
        ClientSecurityService secsvc = this.getSecurityService();
        if (secsvc == null) {
            CSIV2Messages.warningMsg("No Security Service registered. Exiting interception point");
            return;
        }
        Object effective_target = ri.effective_target();
        try {
            secctxt = secsvc.getSecurityContext(effective_target);
        }
        catch (InvalidMechanismException ime) {
            CSIV2Messages.finerThrowableMsg("Invalid Security Mechanism!", ime);
            throw new RuntimeException(ime.getMessage());
        }
        catch (InvalidIdentityTokenException iite) {
            CSIV2Messages.finerThrowableMsg("Invalid Identity Token!", iite);
            throw new RuntimeException(iite.getMessage());
        }
        if (secctxt == null) {
            CSIV2Messages.fineMsg("Security context is null (nothing to add to service context)");
            return;
        }
        final SecurityContext sCtx = secctxt;
        if (secctxt.authcls != null) {
            cred = AccessController.doPrivileged(new PrivilegedAction(){

                public java.lang.Object run() {
                    return SecClientRequestInterceptor.this.getCred(sCtx.subject.getPrivateCredentials(sCtx.authcls), sCtx.authcls);
                }
            });
            try {
                cAuthenticationToken = this.createAuthToken(cred, secctxt.authcls);
            }
            catch (Exception e) {
                CSIV2Messages.finerThrowableNoMsg(e);
                CSIV2Messages.severeMsg("Exception while constructing an authentication token");
                throw new SecurityException(localStrings.getLocalString("secclientreqinterceptor.err_authtok_create", "Error while constructing an authentication token."));
            }
        }
        if (secctxt.identcls != null) {
            cred = this.getCred(secctxt.subject.getPublicCredentials(secctxt.identcls), secctxt.identcls);
            try {
                cIdentityToken = this.createIdToken(cred, secctxt.identcls);
            }
            catch (Exception e) {
                CSIV2Messages.finerThrowableNoMsg(e);
                CSIV2Messages.severeMsg("Exception while constructing an identity token");
                throw new SecurityException(localStrings.getLocalString("secclientreqinterceptor.err_idtok_create", "Error while constructing an identity token."));
            }
        } else {
            CSIV2Messages.fineMsg("Constructing an Absent Identity Token");
            cIdentityToken = new IdentityToken();
            cIdentityToken.absent(true);
        }
        CSIV2Messages.fineMsg("Creating an EstablishContext message");
        EstablishContext ec = new EstablishContext(cContextId, cAuthzElem, cIdentityToken, cAuthenticationToken);
        SASContextBody sasctxbody = new SASContextBody();
        sasctxbody.establish_msg(ec);
        Any SasAny = this.orb.create_any();
        SASContextBodyHelper.insert((Any)SasAny, (SASContextBody)sasctxbody);
        try {
            cdr_encoded_saselm = this.codec.encode_value(SasAny);
        }
        catch (Exception e) {
            CSIV2Messages.finerThrowableNoMsg(e);
            CSIV2Messages.severeMsg("CDR Encoding error for a SAS context element.");
            throw new SecurityException(localStrings.getLocalString("secclientreqinterceptor.err_cdr_encode", "CDR Encoding error for a SAS context element."));
        }
        ServiceContext sc = new ServiceContext();
        sc.context_id = 15;
        sc.context_data = cdr_encoded_saselm;
        CSIV2Messages.fineMsg("Adding EstablishContext message to service context list");
        boolean no_replace = false;
        ri.add_request_service_context(sc, no_replace);
        CSIV2Messages.fineMsg("Added EstablishContext message to service context list");
    }

    protected ClientSecurityService getSecurityService() {
        return ClientCsiv2Manager.getClientSecurityService();
    }

    public void send_poll(ClientRequestInfo ri) {
    }

    private void setreplyStatus(int status, Object target) {
        CSIV2Messages.fineMsg("Status to be set : " + status);
        ClientSecurityService secsvc = this.getSecurityService();
        if (secsvc == null) {
            CSIV2Messages.warningMsg("No Security Service registered. Status not set");
            return;
        }
        secsvc.receivedReply(status, target);
        CSIV2Messages.fineMsg("Invoked receivedReply()");
    }

    private int mapreplyStatus(int repst) {
        int status;
        CSIV2Messages.fineMsg("Reply status to be mapped =  " + repst);
        switch (repst) {
            case 0: 
            case 2: {
                status = 0;
                break;
            }
            case 3: 
            case 4: {
                status = 2;
                break;
            }
            case 1: {
                status = 1;
                break;
            }
            default: {
                status = repst;
            }
        }
        CSIV2Messages.fineMsg("Mapped reply status = " + status);
        return status;
    }

    public void receive_reply(ClientRequestInfo ri) {
        ServiceContext sc = null;
        CSIV2Messages.finestMsg(this.prname + "receive_reply");
        this.orb = OrbManager.getClientOrb();
        try {
            sc = ri.get_reply_service_context(15);
        }
        catch (BAD_PARAM e) {
            CSIV2Messages.fineMsg("No SAS context element found in service context list");
            this.setreplyStatus(0, ri.effective_target());
            return;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
        Any a = this.orb.create_any();
        try {
            a = this.codec.decode_value(sc.context_data, SASContextBodyHelper.type());
        }
        catch (Exception e) {
            CSIV2Messages.finerThrowableNoMsg(e);
            CSIV2Messages.severeMsg("CDR Decoding error for SAS context element.");
            throw new SecurityException(localStrings.getLocalString("secclientreqinterceptor.err_cdr_decode", "CDR Decoding error for SAS context element."));
        }
        SASContextBody sasctxbody = SASContextBodyHelper.extract((Any)a);
        short sasdiscr = sasctxbody.discriminator();
        CSIV2Messages.fineMsg("Received " + SvcContextUtils.getMsgname(sasdiscr) + " message");
        CSIV2Messages.fineMsg("Verifying the SAS protocol reply message");
        if (sasdiscr != 1 && sasdiscr != 4) {
            CSIV2Messages.severeMsg("Reply message not one of  CompleteEstablishContext or ContextError.");
            throw new SecurityException(localStrings.getLocalString("secclientreqinterceptor.err_not_cecec_msg", "Reply message not one of CompleteEstablishContext or ContextError."));
        }
        int st = this.mapreplyStatus(ri.reply_status());
        this.setreplyStatus(st, ri.effective_target());
    }

    public void receive_exception(ClientRequestInfo ri) throws ForwardRequest {
        CSIV2Messages.finestMsg(this.prname + "receive_exception");
    }

    public void receive_other(ClientRequestInfo ri) throws ForwardRequest {
    }

    public void destroy() {
    }
}

