/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.management.mbeans;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import javax.management.openmbean.CompositeData;
import oracle.j2ee.admin.jmx.exception.config.ConfigMBeanException;
import oracle.j2ee.util.TraceLogger;
import oracle.oc4j.admin.jmx.server.mbeans.model.ModelMBeanFactory;
import oracle.oc4j.admin.jmx.shared.exceptions.JMXRuntimeException;
import oracle.oc4j.admin.management.callbackinterfaces.OpmnCompCallBackIf;
import oracle.oc4j.admin.management.callbackinterfaces.OpmnProcCallBackIf;
import oracle.oc4j.admin.management.mbeans.J2EEServerDependentObjectBase;
import oracle.oc4j.admin.management.mbeans.OpmnCompMBean;
import oracle.oc4j.admin.management.mbeans.OpmnConfig;
import oracle.oc4j.admin.management.mbeans.OpmnProc;

public class OpmnComp
extends J2EEServerDependentObjectBase
implements OpmnCompMBean {
    private static Logger logger_ = TraceLogger.getLogger(OpmnComp.class);
    OpmnCompCallBackIf callBackIf_ = null;
    MBeanServer mbeanServer_ = null;
    protected ArrayList procMBeans_ = new ArrayList();
    OpmnConfig parent_ = null;

    protected MBeanServer getMyMBeanServer() {
        return this.mbeanServer_;
    }

    protected void setMyMBeanServer(MBeanServer server) {
        this.mbeanServer_ = server;
    }

    protected OpmnConfig getParent() {
        return this.parent_;
    }

    protected void setParent(OpmnConfig opmnConfig) {
        this.parent_ = opmnConfig;
    }

    public OpmnComp(OpmnCompCallBackIf callBackIf, String domain, String j2eeServerName) {
        super(domain, j2eeServerName);
        this.callBackIf_ = callBackIf;
        this.setBaseObjectName(":type=" + this.callBackIf_.getType() + ",OpmnConfig=" + this.callBackIf_.getParentName() + ",name=" + this.callBackIf_.getname());
        this.init();
    }

    public OpmnComp(OpmnCompCallBackIf callBackIf) {
        this.callBackIf_ = callBackIf;
        this.setBaseObjectName(":type=" + this.callBackIf_.getType() + ",OpmnConfig=" + this.callBackIf_.getParentName() + ",name=" + this.callBackIf_.getname());
        this.init();
    }

    public OpmnComp(Locale loc) {
        super(loc);
        this.init();
    }

    protected OpmnComp(String domain) {
        super(domain);
        this.init();
    }

    final void init() {
        this.initPrivate();
        this.initGeneral();
    }

    protected void initPrivate() {
    }

    protected void initGeneral() {
        HashMap<String, String> persistenceOnUpdate = new HashMap<String, String>();
        persistenceOnUpdate.put("persistPolicy", "OnUpdate");
        HashMap<String, String> persistenceNever = new HashMap<String, String>();
        persistenceNever.put("persistPolicy", "Never");
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("name", "java.lang.String", this.getLocalizedMessage("opmncomp_enabled"), true, false, false), persistenceNever);
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("enabled", "boolean", this.getLocalizedMessage("opmncomp_enabled"), true, true, true), persistenceOnUpdate);
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("getAttrs", this.getLocalizedMessage("opmncomp_getAttrs"), null, "javax.management.openmbean.CompositeData", 0), persistenceNever);
        MBeanParameterInfo[] params = new MBeanParameterInfo[]{new MBeanParameterInfo("attrName", "java.lang.String", this.getLocalizedMessage("opmn_param_attrName"))};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("getAttr", this.getLocalizedMessage("opmncomp_getAttr"), params, "java.lang.String", 0), persistenceNever);
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("removeAttr", this.getLocalizedMessage("opmncomp_removeAttr"), params, "void", 1), persistenceOnUpdate);
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("attrName", "java.lang.String", this.getLocalizedMessage("opmn_param_attrName")), new MBeanParameterInfo("attrValue", "java.lang.String", this.getLocalizedMessage("opmn_param_attrValue"))};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("setAttr", this.getLocalizedMessage("opmncomp_setAttr"), params, "void", 1), persistenceOnUpdate);
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("getProcs", this.getLocalizedMessage("opmncomp_getProcs"), null, "[Ljavax.management.ObjectName;", 0), persistenceNever);
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("getParameters", this.getLocalizedMessage("opmncomp_getParameters"), null, "javax.management.openmbean.CompositeData", 0), persistenceNever);
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("category", "java.lang.String", this.getLocalizedMessage("opmncomp_param_paramCategory")), new MBeanParameterInfo("paramName", "java.lang.String", this.getLocalizedMessage("opmncomp_param_paramName"))};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("getParameter", this.getLocalizedMessage("opmncomp_getParameter"), params, "java.lang.String", 0), persistenceNever);
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("removeParameter", this.getLocalizedMessage("opmncomp_removeParameter"), params, "void", 1), persistenceOnUpdate);
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("category", "java.lang.String", this.getLocalizedMessage("opmncomp_param_paramCategory")), new MBeanParameterInfo("paramName", "java.lang.String", this.getLocalizedMessage("opmncomp_param_paramName")), new MBeanParameterInfo("paramValue", "java.lang.String", this.getLocalizedMessage("opmncomp_param_paramValue"))};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("setParameter", this.getLocalizedMessage("opmncomp_setParameter"), params, "void", 1), persistenceOnUpdate);
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("getEnvironments", this.getLocalizedMessage("opmncomp_getEnvironments"), null, "[Ljavax.management.openmbean.CompositeData;", 0), persistenceNever);
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("envName", "java.lang.String", this.getLocalizedMessage("opmn_param_envName"))};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("getEnvironment", this.getLocalizedMessage("opmncomp_getEnvironment"), params, "javax.management.openmbean.CompositeData", 0), persistenceNever);
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("removeEnvironment", this.getLocalizedMessage("opmncomp_removeEnvironment"), params, "void", 1), persistenceOnUpdate);
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("envName", "java.lang.String", this.getLocalizedMessage("opmn_param_envName")), new MBeanParameterInfo("envValues", "[Ljava.lang.String;", this.getLocalizedMessage("opmn_param_envValues")), new MBeanParameterInfo("append", "boolean", this.getLocalizedMessage("opmn_param_envAppend")), new MBeanParameterInfo("conversion", "boolean", this.getLocalizedMessage("opmn_param_envConversion"))};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("addEnvironment", this.getLocalizedMessage("opmncomp_addEnvironment"), params, "void", 1), persistenceOnUpdate);
        params[1] = new MBeanParameterInfo("envValue", "java.lang.String", this.getLocalizedMessage("opmn_param_envValue"));
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("appendEnvironment", this.getLocalizedMessage("opmncomp_appendEnvironment"), params, "void", 1), persistenceOnUpdate);
    }

    protected Iterator getProcMBeans() {
        return this.procMBeans_.iterator();
    }

    public String getDescription() {
        return this.getLocalizedMessage("opmncomp_OPMNComp_desc");
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) {
        this.mbeanServer_ = server;
        return name;
    }

    public void postRegister(Boolean registrationDone) {
        if (!registrationDone.booleanValue()) {
            return;
        }
        this.registerProcMBeans();
    }

    public void preDeregister() throws Exception {
        this.unregisterProcMBeans();
    }

    protected void registerProcMBeans() {
        OpmnProcCallBackIf[] procs = this.callBackIf_.getProcs();
        if (procs == null || procs.length == 0) {
            return;
        }
        for (int i = 0; i < procs.length; ++i) {
            try {
                this.registerProcMBean(procs[i]);
                continue;
            }
            catch (Exception e) {
                logger_.log(Level.WARNING, "register proc mbean failed", e);
            }
        }
    }

    protected OpmnProc registerProcMBean(OpmnProcCallBackIf callBack) throws Exception {
        Class<?> mbeanCl = Class.forName(callBack.getMBeanClassName(), true, this.getClass().getClassLoader());
        Class[] argTypes = new Class[]{OpmnProcCallBackIf.class};
        Constructor<?> mbeanConst = mbeanCl.getConstructor(argTypes);
        Object[] args = new Object[]{callBack};
        OpmnProc mbean = (OpmnProc)mbeanConst.newInstance(args);
        return this.registerProcMBean(mbean);
    }

    public OpmnProc registerProcMBean(OpmnProc mbean) throws Exception {
        this.getMyMBeanServer().registerMBean(ModelMBeanFactory.getModelMBean(mbean), mbean.getObjectName());
        mbean.setParent(this);
        logger_.fine("reg proc: " + mbean.getObjectName());
        this.procMBeans_.add(mbean);
        return mbean;
    }

    private void unregisterProcMBeans() {
        for (int i = this.procMBeans_.size() - 1; i >= 0; --i) {
            OpmnProc mbean = (OpmnProc)this.procMBeans_.get(i);
            this.unregisterProcMBean(mbean);
        }
    }

    protected void unregisterProcMBean(OpmnProc mbean) {
        try {
            if (this.getMyMBeanServer().isRegistered(mbean.getObjectName())) {
                this.getMyMBeanServer().unregisterMBean(mbean.getObjectName());
            }
            this.procMBeans_.remove(mbean);
            logger_.fine("unreg proc: " + mbean.getObjectName());
        }
        catch (InstanceNotFoundException e) {
            logger_.log(Level.WARNING, "unregister proc mbean failed", e);
        }
        catch (MBeanRegistrationException e) {
            logger_.log(Level.WARNING, "unregister proc mbean failed", e);
        }
        catch (MalformedObjectNameException e) {
            logger_.log(Level.WARNING, "unregister proc mbean failed", e);
        }
    }

    public String getname() {
        return this.callBackIf_.getname();
    }

    public void store() {
        try {
            this.callBackIf_.store();
        }
        catch (ConfigMBeanException e) {
            if (logger_.isLoggable(Level.SEVERE)) {
                logger_.log(Level.SEVERE, e.getMessage(), e);
            }
            throw new JMXRuntimeException((Throwable)e);
        }
    }

    public CompositeData getAttrs() {
        return this.callBackIf_.getAttrs();
    }

    public String getAttr(String attrName) throws ConfigMBeanException {
        return this.callBackIf_.getAttr(attrName);
    }

    public void setAttr(String attrName, String attrValue) throws ConfigMBeanException {
        this.callBackIf_.setAttr(attrName, attrValue);
    }

    public void removeAttr(String attrName) throws ConfigMBeanException {
        this.callBackIf_.removeAttr(attrName);
    }

    public boolean getenabled() {
        return this.callBackIf_.isEnabled();
    }

    public boolean isenabled() {
        return this.callBackIf_.isEnabled();
    }

    public void setenabled(boolean enable) throws ConfigMBeanException {
        this.callBackIf_.setEnabled(enable);
    }

    public ObjectName[] getProcs() {
        if (this.procMBeans_ == null || this.procMBeans_.size() == 0) {
            return new ObjectName[0];
        }
        ObjectName[] names = new ObjectName[this.procMBeans_.size()];
        try {
            for (int i = 0; i < names.length; ++i) {
                names[i] = ((OpmnProc)this.procMBeans_.get(i)).getObjectName();
            }
        }
        catch (MalformedObjectNameException mfe) {
            logger_.log(Level.WARNING, "proc mbean list contains non-ProcMBean type", mfe);
        }
        return names;
    }

    public CompositeData getParameters() {
        return this.callBackIf_.getParameters();
    }

    public String getParameter(String category, String paramName) throws ConfigMBeanException {
        return this.callBackIf_.getParameter(category, paramName);
    }

    public void setParameter(String category, String paramName, String paramValue) throws ConfigMBeanException {
        this.callBackIf_.setParameter(category, paramName, paramValue);
    }

    public void removeParameter(String category, String paramName) throws ConfigMBeanException {
        this.callBackIf_.removeParameter(category, paramName);
    }

    public CompositeData[] getEnvironments() {
        return this.callBackIf_.getEnvironments();
    }

    public CompositeData getEnvironment(String envName) throws ConfigMBeanException {
        return this.callBackIf_.getEnvironment(envName);
    }

    public void addEnvironment(String envName, String[] envValues, boolean append, boolean conversion) throws ConfigMBeanException {
        this.callBackIf_.addEnvironment(envName, envValues, append, conversion);
    }

    public void appendEnvironment(String envName, String envValue, boolean append, boolean conversion) throws ConfigMBeanException {
        this.callBackIf_.appendEnvironment(envName, envValue, append, conversion);
    }

    public void removeEnvironment(String envName) throws ConfigMBeanException {
        this.callBackIf_.removeEnvironment(envName);
    }
}

