/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.management.mbeans;

import java.util.List;
import java.util.Locale;
import javax.management.MBeanParameterInfo;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import oracle.oc4j.admin.jmx.shared.util.ObjectNameUtil;
import oracle.oc4j.admin.management.callbackinterfaces.JmsAdministratorCallBackIf;
import oracle.oc4j.admin.management.mbeans.J2EEServerDependentObjectBase;
import oracle.oc4j.admin.management.mbeans.JmsAdministratorMBean;

public class JmsAdministrator
extends J2EEServerDependentObjectBase
implements JmsAdministratorMBean {
    private JmsAdministratorCallBackIf m_callback = null;

    public JmsAdministrator(JmsAdministratorCallBackIf callback) {
        this.m_callback = callback;
        this.setBaseObjectName(":j2eeType=JMSAdministratorResource,name=" + ObjectNameUtil.quote((String)"JMSAdministrator") + ",J2EEServer=" + "standalone");
        this.init();
    }

    public JmsAdministrator(Locale loc) {
        super(loc);
        this.init();
    }

    private void init() {
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("enabled", "boolean", this.getLocalizedMessage("jmsadministrator_getenabled"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("destinations", "java.util.List", this.getLocalizedMessage("jmsadministrator_getdestinations"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("connectionFactories", "java.util.List", this.getLocalizedMessage("jmsadministrator_getconnectionfactories"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("configProperties", "java.util.Map", this.getLocalizedMessage("jmsadministrator_getconfigproperties"), true, false, false));
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("addFactory", this.getLocalizedMessage("jmsadministrator_addfactory"), new MBeanParameterInfo[]{new MBeanParameterInfo("domain", "java.lang.String", this.getLocalizedMessage("jmsadministrator_addfactory_domain")), new MBeanParameterInfo("location", "java.lang.String", this.getLocalizedMessage("jmsadministrator_addfactory_location")), new MBeanParameterInfo("host", "java.lang.String", this.getLocalizedMessage("jmsadministrator_addfactory_host")), new MBeanParameterInfo("port", "java.lang.String", this.getLocalizedMessage("jmsadministrator_addfactory_port")), new MBeanParameterInfo("username", "java.lang.String", this.getLocalizedMessage("jmsadministrator_addfactory_username")), new MBeanParameterInfo("password", "java.lang.String", this.getLocalizedMessage("jmsadministrator_addfactory_password")), new MBeanParameterInfo("clientID", "java.lang.String", this.getLocalizedMessage("jmsadministrator_addfactory_clientid")), new MBeanParameterInfo("isXA", "java.lang.Boolean", this.getLocalizedMessage("jmsadministrator_addfactory_isxa"))}, "void", 1));
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("removeFactory", this.getLocalizedMessage("jmsadministrator_removefactory"), new MBeanParameterInfo[]{new MBeanParameterInfo("location", "java.lang.String", this.getLocalizedMessage("jmsadministrator_removefactory_location"))}, "void", 1));
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("addDestination", this.getLocalizedMessage("jmsadministrator_adddestination"), new MBeanParameterInfo[]{new MBeanParameterInfo("domain", "java.lang.String", this.getLocalizedMessage("jmsadministrator_adddestination_domain")), new MBeanParameterInfo("name", "java.lang.String", this.getLocalizedMessage("jmsadministrator_adddestination_name")), new MBeanParameterInfo("location", "java.lang.String", this.getLocalizedMessage("jmsadministrator_adddestination_location")), new MBeanParameterInfo("persistenceFile", "java.lang.String", this.getLocalizedMessage("jmsadministrator_adddestination_persistencefile")), new MBeanParameterInfo("description", "java.lang.String", this.getLocalizedMessage("jmsadministrator_adddestination_description"))}, "void", 1));
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("removeDestination", this.getLocalizedMessage("jmsadministrator_removedestination"), new MBeanParameterInfo[]{new MBeanParameterInfo("name", "java.lang.String", this.getLocalizedMessage("jmsadministrator_removedestination_name")), new MBeanParameterInfo("force", "java.lang.Boolean", this.getLocalizedMessage("jmsadministrator_removedestination_force")), new MBeanParameterInfo("removePFile", "java.lang.Boolean", this.getLocalizedMessage("jmsadministrator_removedestination_removepfile"))}, "void", 1));
    }

    public boolean getenabled() {
        return this.m_callback.getV1Enabled();
    }

    public void addFactory(String domain, String location, String host, String port, String username, String password, String clientID, Boolean isXA) throws Exception {
        this.m_callback.addV1Factory(domain, location, host, port, username, password, clientID, isXA);
    }

    public void removeFactory(String location) throws Exception {
        this.m_callback.removeV1Factory(location);
    }

    public void addDestination(String domain, String name, String location, String persistenceFile, String description) throws Exception {
        this.m_callback.addV1Destination(domain, name, location, persistenceFile, description);
    }

    public void removeDestination(String name, Boolean force, Boolean removePFile) throws Exception {
        this.m_callback.removeV1Destination(name, force, removePFile);
    }

    public List getdestinations() throws Exception {
        return this.m_callback.getV1Destinations();
    }

    public List getconnectionFactories() throws Exception {
        return this.m_callback.getV1ConnectionFactories();
    }
}

