/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.jmx.server.state;

import java.io.ObjectInputStream;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.loading.ClassLoaderRepository;
import oracle.oc4j.admin.jmx.server.state.JMXStateFactoryImpl;
import oracle.oc4j.admin.jmx.shared.exceptions.JMXRuntimeException;

public class ApplicationStateFilterMBeanServer
implements MBeanServer {
    private MBeanServer mbeanServer_ = null;

    public ApplicationStateFilterMBeanServer(MBeanServer server) {
        if (server == null) {
            throw new NullPointerException("MBeanServer cannot be null");
        }
        this.mbeanServer_ = server;
    }

    private synchronized void preProcess(ObjectName name) {
        if (name == null) {
            throw new JMXRuntimeException("ObjectName cannot be null");
        }
        String domain = name.getDomain();
        if (domain == null) {
            throw new JMXRuntimeException("ObjectName cannot have unspecified domain: " + name);
        }
        if ("ias".equals(domain) || "JMImplementation".equals(domain)) {
            domain = "system";
        }
        if ("oc4j".equals(domain)) {
            domain = "J2EEApplication".equals(name.getKeyProperty("j2eeType")) ? name.getKeyProperty("name") : (name.getKeyProperty("J2EEApplication") != null ? name.getKeyProperty("J2EEApplication") : "system");
        }
        JMXStateFactoryImpl.setApplicationForCall(domain);
    }

    private synchronized void postProcess() {
        JMXStateFactoryImpl.unsetApplicationForCall();
    }

    public final ClassLoader getClassLoaderFor(ObjectName mbeanName) throws InstanceNotFoundException {
        return this.mbeanServer_.getClassLoaderFor(mbeanName);
    }

    public final ClassLoader getClassLoader(ObjectName loaderName) throws InstanceNotFoundException {
        return this.mbeanServer_.getClassLoader(loaderName);
    }

    public final ClassLoaderRepository getClassLoaderRepository() {
        return this.mbeanServer_.getClassLoaderRepository();
    }

    public final Object instantiate(String className) throws ReflectionException, MBeanException {
        return this.mbeanServer_.instantiate(className);
    }

    public final Object instantiate(String className, ObjectName loaderName) throws ReflectionException, MBeanException, InstanceNotFoundException {
        return this.mbeanServer_.instantiate(className, loaderName);
    }

    public final Object instantiate(String className, Object[] params, String[] signature) throws ReflectionException, MBeanException {
        return this.mbeanServer_.instantiate(className, params, signature);
    }

    public final Object instantiate(String className, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, MBeanException, InstanceNotFoundException {
        return this.mbeanServer_.instantiate(className, loaderName, params, signature);
    }

    public final void addNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        this.mbeanServer_.addNotificationListener(name, listener, filter, handback);
    }

    public final void addNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        this.mbeanServer_.addNotificationListener(name, listener, filter, handback);
    }

    public final void removeNotificationListener(ObjectName name, NotificationListener listener) throws InstanceNotFoundException, ListenerNotFoundException {
        this.mbeanServer_.removeNotificationListener(name, listener);
    }

    public final void removeNotificationListener(ObjectName name, ObjectName listener) throws InstanceNotFoundException, ListenerNotFoundException {
        this.mbeanServer_.removeNotificationListener(name, listener);
    }

    public final void removeNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        this.mbeanServer_.removeNotificationListener(name, listener, filter, handback);
    }

    public final void removeNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        this.mbeanServer_.removeNotificationListener(name, listener, filter, handback);
    }

    public final ObjectInstance createMBean(String className, ObjectName name) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        return this.mbeanServer_.createMBean(className, name);
    }

    public final ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        return this.mbeanServer_.createMBean(className, name, loaderName);
    }

    public final ObjectInstance createMBean(String className, ObjectName name, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        return this.mbeanServer_.createMBean(className, name, params, signature);
    }

    public final ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        return this.mbeanServer_.createMBean(className, name, loaderName, params, signature);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ObjectInstance registerMBean(Object object, ObjectName name) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        if (name == null) {
            return this.mbeanServer_.registerMBean(object, name);
        }
        try {
            this.preProcess(name);
            ObjectInstance objectInstance = this.mbeanServer_.registerMBean(object, name);
            return objectInstance;
        }
        finally {
            this.postProcess();
        }
    }

    public final String[] getDomains() {
        return this.mbeanServer_.getDomains();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unregisterMBean(ObjectName name) throws InstanceNotFoundException, MBeanRegistrationException {
        try {
            this.preProcess(name);
            this.mbeanServer_.unregisterMBean(name);
        }
        finally {
            this.postProcess();
        }
    }

    public final ObjectInstance getObjectInstance(ObjectName name) throws InstanceNotFoundException {
        return this.mbeanServer_.getObjectInstance(name);
    }

    public final Set queryMBeans(ObjectName name, QueryExp query) {
        return this.mbeanServer_.queryMBeans(name, query);
    }

    public final Set queryNames(ObjectName name, QueryExp query) {
        return this.mbeanServer_.queryNames(name, query);
    }

    public final boolean isRegistered(ObjectName name) {
        return this.mbeanServer_.isRegistered(name);
    }

    public final Integer getMBeanCount() {
        return this.mbeanServer_.getMBeanCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object getAttribute(ObjectName name, String attribute) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException {
        try {
            this.preProcess(name);
            Object object = this.mbeanServer_.getAttribute(name, attribute);
            return object;
        }
        finally {
            this.postProcess();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final AttributeList getAttributes(ObjectName name, String[] attributes) throws InstanceNotFoundException, ReflectionException {
        try {
            this.preProcess(name);
            AttributeList attributeList = this.mbeanServer_.getAttributes(name, attributes);
            return attributeList;
        }
        finally {
            this.postProcess();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setAttribute(ObjectName name, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        try {
            this.preProcess(name);
            this.mbeanServer_.setAttribute(name, attribute);
        }
        finally {
            this.postProcess();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final AttributeList setAttributes(ObjectName name, AttributeList attributes) throws InstanceNotFoundException, ReflectionException {
        try {
            this.preProcess(name);
            AttributeList attributeList = this.mbeanServer_.setAttributes(name, attributes);
            return attributeList;
        }
        finally {
            this.postProcess();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object invoke(ObjectName name, String operationName, Object[] params, String[] signature) throws InstanceNotFoundException, MBeanException, ReflectionException {
        try {
            this.preProcess(name);
            Object object = this.mbeanServer_.invoke(name, operationName, params, signature);
            return object;
        }
        finally {
            this.postProcess();
        }
    }

    public final String getDefaultDomain() {
        return this.mbeanServer_.getDefaultDomain();
    }

    public final MBeanInfo getMBeanInfo(ObjectName name) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        return this.mbeanServer_.getMBeanInfo(name);
    }

    public final boolean isInstanceOf(ObjectName name, String className) throws InstanceNotFoundException {
        return this.mbeanServer_.isInstanceOf(name, className);
    }

    public final ObjectInputStream deserialize(ObjectName name, byte[] data) throws InstanceNotFoundException, OperationsException {
        return this.mbeanServer_.deserialize(name, data);
    }

    public final ObjectInputStream deserialize(String className, byte[] data) throws OperationsException, ReflectionException {
        return this.mbeanServer_.deserialize(className, data);
    }

    public final ObjectInputStream deserialize(String className, ObjectName loaderName, byte[] data) throws InstanceNotFoundException, OperationsException, ReflectionException {
        return this.mbeanServer_.deserialize(className, loaderName, data);
    }
}

