/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.jmx.server;

import com.evermind.compiler.CompilerFactory;
import com.evermind.server.Application;
import com.evermind.server.ContextContainer;
import com.evermind.server.OC4JServer;
import com.evermind.server.ThreadState;
import com.evermind.util.OC4JRuntimeProperties;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.naming.NamingException;
import oracle.j2ee.util.TraceLogger;
import oracle.oc4j.admin.internal.OpmnConfigCallBack;
import oracle.oc4j.admin.jmx.model.DefaultMBeanFactory;
import oracle.oc4j.admin.jmx.server.mbeans.model.ModelMBeanFactory;
import oracle.oc4j.admin.jmx.server.state.ApplicationStateFilterMBeanServer;
import oracle.oc4j.admin.jmx.server.state.JMXStateFactoryImpl;
import oracle.oc4j.admin.jmx.server.state.LocalizationFilterMBeanServer;
import oracle.oc4j.admin.jmx.server.state.LoggerFilterMBeanServer;
import oracle.oc4j.admin.jmx.shared.Debug;
import oracle.oc4j.admin.jmx.shared.UserMBeanServer;
import oracle.oc4j.admin.jmx.shared.exceptions.JMXRuntimeException;
import oracle.oc4j.admin.management.callbackinterfaces.JSPConfigCallBack;
import oracle.oc4j.admin.management.mbeans.ClassLoading;
import oracle.oc4j.admin.management.mbeans.Compiler;
import oracle.oc4j.admin.management.mbeans.EjbCompiler;
import oracle.oc4j.admin.management.mbeans.J2EEDomain;
import oracle.oc4j.admin.management.mbeans.J2EELogging;
import oracle.oc4j.admin.management.mbeans.J2EEManagedObjectBase;
import oracle.oc4j.admin.management.mbeans.JSPConfig;
import oracle.oc4j.admin.management.mbeans.OpmnConfig;
import oracle.oc4j.admin.management.mbeans.SchedulerAggregation;
import oracle.oc4j.admin.management.mbeans.proprietary.DeploymentManagerProxy;
import oracle.oc4j.admin.management.shared.Constant;

public class Oc4jMBeanServerFactory {
    private static Logger logger_ = TraceLogger.getLogger(Oc4jMBeanServerFactory.class);
    private static String mbeanServerImplementationDefaultDomainName_ = null;
    private static MBeanServer singletonMBeanServer_ = null;
    private static boolean initFlag_ = false;
    private static Set appsWithClearance_ = new HashSet();

    public static MBeanServer getMBeanServer() {
        if (!initFlag_) {
            Oc4jMBeanServerFactory.init();
        }
        return singletonMBeanServer_;
    }

    public static MBeanServer getMBeanServer(String domain, MBeanServer server) {
        if (domain == null) {
            return null;
        }
        if ("oc4j".equals(domain) || appsWithClearance_.contains(domain)) {
            if (server != null) {
                return new LocalizationFilterMBeanServer((MBeanServer)new UserMBeanServer(domain, server, true));
            }
            return new LocalizationFilterMBeanServer((MBeanServer)new UserMBeanServer(domain, Oc4jMBeanServerFactory.getMBeanServer(), true));
        }
        return new LocalizationFilterMBeanServer((MBeanServer)new UserMBeanServer(domain, Oc4jMBeanServerFactory.getMBeanServer()));
    }

    public static MBeanServer getUserMBeanServer(Application app) {
        return new LocalizationFilterMBeanServer((MBeanServer)new UserMBeanServer(app.getName(), Oc4jMBeanServerFactory.getMBeanServer()));
    }

    public static MBeanServer getUserMBeanServer() {
        ThreadState threadState = ThreadState.getCurrentState();
        if (threadState == null) {
            throw new JMXRuntimeException("Cannot access application specific MBeanServer proxy. ThreadState is null");
        }
        ContextContainer ctxContainer = threadState.getContextContainer();
        if (ctxContainer == null) {
            throw new JMXRuntimeException("Cannot access application specific MBeanServer proxy. ContextContainer is null");
        }
        Application app = null;
        try {
            app = ctxContainer.getApplication();
        }
        catch (NamingException e) {
            throw new JMXRuntimeException((Throwable)e);
        }
        if (app == null) {
            throw new JMXRuntimeException("Cannot access application specific MBeanServer proxy. Application is null");
        }
        String appName = app.getName();
        if (appsWithClearance_.contains(appName)) {
            return new LocalizationFilterMBeanServer((MBeanServer)new UserMBeanServer(appName, Oc4jMBeanServerFactory.getMBeanServer(), true));
        }
        return new LocalizationFilterMBeanServer((MBeanServer)new UserMBeanServer(appName, Oc4jMBeanServerFactory.getMBeanServer()));
    }

    public static String getMBeanServerImplementationDefaultDomain() {
        return mbeanServerImplementationDefaultDomainName_;
    }

    private static synchronized void init() {
        ArrayList<MBeanServer> registeredMBeanServers;
        if (initFlag_) {
            return;
        }
        if (logger_.isLoggable(Level.FINEST)) {
            logger_.finest("Creating MBeanServer for domain oc4j");
        }
        JMXStateFactoryImpl.init();
        mbeanServerImplementationDefaultDomainName_ = MBeanServerFactory.newMBeanServer().getDefaultDomain();
        String JDK15_JMX_ON = System.getProperty("com.sun.management.jmxremote");
        String IAS_JMX_ON = System.getProperty("oracle.oc4j.ias.jmxremote");
        String JMX_REGISTER_MBEANSERVER_ON = System.getProperty("oracle.oc4j.jmx.mbeanserver.register");
        singletonMBeanServer_ = JDK15_JMX_ON != null && IAS_JMX_ON == null ? ((registeredMBeanServers = MBeanServerFactory.findMBeanServer(null)) == null || registeredMBeanServers.size() != 1 ? (JMX_REGISTER_MBEANSERVER_ON == null ? MBeanServerFactory.newMBeanServer("oc4j") : MBeanServerFactory.createMBeanServer("oc4j")) : registeredMBeanServers.get(0)) : (JMX_REGISTER_MBEANSERVER_ON == null ? MBeanServerFactory.newMBeanServer("oc4j") : MBeanServerFactory.createMBeanServer("oc4j"));
        System.setProperty("javax.management.builder.initial", "oracle.oc4j.admin.jmx.server.Oc4jMBeanServerBuilder");
        J2EEManagedObjectBase.registerMBeanServer("oc4j", singletonMBeanServer_);
        DefaultMBeanFactory.init(ModelMBeanFactory.getInstance());
        initFlag_ = true;
        Oc4jMBeanServerFactory.registerSystemMBeans(singletonMBeanServer_);
        singletonMBeanServer_ = new ApplicationStateFilterMBeanServer(singletonMBeanServer_);
        if (Debug.isDebug()) {
            singletonMBeanServer_ = new LoggerFilterMBeanServer(singletonMBeanServer_);
        }
    }

    private static void registerSystemMBeans(MBeanServer mbeanServer) {
        try {
            if (logger_.isLoggable(Level.FINEST)) {
                logger_.finest("Registering J2EELogging MBean with MBeanServer");
            }
            J2EELogging loggingMBean = new J2EELogging();
            mbeanServer.registerMBean(ModelMBeanFactory.getModelMBean(loggingMBean), loggingMBean.getObjectName());
            if (logger_.isLoggable(Level.FINEST)) {
                logger_.finest("Registering the J2EEDomain MBean with MBeanServer");
            }
            J2EEDomain domainMBean = new J2EEDomain();
            mbeanServer.registerMBean(ModelMBeanFactory.getModelMBean(domainMBean), domainMBean.getObjectName());
            if (logger_.isLoggable(Level.FINEST)) {
                logger_.finest("Registering the EJBCompiler MBean with MBeanServer");
            }
            EjbCompiler ejbCompilerMBean = new EjbCompiler();
            mbeanServer.registerMBean(ModelMBeanFactory.getModelMBean(ejbCompilerMBean), ejbCompilerMBean.getObjectName());
            Compiler compilerMBean = new Compiler(CompilerFactory.instance(), CompilerFactory.instance().getName());
            mbeanServer.registerMBean(ModelMBeanFactory.getModelMBean(compilerMBean), compilerMBean.getObjectName());
            if (logger_.isLoggable(Level.FINEST)) {
                logger_.finest("Registering the Compiler MBean with MBeanServer");
            }
            JSPConfig jspConfigMBean = new JSPConfig(new JSPConfigCallBack());
            mbeanServer.registerMBean(ModelMBeanFactory.getModelMBean(jspConfigMBean), jspConfigMBean.getObjectName());
            boolean localTest = "true".equals(System.getProperty("opmnmbean.localtest"));
            if (OC4JServer.getOPMNEnabled() || localTest) {
                OpmnConfig opmnConfigMBean = new OpmnConfig(new OpmnConfigCallBack("Singleton", OC4JRuntimeProperties.getOracleHome(), OC4JRuntimeProperties.getOracleOnsOracleconfighome()));
                mbeanServer.registerMBean(ModelMBeanFactory.getModelMBean(opmnConfigMBean), opmnConfigMBean.getObjectName());
            }
            DeploymentManagerProxy deploymentManagerProxy = new DeploymentManagerProxy(mbeanServer);
            mbeanServer.registerMBean(deploymentManagerProxy, Constant.deploymentManagerProxyObjectName);
            SchedulerAggregation schedulerAggregationMBean = new SchedulerAggregation();
            mbeanServer.registerMBean(ModelMBeanFactory.getModelMBean(schedulerAggregationMBean), schedulerAggregationMBean.getObjectName());
            ClassLoading.getInstance();
        }
        catch (Exception e) {
            if (logger_.isLoggable(Level.WARNING)) {
                logger_.log(Level.WARNING, e.getMessage(), e);
            }
            throw new JMXRuntimeException((Throwable)e, "Nested Exception: JMX MBeanServer initialization error");
        }
    }

    public static ObjectInstance registerMBean(Object object, ObjectName name) {
        MBeanServer oc4jMBeanServer = Oc4jMBeanServerFactory.getMBeanServer();
        try {
            if (oc4jMBeanServer.isRegistered(name)) {
                oc4jMBeanServer.unregisterMBean(name);
            }
            return oc4jMBeanServer.registerMBean(object, name);
        }
        catch (MBeanRegistrationException e) {
            throw new JMXRuntimeException((Throwable)e);
        }
        catch (InstanceAlreadyExistsException e) {
            throw new JMXRuntimeException((Throwable)e);
        }
        catch (NotCompliantMBeanException e) {
            throw new JMXRuntimeException((Throwable)e);
        }
        catch (InstanceNotFoundException e) {
            throw new JMXRuntimeException((Throwable)e);
        }
    }

    public static void unregisterMBean(ObjectName name) {
        MBeanServer oc4jMBeanServer = Oc4jMBeanServerFactory.getMBeanServer();
        try {
            if (oc4jMBeanServer.isRegistered(name)) {
                oc4jMBeanServer.unregisterMBean(name);
            }
        }
        catch (MBeanRegistrationException e) {
            throw new JMXRuntimeException((Throwable)e);
        }
        catch (InstanceNotFoundException e) {
            throw new JMXRuntimeException((Throwable)e);
        }
    }

    static {
        appsWithClearance_.add("system");
        appsWithClearance_.add("default");
        appsWithClearance_.add("jmsrouter");
        appsWithClearance_.add("ascontrol");
    }
}

