/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.web;

import com.evermind.server.ApplicationServer;
import com.evermind.server.administration.ApplicationServerAdministrator;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.RuntimeMBeanException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import oracle.j2ee.util.TraceLogger;
import oracle.oc4j.admin.deploy.web.HtmlGenerator;
import oracle.oc4j.admin.jmx.server.Oc4jMBeanServerFactory;
import oracle.oc4j.admin.jmx.shared.util.EarFileUtils;
import oracle.oc4j.admin.jmx.web.HandlingException;
import oracle.oc4j.admin.jmx.web.ServletLocalizationHelper;
import oracle.oc4j.admin.management.mbeans.J2EEManagedObjectBase;
import oracle.oc4j.admin.management.shared.SharedModuleType;

public class RequestHandler {
    private static Logger logger_ = TraceLogger.getLogger(RequestHandler.class);
    private HttpServletRequest req_ = null;
    private HttpServletResponse res_ = null;
    private HtmlGenerator gen_ = null;
    private PrintWriter out_ = null;
    private String cmd_ = null;
    private ApplicationServerAdministrator _administrator = null;
    private ServletLocalizationHelper locHelper_ = null;
    String reqEncoding_ = null;

    public RequestHandler(HttpServletRequest req, HttpServletResponse res) throws IOException {
        this.req_ = req;
        this.res_ = res;
        this.reqEncoding_ = this.req_.getCharacterEncoding() != null ? this.req_.getCharacterEncoding() : this.res_.getCharacterEncoding();
        this.locHelper_ = new ServletLocalizationHelper("oracle.oc4j.admin.Messages", req, res);
        this.gen_ = new HtmlGenerator(this.locHelper_);
        this.out_ = res.getWriter();
        this.cmd_ = this.req_.getParameter("command");
        if (this.cmd_ == null) {
            this.cmd_ = "DEPLOY";
        }
        this._administrator = ApplicationServer.getApplicationServerAdministrator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRequest() {
        try {
            J2EEManagedObjectBase.setLocaleForCall(this.locHelper_.getLocale());
            if (this.cmd_.equals("SHOWUNDEPLOY")) {
                this.handleSHOWUNDEPLOYCommand();
            }
            if (this.cmd_.equals("SHOWDEPLOY")) {
                this.handleSHOWDEPLOYCommand();
            }
            if (this.cmd_.equals("SHOWUNDEPLOYRAR")) {
                this.handleSHOWUNDEPLOYRARCommand();
            }
            if (this.cmd_.equals("SHOWBIND")) {
                this.handleSHOWBINDCommand();
            }
            if (this.cmd_.equals("SHOWDEPLOYRAR")) {
                this.handleSHOWDEPLOYRARCommand();
            }
            if (this.cmd_.equals("SHOWDEPLOYOTHER")) {
                this.handleSHOWDEPLOYOTHERCommand();
            }
            if (this.cmd_.equals("SHOWDS")) {
                this.handleSHOWDSCommand();
            }
            if (this.cmd_.equals("SHOWLONGDS")) {
                this.handleSHOWLONGDSCommand();
            }
            if (this.cmd_.equals("SHOWREMOVEDS")) {
                this.handleSHOWREMOVEDSCommand();
            }
            if (this.cmd_.equals("SHOWREMOVECONPOOL")) {
                this.handleSHOWREMOVECONPOOLCommand();
            }
            if (this.cmd_.equals("SHOWMAIL")) {
                this.handleSHOWMAILCommand();
            }
            if (this.cmd_.equals("SHOWREMOVEMAIL")) {
                this.handleSHOWREMOVEMAILCommand();
            }
            if (this.cmd_.equals("DEPLOY")) {
                this.handleDEPLOYCommand();
            }
            if (this.cmd_.equals("UNDEPLOY")) {
                this.handleUNDEPLOYCommand();
            }
            if (this.cmd_.equals("UNDEPLOYRAR")) {
                this.handleUNDEPLOYRARCommand();
            }
            if (this.cmd_.equals("BIND")) {
                this.handleBINDCommand();
            }
            if (this.cmd_.equals("DEPLOYOTHER")) {
                this.handleDEPLOYOTHERCommand();
            }
            if (this.cmd_.equals("ADDDS")) {
                this.handleADDDSCommand();
            }
            if (this.cmd_.equals("ADDLONGDS")) {
                this.handleADDLONGDSCommand();
            }
            if (this.cmd_.equals("REMOVEDS")) {
                this.handleREMOVEDSCommand();
            }
            if (this.cmd_.equals("REMOVECONPOOL")) {
                this.handleREMOVECONPOOLCommand();
            }
            if (this.cmd_.equals("ADDMAIL")) {
                this.handleADDMAILCommand();
            }
            if (this.cmd_.equals("REMOVEMAIL")) {
                this.handleREMOVEMAILCommand();
            }
            if (this.cmd_.equals("SADDUSR")) {
                this.handleSADDUSRCommand();
            }
            if (this.cmd_.equals("ADDUSR")) {
                this.handleADDUSRCommand();
            }
            if (this.cmd_.equals("SADDGRP")) {
                this.handleSADDGRPCommand();
            }
            if (this.cmd_.equals("ADDGRP")) {
                this.handleADDGRPCommand();
            }
            if (this.cmd_.equals("SADDUGRP")) {
                this.handleSADDUGRPCommand();
            }
            if (this.cmd_.equals("ADDUGRP")) {
                this.handleADDUGRPCommand();
            }
            if (this.cmd_.equals("ADDUGRPE")) {
                this.handleADDUGRPECommand();
            }
            if (this.cmd_.equals("SRUGRP")) {
                this.handleSRUGRPCommand();
            }
            if (this.cmd_.equals("RUGRP")) {
                this.handleRUGRPCommand();
            }
            if (this.cmd_.equals("RUGRPE")) {
                this.handleRUGRPECommand();
            }
            if (this.cmd_.equals("SRUSR")) {
                this.handleSRUSRCommand();
            }
            if (this.cmd_.equals("RUSR")) {
                this.handleRUSRCommand();
            }
            if (this.cmd_.equals("RUSRE")) {
                this.handleRUSRECommand();
            }
            if (this.cmd_.equals("SRGRP")) {
                this.handleSRGRPCommand();
            }
            if (this.cmd_.equals("RGRP")) {
                this.handleRGRPCommand();
            }
            if (this.cmd_.equals("RGRPE")) {
                this.handleRGRPECommand();
            }
        }
        catch (HandlingException e) {
            this.gen_.reportError(e);
        }
        finally {
            J2EEManagedObjectBase.unsetLocaleForCall();
        }
        this.out_.println(this.gen_.getContent());
    }

    private void handleSHOWDEPLOYCommand() throws HandlingException {
        this.gen_.addHeader();
        this.gen_.addDeploymentForm(this.getAppNames(), this.getSiteNames());
        this.gen_.addAdminBackLink();
        this.gen_.addTrailer();
    }

    private void handleSHOWDEPLOYRARCommand() {
        this.gen_.addHeader();
        this.gen_.addRARDeploymentForm();
        this.gen_.addAdminBackLink();
        this.gen_.addTrailer();
    }

    private void handleSHOWDEPLOYOTHERCommand() throws HandlingException {
        this.gen_.addHeader();
        this.gen_.addDeploymentOtherForm(this.getAppNames());
        this.gen_.addAdminBackLink();
        this.gen_.addTrailer();
    }

    private void handleSHOWUNDEPLOYCommand() throws HandlingException {
        this.gen_.addHeader();
        this.gen_.addUndeploymentForm(this.getAppNames());
        this.gen_.addAdminBackLink();
        this.gen_.addTrailer();
    }

    private void handleSHOWUNDEPLOYRARCommand() throws HandlingException {
        this.gen_.addHeader();
        this.gen_.addUndeploymentRARForm(this.getRarNames());
        this.gen_.addAdminBackLink();
        this.gen_.addTrailer();
    }

    private void handleSHOWBINDCommand() throws HandlingException {
        this.gen_.addHeader();
        this.gen_.addBindingForm(this.getSiteNames(), this.getWebModulesForAppNames());
        this.gen_.addAdminBackLink();
        this.gen_.addTrailer();
    }

    private void handleSHOWDSCommand() throws HandlingException {
        this.gen_.addHeader();
        this.gen_.addDSForm(this.getAppNames());
        this.gen_.addAdminBackLink();
        this.gen_.addTrailer();
    }

    private void handleSHOWLONGDSCommand() throws HandlingException {
        this.gen_.addHeader();
        this.gen_.addLONGDSForm(this.getConnectionPoolNames());
        this.gen_.addAdminBackLink();
        this.gen_.addTrailer();
    }

    private void handleSHOWREMOVEDSCommand() throws HandlingException {
        this.gen_.addHeader();
        this.gen_.addREMOVEDSForm(this.getManagedDataSources());
        this.gen_.addAdminBackLink();
        this.gen_.addTrailer();
    }

    private void handleSHOWREMOVECONPOOLCommand() throws HandlingException {
        this.gen_.addHeader();
        this.gen_.addREMOVECONPOOLForm(this.getJDBCResources());
        this.gen_.addAdminBackLink();
        this.gen_.addTrailer();
    }

    private void handleSHOWMAILCommand() throws HandlingException {
        this.gen_.addHeader();
        this.gen_.addSHOWMAILForm(this.getAppNames());
        this.gen_.addAdminBackLink();
        this.gen_.addTrailer();
    }

    private void handleSHOWREMOVEMAILCommand() throws HandlingException {
        this.gen_.addHeader();
        this.gen_.addREMOVEMAILForm(this.getJavaMail());
        this.gen_.addAdminBackLink();
        this.gen_.addTrailer();
    }

    private void handleDEPLOYCommand() throws HandlingException {
        this.gen_.addHeader();
        this.handleMultiPartRequest();
        this.gen_.reportSuccess();
        this.gen_.addAdminBackLink();
        this.gen_.addTrailer();
    }

    private void handleDEPLOYOTHERCommand() throws HandlingException {
        this.gen_.addHeader();
        this.handleMultiPartRequest();
        this.gen_.reportSuccess();
        this.gen_.addAdminBackLink();
        this.gen_.addTrailer();
    }

    private void handleUNDEPLOYCommand() throws HandlingException {
        this.gen_.addHeader();
        String appName = this.toUTF8(this.req_.getParameter("undeployapp"));
        try {
            this._administrator.undeploy(appName, true);
        }
        catch (Throwable t) {
            if (logger_.isLoggable(Level.SEVERE)) {
                logger_.log(Level.SEVERE, t.getMessage(), t);
            }
            throw new HandlingException(t);
        }
        this.gen_.reportSuccess();
        this.gen_.addAdminBackLink();
        this.gen_.addTrailer();
    }

    private void handleUNDEPLOYRARCommand() throws HandlingException {
        this.gen_.addHeader();
        String appName = this.toUTF8(this.req_.getParameter("undeployapp"));
        try {
            this._administrator.undeployConnector(appName, true);
        }
        catch (Throwable t) {
            if (logger_.isLoggable(Level.SEVERE)) {
                logger_.log(Level.SEVERE, t.getMessage(), t);
            }
            throw new HandlingException(t);
        }
        this.gen_.reportSuccess();
        this.gen_.addAdminBackLink();
        this.gen_.addTrailer();
    }

    private void handleBINDCommand() throws HandlingException {
        this.gen_.addHeader();
        String website = this.toUTF8(this.req_.getParameter("website"));
        String webmodule = this.toUTF8(this.req_.getParameter("webmodule"));
        String rootctx = this.toUTF8(this.req_.getParameter("rootctx"));
        try {
            int appBeg = webmodule.indexOf(40);
            int appEnd = webmodule.indexOf(41, appBeg + 1);
            String appname = webmodule.substring(appBeg + 1, appEnd);
            String modulename = webmodule.substring(0, appBeg - 1);
            this._administrator.bindWebApp(appname, modulename, website, rootctx);
        }
        catch (Throwable t) {
            if (logger_.isLoggable(Level.SEVERE)) {
                logger_.log(Level.SEVERE, t.getMessage(), t);
            }
            throw new HandlingException(t);
        }
        this.gen_.reportSuccess();
        this.gen_.addAdminBackLink();
        this.gen_.addTrailer();
    }

    private void handleADDDSCommand() throws HandlingException {
        this.gen_.addHeader();
        Object[] params = new Object[5];
        String[] signature = new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String"};
        params[0] = this.toUTF8(this.req_.getParameter("name"));
        params[1] = this.toUTF8(this.req_.getParameter("factoryclass"));
        params[2] = this.toUTF8(this.req_.getParameter("username"));
        params[3] = this.toUTF8(this.req_.getParameter("password"));
        params[4] = this.toUTF8(this.req_.getParameter("url"));
        String application = this.toUTF8(this.req_.getParameter("application"));
        try {
            MBeanServer mserv = Oc4jMBeanServerFactory.getMBeanServer();
            ObjectName appName = new ObjectName("oc4j:j2eeType=J2EEApplication,name=" + application + ",*");
            Set<ObjectName> res = mserv.queryNames(appName, null);
            Iterator<ObjectName> iter = res.iterator();
            ObjectName fullAppName = iter.next();
            mserv.invoke(fullAppName, "createJDBCConnectionPool", params, signature);
        }
        catch (RuntimeMBeanException e) {
            if (logger_.isLoggable(Level.SEVERE)) {
                logger_.log(Level.SEVERE, e.getMessage(), e);
            }
            throw new HandlingException(e);
        }
        catch (Throwable t) {
            if (logger_.isLoggable(Level.SEVERE)) {
                logger_.log(Level.SEVERE, t.getMessage(), t);
            }
            throw new HandlingException(t);
        }
        this.gen_.reportSuccess();
        this.gen_.addAdminBackLink();
        this.gen_.addTrailer();
    }

    private void handleADDLONGDSCommand() throws HandlingException {
        this.gen_.addHeader();
        Object[] params = new Object[7];
        String[] signature = new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String", "java.lang.Integer", "java.lang.String", "java.lang.String"};
        params[0] = this.toUTF8(this.req_.getParameter("name"));
        params[1] = this.toUTF8(this.req_.getParameter("username"));
        params[2] = this.toUTF8(this.req_.getParameter("password"));
        params[3] = this.toUTF8(this.req_.getParameter("jndilocation"));
        try {
            String logingTimeout = this.req_.getParameter("logintimeout");
            params[4] = new Integer(logingTimeout);
            String jdbcresource = this.toUTF8(this.req_.getParameter("connectionpoolname"));
            ObjectName jdbcResource = new ObjectName(jdbcresource);
            String connectionPoolName = jdbcResource.getKeyProperty("name");
            try {
                connectionPoolName = ObjectName.unquote(connectionPoolName);
            }
            catch (Throwable te) {
                // empty catch block
            }
            params[5] = connectionPoolName;
            params[6] = this.req_.getParameter("txlevel");
            String application = jdbcResource.getKeyProperty("J2EEApplication");
            MBeanServer mserv = Oc4jMBeanServerFactory.getMBeanServer();
            ObjectName appName = new ObjectName("oc4j:j2eeType=J2EEApplication,name=" + application + ",*");
            Set<ObjectName> res = mserv.queryNames(appName, null);
            Iterator<ObjectName> iter = res.iterator();
            ObjectName fullAppName = iter.next();
            mserv.invoke(fullAppName, "createManagedDataSource", params, signature);
        }
        catch (RuntimeMBeanException e) {
            if (logger_.isLoggable(Level.SEVERE)) {
                logger_.log(Level.SEVERE, e.getMessage(), e);
            }
            throw new HandlingException(e);
        }
        catch (Throwable t) {
            if (logger_.isLoggable(Level.SEVERE)) {
                logger_.log(Level.SEVERE, t.getMessage(), t);
            }
            throw new HandlingException(t);
        }
        this.gen_.reportSuccess();
        this.gen_.addAdminBackLink();
        this.gen_.addTrailer();
    }

    private void handleADDMAILCommand() throws HandlingException {
        this.gen_.addHeader();
        try {
            Properties props = new Properties();
            Enumeration enum5 = this.req_.getParameterNames();
            while (enum5.hasMoreElements()) {
                String pname = (String)enum5.nextElement();
                if (pname.indexOf("name") == -1) continue;
                String name = this.toUTF8(this.req_.getParameter(pname));
                String valname = pname.substring(0, 2) + "val";
                String val = this.toUTF8(this.req_.getParameter(valname));
                if (val == null || val.equals("")) continue;
                props.put(name, val);
            }
            String location = this.toUTF8(this.req_.getParameter("location"));
            Object[] paramsObj = new Object[]{location, props};
            String[] signature = new String[]{"java.lang.String", "java.util.Properties"};
            String application = this.toUTF8(this.req_.getParameter("application"));
            MBeanServer mserv = Oc4jMBeanServerFactory.getMBeanServer();
            ObjectName appName = new ObjectName("oc4j:j2eeType=J2EEApplication,name=" + application + ",*");
            Set<ObjectName> res = mserv.queryNames(appName, null);
            Iterator<ObjectName> iter = res.iterator();
            ObjectName fullAppName = iter.next();
            mserv.invoke(fullAppName, "addMailSession", paramsObj, signature);
        }
        catch (RuntimeMBeanException e) {
            if (logger_.isLoggable(Level.SEVERE)) {
                logger_.log(Level.SEVERE, e.getMessage(), e);
            }
            throw new HandlingException(e);
        }
        catch (Throwable t) {
            if (logger_.isLoggable(Level.SEVERE)) {
                logger_.log(Level.SEVERE, t.getMessage(), t);
            }
            throw new HandlingException(t);
        }
        this.gen_.reportSuccess();
        this.gen_.addAdminBackLink();
        this.gen_.addTrailer();
    }

    private void handleREMOVEDSCommand() throws HandlingException {
        this.gen_.addHeader();
        String dsNameAndApp = this.toUTF8(this.req_.getParameter("dsname"));
        int appBeg = dsNameAndApp.indexOf(40);
        int appEnd = dsNameAndApp.indexOf(41, appBeg + 1);
        String appName = dsNameAndApp.substring(appBeg + 1, appEnd);
        String dsname = dsNameAndApp.substring(0, appBeg - 1);
        if (dsname.startsWith("\"") && dsname.endsWith("\"")) {
            dsname = dsname.substring(1, dsname.length() - 1);
        }
        try {
            MBeanServer mserv = Oc4jMBeanServerFactory.getMBeanServer();
            ObjectName dsName = new ObjectName("oc4j:j2eeType=JDBCDataSource,name=" + dsname + ",J2EEApplication=" + appName + ",*");
            Set<ObjectName> res = mserv.queryNames(dsName, null);
            Iterator<ObjectName> iter = res.iterator();
            ObjectName theAppName = new ObjectName("oc4j:j2eeType=J2EEApplication,name=" + appName + ",*");
            res = mserv.queryNames(theAppName, null);
            iter = res.iterator();
            Object[] params = new Object[]{dsname};
            String[] signature = new String[]{"java.lang.String"};
            mserv.invoke(iter.next(), "removeManagedDataSource", params, signature);
        }
        catch (RuntimeMBeanException e) {
            if (logger_.isLoggable(Level.SEVERE)) {
                logger_.log(Level.SEVERE, e.getMessage(), e);
            }
            throw new HandlingException(e);
        }
        catch (Throwable t) {
            if (logger_.isLoggable(Level.SEVERE)) {
                logger_.log(Level.SEVERE, t.getMessage(), t);
            }
            throw new HandlingException(t);
        }
        this.gen_.reportSuccess();
        this.gen_.addAdminBackLink();
        this.gen_.addTrailer();
    }

    private void handleREMOVECONPOOLCommand() throws HandlingException {
        this.gen_.addHeader();
        String dsNameAndApp = this.toUTF8(this.req_.getParameter("dsname"));
        int appBeg = dsNameAndApp.indexOf(40);
        int appEnd = dsNameAndApp.indexOf(41, appBeg + 1);
        String appName = dsNameAndApp.substring(appBeg + 1, appEnd);
        String connectionPoolName = dsNameAndApp.substring(0, appBeg - 1);
        if (connectionPoolName.startsWith("\"") && connectionPoolName.endsWith("\"")) {
            connectionPoolName = connectionPoolName.substring(1, connectionPoolName.length() - 1);
        }
        try {
            MBeanServer mserv = Oc4jMBeanServerFactory.getMBeanServer();
            ObjectName dsName = new ObjectName("oc4j:j2eeType=JDBCResource,name=" + connectionPoolName + ",J2EEApplication=" + appName + ",*");
            Set<ObjectName> res = mserv.queryNames(dsName, null);
            Iterator<ObjectName> iter = res.iterator();
            ObjectName theAppName = new ObjectName("oc4j:j2eeType=J2EEApplication,name=" + appName + ",*");
            res = mserv.queryNames(theAppName, null);
            iter = res.iterator();
            Object[] params = new Object[]{connectionPoolName};
            String[] signature = new String[]{"java.lang.String"};
            mserv.invoke(iter.next(), "removeDataSourceConnectionPool", params, signature);
        }
        catch (RuntimeMBeanException e) {
            if (logger_.isLoggable(Level.SEVERE)) {
                logger_.log(Level.SEVERE, e.getMessage(), e);
            }
            throw new HandlingException(e);
        }
        catch (Throwable t) {
            if (logger_.isLoggable(Level.SEVERE)) {
                logger_.log(Level.SEVERE, t.getMessage(), t);
            }
            throw new HandlingException(t);
        }
        this.gen_.reportSuccess();
        this.gen_.addAdminBackLink();
        this.gen_.addTrailer();
    }

    private void handleREMOVEMAILCommand() throws HandlingException {
        this.gen_.addHeader();
        String msNameAndApp = this.toUTF8(this.req_.getParameter("msname"));
        int appBeg = msNameAndApp.indexOf(40);
        int appEnd = msNameAndApp.indexOf(41, appBeg + 1);
        String appName = msNameAndApp.substring(appBeg + 1, appEnd);
        String msname = msNameAndApp.substring(0, appBeg - 1);
        try {
            MBeanServer mserv = Oc4jMBeanServerFactory.getMBeanServer();
            ObjectName theAppName = new ObjectName("oc4j:j2eeType=J2EEApplication,name=" + appName + ",*");
            Set<ObjectName> res = mserv.queryNames(theAppName, null);
            Iterator<ObjectName> iter = res.iterator();
            Object[] params = new Object[]{msname};
            String[] signature = new String[]{"java.lang.String"};
            mserv.invoke(iter.next(), "removeMailSession", params, signature);
        }
        catch (RuntimeMBeanException e) {
            if (logger_.isLoggable(Level.SEVERE)) {
                logger_.log(Level.SEVERE, e.getMessage(), e);
            }
            throw new HandlingException(e);
        }
        catch (Throwable t) {
            if (logger_.isLoggable(Level.SEVERE)) {
                logger_.log(Level.SEVERE, t.getMessage(), t);
            }
            throw new HandlingException(t);
        }
        this.gen_.reportSuccess();
        this.gen_.addAdminBackLink();
        this.gen_.addTrailer();
    }

    private void handleSADDUSRCommand() throws HandlingException {
        this.gen_.addHeader();
        this.gen_.addUserManagementForm(this.getAppNames());
        this.gen_.addAdminBackLink();
        this.gen_.addTrailer();
    }

    private void handleADDUSRCommand() throws HandlingException {
        this.gen_.addHeader();
        try {
            String name = this.toUTF8(this.req_.getParameter("name"));
            String pwd = this.toUTF8(this.req_.getParameter("pwd"));
            String desc = this.toUTF8(this.req_.getParameter("desc"));
            Object[] paramsObj = new Object[]{name, pwd, desc};
            String[] signature = new String[]{"java.lang.String", "java.lang.String", "java.lang.String"};
            String application = this.toUTF8(this.req_.getParameter("app"));
            MBeanServer mserv = Oc4jMBeanServerFactory.getMBeanServer();
            ObjectName appName = new ObjectName("oc4j:j2eeType=J2EEApplication,name=" + application + ",*");
            Set<ObjectName> res = mserv.queryNames(appName, null);
            Iterator<ObjectName> iter = res.iterator();
            ObjectName fullAppName = iter.next();
            mserv.invoke(fullAppName, "addUser", paramsObj, signature);
        }
        catch (RuntimeMBeanException e) {
            if (logger_.isLoggable(Level.SEVERE)) {
                logger_.log(Level.SEVERE, e.getMessage(), e);
            }
            throw new HandlingException(e);
        }
        catch (Throwable t) {
            if (logger_.isLoggable(Level.SEVERE)) {
                logger_.log(Level.SEVERE, t.getMessage(), t);
            }
            throw new HandlingException(t);
        }
        this.gen_.reportSuccess();
        this.gen_.addAdminBackLink();
        this.gen_.addTrailer();
    }

    private void handleSADDGRPCommand() throws HandlingException {
        this.gen_.addHeader();
        this.gen_.addGroupManagementForm(this.getAppNames());
        this.gen_.addAdminBackLink();
        this.gen_.addTrailer();
    }

    private void handleADDGRPCommand() throws HandlingException {
        this.gen_.addHeader();
        try {
            String name = this.toUTF8(this.req_.getParameter("name"));
            String desc = this.toUTF8(this.req_.getParameter("desc"));
            Object[] paramsObj = new Object[]{name, desc};
            String[] signature = new String[]{"java.lang.String", "java.lang.String"};
            String application = this.toUTF8(this.req_.getParameter("app"));
            MBeanServer mserv = Oc4jMBeanServerFactory.getMBeanServer();
            ObjectName appName = new ObjectName("oc4j:j2eeType=J2EEApplication,name=" + application + ",*");
            Set<ObjectName> res = mserv.queryNames(appName, null);
            Iterator<ObjectName> iter = res.iterator();
            ObjectName fullAppName = iter.next();
            mserv.invoke(fullAppName, "addGroup", paramsObj, signature);
        }
        catch (RuntimeMBeanException e) {
            if (logger_.isLoggable(Level.SEVERE)) {
                logger_.log(Level.SEVERE, e.getMessage(), e);
            }
            throw new HandlingException(e);
        }
        catch (Throwable t) {
            if (logger_.isLoggable(Level.SEVERE)) {
                logger_.log(Level.SEVERE, t.getMessage(), t);
            }
            throw new HandlingException(t);
        }
        this.gen_.reportSuccess();
        this.gen_.addAdminBackLink();
        this.gen_.addTrailer();
    }

    private void handleADDUGRPCommand() throws HandlingException {
        this.gen_.addHeader();
        try {
            String application = this.toUTF8(this.req_.getParameter("app"));
            MBeanServer mserv = Oc4jMBeanServerFactory.getMBeanServer();
            ObjectName appName = new ObjectName("oc4j:j2eeType=J2EEApplication,name=" + application + ",*");
            Set<ObjectName> res = mserv.queryNames(appName, null);
            Iterator<ObjectName> iter = res.iterator();
            ObjectName fullAppName = iter.next();
            Set users = (Set)mserv.getAttribute(fullAppName, "users");
            Set groups = (Set)mserv.getAttribute(fullAppName, "groups");
            this.gen_.addUserToGroupForAppManagementForm(application, users, groups);
        }
        catch (RuntimeMBeanException e) {
            if (logger_.isLoggable(Level.SEVERE)) {
                logger_.log(Level.SEVERE, e.getMessage(), e);
            }
            throw new HandlingException(e);
        }
        catch (Throwable t) {
            if (logger_.isLoggable(Level.SEVERE)) {
                logger_.log(Level.SEVERE, t.getMessage(), t);
            }
            throw new HandlingException(t);
        }
        this.gen_.addAdminBackLink();
        this.gen_.addTrailer();
    }

    private void handleSADDUGRPCommand() throws HandlingException {
        this.gen_.addHeader();
        this.gen_.addUserToGroupManagementForm(this.getAppNames());
        this.gen_.addAdminBackLink();
        this.gen_.addTrailer();
    }

    private void handleADDUGRPECommand() throws HandlingException {
        this.gen_.addHeader();
        try {
            String user = this.toUTF8(this.req_.getParameter("user"));
            String group = this.toUTF8(this.req_.getParameter("group"));
            if (user.indexOf("/") != -1) {
                user = user.substring(user.indexOf("/") + 1);
            }
            if (group.indexOf("/") != -1) {
                group = group.substring(group.indexOf("/") + 1);
            }
            Object[] paramsObj = new Object[]{user, group};
            String[] signature = new String[]{"java.lang.String", "java.lang.String"};
            String application = this.toUTF8(this.req_.getParameter("app"));
            MBeanServer mserv = Oc4jMBeanServerFactory.getMBeanServer();
            ObjectName appName = new ObjectName("oc4j:j2eeType=J2EEApplication,name=" + application + ",*");
            Set<ObjectName> res = mserv.queryNames(appName, null);
            Iterator<ObjectName> iter = res.iterator();
            ObjectName fullAppName = iter.next();
            mserv.invoke(fullAppName, "addUserToGroup", paramsObj, signature);
        }
        catch (RuntimeMBeanException e) {
            if (logger_.isLoggable(Level.SEVERE)) {
                logger_.log(Level.SEVERE, e.getMessage(), e);
            }
            throw new HandlingException(e);
        }
        catch (Throwable t) {
            if (logger_.isLoggable(Level.SEVERE)) {
                logger_.log(Level.SEVERE, t.getMessage(), t);
            }
            throw new HandlingException(t);
        }
        this.gen_.reportSuccess();
        this.gen_.addAdminBackLink();
        this.gen_.addTrailer();
    }

    private void handleRUGRPCommand() throws HandlingException {
        this.gen_.addHeader();
        try {
            String application = this.toUTF8(this.req_.getParameter("app"));
            MBeanServer mserv = Oc4jMBeanServerFactory.getMBeanServer();
            ObjectName appName = new ObjectName("oc4j:j2eeType=J2EEApplication,name=" + application + ",*");
            Set<ObjectName> res = mserv.queryNames(appName, null);
            Iterator<ObjectName> iter = res.iterator();
            ObjectName fullAppName = iter.next();
            Set users = (Set)mserv.getAttribute(fullAppName, "users");
            Set groups = (Set)mserv.getAttribute(fullAppName, "groups");
            this.gen_.removeUserFromGroupForAppManagementForm(application, users, groups);
        }
        catch (RuntimeMBeanException e) {
            if (logger_.isLoggable(Level.SEVERE)) {
                logger_.log(Level.SEVERE, e.getMessage(), e);
            }
            throw new HandlingException(e);
        }
        catch (Throwable t) {
            if (logger_.isLoggable(Level.SEVERE)) {
                logger_.log(Level.SEVERE, t.getMessage(), t);
            }
            throw new HandlingException(t);
        }
        this.gen_.addAdminBackLink();
        this.gen_.addTrailer();
    }

    private void handleSRUGRPCommand() throws HandlingException {
        this.gen_.addHeader();
        this.gen_.removeUserFromGroupManagementForm(this.getAppNames());
        this.gen_.addAdminBackLink();
        this.gen_.addTrailer();
    }

    private void handleRUGRPECommand() throws HandlingException {
        this.gen_.addHeader();
        try {
            String user = this.toUTF8(this.req_.getParameter("user"));
            String group = this.toUTF8(this.req_.getParameter("group"));
            if (user.indexOf("/") != -1) {
                user = user.substring(user.indexOf("/") + 1);
            }
            if (group.indexOf("/") != -1) {
                group = group.substring(group.indexOf("/") + 1);
            }
            Object[] paramsObj = new Object[]{user, group};
            String[] signature = new String[]{"java.lang.String", "java.lang.String"};
            String application = this.toUTF8(this.req_.getParameter("app"));
            MBeanServer mserv = Oc4jMBeanServerFactory.getMBeanServer();
            ObjectName appName = new ObjectName("oc4j:j2eeType=J2EEApplication,name=" + application + ",*");
            Set<ObjectName> res = mserv.queryNames(appName, null);
            Iterator<ObjectName> iter = res.iterator();
            ObjectName fullAppName = iter.next();
            mserv.invoke(fullAppName, "removeUserFromGroup", paramsObj, signature);
        }
        catch (RuntimeMBeanException e) {
            if (logger_.isLoggable(Level.SEVERE)) {
                logger_.log(Level.SEVERE, e.getMessage(), e);
            }
            throw new HandlingException(e);
        }
        catch (Throwable t) {
            if (logger_.isLoggable(Level.SEVERE)) {
                logger_.log(Level.SEVERE, t.getMessage(), t);
            }
            throw new HandlingException(t);
        }
        this.gen_.reportSuccess();
        this.gen_.addAdminBackLink();
        this.gen_.addTrailer();
    }

    private void handleRUSRCommand() throws HandlingException {
        this.gen_.addHeader();
        try {
            String application = this.toUTF8(this.req_.getParameter("app"));
            MBeanServer mserv = Oc4jMBeanServerFactory.getMBeanServer();
            ObjectName appName = new ObjectName("oc4j:j2eeType=J2EEApplication,name=" + application + ",*");
            Set<ObjectName> res = mserv.queryNames(appName, null);
            Iterator<ObjectName> iter = res.iterator();
            ObjectName fullAppName = iter.next();
            Set users = (Set)mserv.getAttribute(fullAppName, "users");
            this.gen_.removeUserForAppManagementForm(application, users);
        }
        catch (RuntimeMBeanException e) {
            if (logger_.isLoggable(Level.SEVERE)) {
                logger_.log(Level.SEVERE, e.getMessage(), e);
            }
            throw new HandlingException(e);
        }
        catch (Throwable t) {
            if (logger_.isLoggable(Level.SEVERE)) {
                logger_.log(Level.SEVERE, t.getMessage(), t);
            }
            throw new HandlingException(t);
        }
        this.gen_.addAdminBackLink();
        this.gen_.addTrailer();
    }

    private void handleSRUSRCommand() throws HandlingException {
        this.gen_.addHeader();
        this.gen_.removeUserManagementForm(this.getAppNames());
        this.gen_.addAdminBackLink();
        this.gen_.addTrailer();
    }

    private void handleRUSRECommand() throws HandlingException {
        this.gen_.addHeader();
        try {
            String user = this.toUTF8(this.req_.getParameter("user"));
            if (user != null) {
                if (user.indexOf("/") != -1) {
                    user = user.substring(user.indexOf("/") + 1);
                }
                Object[] paramsObj = new Object[]{user};
                String[] signature = new String[]{"java.lang.String"};
                String application = this.toUTF8(this.req_.getParameter("app"));
                MBeanServer mserv = Oc4jMBeanServerFactory.getMBeanServer();
                ObjectName appName = new ObjectName("oc4j:j2eeType=J2EEApplication,name=" + application + ",*");
                Set<ObjectName> res = mserv.queryNames(appName, null);
                Iterator<ObjectName> iter = res.iterator();
                ObjectName fullAppName = iter.next();
                mserv.invoke(fullAppName, "removeUser", paramsObj, signature);
            }
        }
        catch (RuntimeMBeanException e) {
            if (logger_.isLoggable(Level.SEVERE)) {
                logger_.log(Level.SEVERE, e.getMessage(), e);
            }
            throw new HandlingException(e);
        }
        catch (Throwable t) {
            if (logger_.isLoggable(Level.SEVERE)) {
                logger_.log(Level.SEVERE, t.getMessage(), t);
            }
            throw new HandlingException(t);
        }
        this.gen_.reportSuccess();
        this.gen_.addAdminBackLink();
        this.gen_.addTrailer();
    }

    private void handleRGRPCommand() throws HandlingException {
        this.gen_.addHeader();
        try {
            String application = this.toUTF8(this.req_.getParameter("app"));
            MBeanServer mserv = Oc4jMBeanServerFactory.getMBeanServer();
            ObjectName appName = new ObjectName("oc4j:j2eeType=J2EEApplication,name=" + application + ",*");
            Set<ObjectName> res = mserv.queryNames(appName, null);
            Iterator<ObjectName> iter = res.iterator();
            ObjectName fullAppName = iter.next();
            Set groups = (Set)mserv.getAttribute(fullAppName, "groups");
            this.gen_.removeGroupForAppManagementForm(application, groups);
        }
        catch (RuntimeMBeanException e) {
            if (logger_.isLoggable(Level.SEVERE)) {
                logger_.log(Level.SEVERE, e.getMessage(), e);
            }
            throw new HandlingException(e);
        }
        catch (Throwable t) {
            if (logger_.isLoggable(Level.SEVERE)) {
                logger_.log(Level.SEVERE, t.getMessage(), t);
            }
            throw new HandlingException(t);
        }
        this.gen_.addAdminBackLink();
        this.gen_.addTrailer();
    }

    private void handleSRGRPCommand() throws HandlingException {
        this.gen_.addHeader();
        this.gen_.removeGroupManagementForm(this.getAppNames());
        this.gen_.addAdminBackLink();
        this.gen_.addTrailer();
    }

    private void handleRGRPECommand() throws HandlingException {
        this.gen_.addHeader();
        try {
            String group = this.toUTF8(this.req_.getParameter("group"));
            if (group != null) {
                if (group.indexOf("/") != -1) {
                    group = group.substring(group.indexOf("/") + 1);
                }
                Object[] paramsObj = new Object[]{group};
                String[] signature = new String[]{"java.lang.String"};
                String application = this.toUTF8(this.req_.getParameter("app"));
                MBeanServer mserv = Oc4jMBeanServerFactory.getMBeanServer();
                ObjectName appName = new ObjectName("oc4j:j2eeType=J2EEApplication,name=" + application + ",*");
                Set<ObjectName> res = mserv.queryNames(appName, null);
                Iterator<ObjectName> iter = res.iterator();
                ObjectName fullAppName = iter.next();
                mserv.invoke(fullAppName, "removeGroup", paramsObj, signature);
            }
        }
        catch (RuntimeMBeanException e) {
            if (logger_.isLoggable(Level.SEVERE)) {
                logger_.log(Level.SEVERE, e.getMessage(), e);
            }
            throw new HandlingException(e);
        }
        catch (Throwable t) {
            if (logger_.isLoggable(Level.SEVERE)) {
                logger_.log(Level.SEVERE, t.getMessage(), t);
            }
            throw new HandlingException(t);
        }
        this.gen_.reportSuccess();
        this.gen_.addAdminBackLink();
        this.gen_.addTrailer();
    }

    private Set getConnectionPoolNames() throws HandlingException {
        try {
            MBeanServer mserv = Oc4jMBeanServerFactory.getMBeanServer();
            ObjectName appObjectName = new ObjectName("oc4j:j2eeType=JDBCResource,*");
            Set<ObjectName> res = mserv.queryNames(appObjectName, null);
            return res;
        }
        catch (MalformedObjectNameException e) {
            throw new HandlingException(e, "Invalid pattern: oc4j:j2eeType=JDBCResource,*");
        }
    }

    private Set getAppNames() throws HandlingException {
        try {
            MBeanServer mserv = Oc4jMBeanServerFactory.getMBeanServer();
            ObjectName appObjectName = new ObjectName("oc4j:j2eeType=J2EEApplication,*");
            Set<ObjectName> res = mserv.queryNames(appObjectName, null);
            Iterator<ObjectName> iter = res.iterator();
            HashSet<String> appNames = new HashSet<String>();
            while (iter.hasNext()) {
                ObjectName objName = iter.next();
                appNames.add(objName.getKeyProperty("name"));
            }
            return appNames;
        }
        catch (MalformedObjectNameException e) {
            throw new HandlingException(e, "Invalid pattern: oc4j:j2eeType=J2EEApplication,*");
        }
    }

    private Set getRarNames() throws HandlingException {
        try {
            MBeanServer mserv = Oc4jMBeanServerFactory.getMBeanServer();
            ObjectName rarObjectName = new ObjectName("oc4j:j2eeType=ResourceAdapterModule,J2EEApplication=default,*");
            Set<ObjectName> res = mserv.queryNames(rarObjectName, null);
            Iterator<ObjectName> iter = res.iterator();
            HashSet<String> rarNames = new HashSet<String>();
            while (iter.hasNext()) {
                ObjectName objName = iter.next();
                rarNames.add(objName.getKeyProperty("name"));
            }
            return rarNames;
        }
        catch (MalformedObjectNameException e) {
            throw new HandlingException(e, "Invalid pattern: oc4j:j2eeType=ResourceAdapterModule,J2EEApplication=default,*");
        }
    }

    private Set getSiteNames() throws HandlingException {
        try {
            MBeanServer mserv = Oc4jMBeanServerFactory.getMBeanServer();
            ObjectName appObjectName = new ObjectName("oc4j:j2eeType=J2EEWebSite,*");
            Set<ObjectName> res = mserv.queryNames(appObjectName, null);
            Iterator<ObjectName> iter = res.iterator();
            HashSet<String> siteNames = new HashSet<String>();
            while (iter.hasNext()) {
                ObjectName objName = iter.next();
                siteNames.add(objName.getKeyProperty("name"));
            }
            return siteNames;
        }
        catch (MalformedObjectNameException e) {
            throw new HandlingException(e, "Invalid pattern: oc4j:j2eeType=J2EEApplication,*");
        }
    }

    private Set getWebModulesForAppNames() throws HandlingException {
        try {
            MBeanServer mserv = Oc4jMBeanServerFactory.getMBeanServer();
            ObjectName appObjectName = new ObjectName("oc4j:j2eeType=J2EEApplication,*");
            Set<ObjectName> res = mserv.queryNames(appObjectName, null);
            Iterator<ObjectName> iter = res.iterator();
            HashSet<String> webModForApps = new HashSet<String>();
            String app = null;
            while (iter.hasNext()) {
                ObjectName objName = iter.next();
                app = objName.getKeyProperty("name");
                ObjectName webObjectName = new ObjectName("oc4j:j2eeType=WebModule,J2EEApplication=" + app + ",*");
                Set<ObjectName> webres = mserv.queryNames(webObjectName, null);
                Iterator<ObjectName> iterWeb = webres.iterator();
                String webMod = null;
                while (iterWeb.hasNext()) {
                    ObjectName webObjName = iterWeb.next();
                    webMod = webObjName.getKeyProperty("name");
                    webModForApps.add(webMod + " (" + app + ")");
                }
            }
            return webModForApps;
        }
        catch (MalformedObjectNameException e) {
            throw new HandlingException(e, "Invalid pattern: oc4j:j2eeType=J2EEApplication,*");
        }
    }

    private Set getManagedDataSources() throws HandlingException {
        try {
            MBeanServer mserv = Oc4jMBeanServerFactory.getMBeanServer();
            ObjectName jdbcObjectName = new ObjectName("oc4j:j2eeType=JDBCDataSource,*");
            Set<ObjectName> res = mserv.queryNames(jdbcObjectName, null);
            Iterator<ObjectName> iter = res.iterator();
            HashSet<String> ds = new HashSet<String>();
            String name = null;
            String app = null;
            while (iter.hasNext()) {
                ObjectName objName = iter.next();
                name = objName.getKeyProperty("name");
                app = objName.getKeyProperty("J2EEApplication");
                String jdbcResource = objName.getKeyProperty("JDBCResource");
                if (jdbcResource.equals("\"\"")) continue;
                ds.add(name + " (" + app + ")");
            }
            return ds;
        }
        catch (MalformedObjectNameException e) {
            throw new HandlingException(e, "Invalid pattern: oc4j:j2eeType=JDBCDataSource,*");
        }
    }

    private Set getJDBCResources() throws HandlingException {
        try {
            MBeanServer mserv = Oc4jMBeanServerFactory.getMBeanServer();
            ObjectName jdbcObjectName = new ObjectName("oc4j:j2eeType=JDBCResource,*");
            Set<ObjectName> res = mserv.queryNames(jdbcObjectName, null);
            Iterator<ObjectName> iter = res.iterator();
            HashSet<String> ds = new HashSet<String>();
            String name = null;
            String app = null;
            while (iter.hasNext()) {
                ObjectName objName = iter.next();
                name = objName.getKeyProperty("name");
                app = objName.getKeyProperty("J2EEApplication");
                ds.add(name + " (" + app + ")");
            }
            return ds;
        }
        catch (MalformedObjectNameException e) {
            throw new HandlingException(e, "Invalid pattern: oc4j:j2eeType=JDBCResource,*");
        }
    }

    private Set getJavaMail() throws HandlingException {
        try {
            MBeanServer mserv = Oc4jMBeanServerFactory.getMBeanServer();
            ObjectName mailObjectName = new ObjectName("oc4j:j2eeType=JavaMailResource,*");
            Set<ObjectName> res = mserv.queryNames(mailObjectName, null);
            Iterator<ObjectName> iter = res.iterator();
            HashSet<String> ms = new HashSet<String>();
            String name = null;
            String app = null;
            while (iter.hasNext()) {
                ObjectName objName = iter.next();
                name = objName.getKeyProperty("name");
                app = objName.getKeyProperty("J2EEApplication");
                ms.add(name + " (" + app + ")");
            }
            return ms;
        }
        catch (MalformedObjectNameException e) {
            throw new HandlingException(e, "Invalid pattern: oc4j:j2eeType=JavaMailResource,*");
        }
    }

    private void deploy(String appname, String parent, String bindTo, InputStream earStream) throws HandlingException {
        if (appname == null || appname.length() == 0) {
            throw new HandlingException("The application's name must be specified");
        }
        if (parent == null || parent.length() == 0) {
            throw new HandlingException("The parent application must be specified");
        }
        if ("none".equals(bindTo)) {
            bindTo = null;
        }
        try {
            this._administrator.deploy(earStream, appname, parent, bindTo);
        }
        catch (Throwable t) {
            if (logger_.isLoggable(Level.SEVERE)) {
                logger_.log(Level.SEVERE, t.getMessage(), t);
            }
            throw new HandlingException(t);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void deployModule(String appname, String parent, String type, InputStream stream) throws HandlingException {
        if (appname == null) throw new HandlingException("The application's name must be specified");
        if (appname.length() == 0) {
            throw new HandlingException("The application's name must be specified");
        }
        if (parent == null) throw new HandlingException("The parent application must be specified");
        if (parent.length() == 0) {
            throw new HandlingException("The parent application must be specified");
        }
        if (type == null) throw new HandlingException("The module type must be specified");
        if (type.length() == 0) {
            throw new HandlingException("The module type must be specified");
        }
        File earFile = null;
        File origFile = null;
        FileOutputStream fout = null;
        FileInputStream fin = null;
        String ext = ".jar";
        try {
            try {
                SharedModuleType modType = null;
                String rootCtx = null;
                if ("war".equals(type)) {
                    modType = SharedModuleType.WAR;
                    rootCtx = "/" + appname + "generated";
                    ext = ".war";
                } else if ("ejb".equals(type)) {
                    modType = SharedModuleType.EJB;
                } else {
                    if (!"appcl".equals(type)) throw new HandlingException("Invalid Module Type: " + type);
                    modType = SharedModuleType.CAR;
                }
                origFile = File.createTempFile(appname, ext);
                fout = new FileOutputStream(origFile);
                byte[] buf = new byte[4096];
                int read = 0;
                while ((read = stream.read(buf)) > 0) {
                    fout.write(buf, 0, read);
                }
                fout.close();
                fout = null;
                earFile = EarFileUtils.toEar((File)origFile, (SharedModuleType)modType, (String)appname, (String)rootCtx);
                fin = new FileInputStream(earFile);
                this._administrator.deploy(fin, appname, parent, null);
            }
            catch (HandlingException e) {
                e.fillInStackTrace();
                throw e;
            }
            catch (Throwable t) {
                if (!logger_.isLoggable(Level.SEVERE)) throw new HandlingException(t);
                logger_.log(Level.SEVERE, t.getMessage(), t);
                throw new HandlingException(t);
            }
            Object var15_16 = null;
        }
        catch (Throwable throwable) {
            Object var15_17 = null;
            try {
                if (fout != null) {
                    fout.close();
                }
                if (fin != null) {
                    fin.close();
                }
                origFile.delete();
                earFile.delete();
                throw throwable;
            }
            catch (IOException e) {
                if (!logger_.isLoggable(Level.SEVERE)) throw new HandlingException(e);
                logger_.log(Level.SEVERE, e.getMessage(), e);
                throw new HandlingException(e);
            }
        }
        try {}
        catch (IOException e) {
            if (!logger_.isLoggable(Level.SEVERE)) throw new HandlingException(e);
            logger_.log(Level.SEVERE, e.getMessage(), e);
            throw new HandlingException(e);
        }
        if (fout != null) {
            fout.close();
        }
        if (fin != null) {
            fin.close();
        }
        origFile.delete();
        earFile.delete();
    }

    private void deployrar(String appname, String nativeLibPath, String grantAllPerm, InputStream rarStream) throws HandlingException {
        if (appname == null || appname.length() == 0) {
            throw new HandlingException("The Resource Adapter deployment name must be specified");
        }
        try {
            boolean grantAllPermissions = "yes".equals(grantAllPerm);
            HashMap<String, String> extraParams = new HashMap<String, String>();
            if (nativeLibPath != null) {
                extraParams.put("nativeLibPath", nativeLibPath);
            }
            if (grantAllPermissions) {
                extraParams.put("grantAllPermissions", "true");
            }
            byte[] data = this.getRawData(rarStream);
            this._administrator.deployConnector(data, appname, extraParams);
        }
        catch (Throwable t) {
            if (logger_.isLoggable(Level.SEVERE)) {
                logger_.log(Level.SEVERE, t.getMessage(), t);
            }
            throw new HandlingException(t);
        }
    }

    private byte[] getRawData(InputStream in) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream(8192);
        byte[] buf = new byte[4096];
        int read = 0;
        while ((read = in.read(buf)) > 0) {
            bout.write(buf, 0, read);
        }
        return bout.toByteArray();
    }

    private void handleMultiPartRequest() throws HandlingException {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            String parent;
            String appname;
            String command;
            ServletInputStream in = this.req_.getInputStream();
            int reqSize = this.req_.getContentLength();
            String reqType = this.req_.getContentType().toLowerCase();
            String boundary = "--" + reqType.substring(reqType.indexOf("boundary=") + 9);
            FileExtractorStream uploadedFileStream = null;
            this.readLine(in);
            String line = null;
            while ((line = this.readLine(in)) != null) {
                String param = this.extractArgName(line);
                if (param.equals("command") || param.equals("appname") || param.equals("parent") || param.equals("bindto") || param.equals("perm") || param.equals("natlib")) {
                    this.readLine(in);
                    line = this.readLine(in);
                    map.put(param, line);
                    this.readLine(in);
                }
                if (!param.equals("file")) continue;
                while (this.readLine(in) != null) {
                }
                uploadedFileStream = new FileExtractorStream(in, boundary);
                break;
            }
            if ("DEPLOY".equals(command = (String)map.get("command"))) {
                appname = (String)map.get("appname");
                parent = (String)map.get("parent");
                String bindto = (String)map.get("bindto");
                this.deploy(appname, parent, bindto, uploadedFileStream);
            }
            if ("DEPLOYRAR".equals(command)) {
                appname = (String)map.get("appname");
                String grantAllPermissions = (String)map.get("perm");
                String nativeLibrartPath = (String)map.get("natlib");
                this.deployrar(appname, nativeLibrartPath, grantAllPermissions, uploadedFileStream);
            }
            if ("DEPLOYOTHER".equals(command)) {
                appname = (String)map.get("appname");
                parent = (String)map.get("parent");
                String type = (String)map.get("perm");
                this.deployModule(appname, parent, type, uploadedFileStream);
            }
        }
        catch (HandlingException e) {
            e.fillInStackTrace();
            throw e;
        }
        catch (Exception e) {
            if (logger_.isLoggable(Level.SEVERE)) {
                logger_.log(Level.SEVERE, e.getMessage(), e);
            }
            throw new HandlingException(e);
        }
    }

    private String readLine(ServletInputStream in) throws IOException {
        StringBuffer sbuf = new StringBuffer();
        byte[] buf = new byte[8192];
        int read = 0;
        while ((read = in.readLine(buf, 0, buf.length)) > 0) {
            sbuf.append(new String(buf, 0, read, "ISO-8859-1"));
            if (read == buf.length) continue;
        }
        if (sbuf.length() > 1 && sbuf.charAt(sbuf.length() - 2) == '\r' && sbuf.charAt(sbuf.length() - 1) == '\n') {
            sbuf.setLength(sbuf.length() - 2);
        }
        if (sbuf.length() == 0) {
            return null;
        }
        return sbuf.toString();
    }

    private String extractArgName(String line) {
        int beg = line.indexOf("name=");
        int end = line.indexOf("\"", beg + 6);
        return line.substring(beg + 6, end);
    }

    private String toUTF8(String ori) {
        if (ori == null) {
            return ori;
        }
        String res = ori;
        if (this.reqEncoding_ != null && !"UTF-8".equalsIgnoreCase(this.reqEncoding_)) {
            try {
                byte[] defaultBytes = ori.getBytes(this.reqEncoding_);
                res = new String(defaultBytes, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                return res;
            }
        }
        return res;
    }

    class InternalByteArrayOutputStream
    extends ByteArrayOutputStream {
        public InternalByteArrayOutputStream() {
        }

        public InternalByteArrayOutputStream(int size) {
            super(size);
        }

        public final byte[] getBuffer() {
            return this.buf;
        }

        public final int getCount() {
            return this.count;
        }
    }

    class FileExtractorStream
    extends InputStream {
        ServletInputStream in_ = null;
        private byte[] buf_ = null;
        private int index_ = -1;
        private int endIndex_ = -1;
        private byte[] forwardBuf_ = null;
        private int forwardCount_ = 0;
        String boundary_ = null;
        boolean endReached_ = false;

        FileExtractorStream(ServletInputStream in, String boundary) throws IOException {
            this.in_ = in;
            this.boundary_ = boundary;
            this.readForward();
            this.refill();
        }

        public int read() throws IOException {
            while (this.index_ == this.endIndex_) {
                this.refill();
                if (!this.endReached_) continue;
                return -1;
            }
            return (char)this.buf_[this.index_++];
        }

        private boolean readForward() throws IOException {
            String s;
            this.forwardBuf_ = new byte[8192];
            this.forwardCount_ = this.in_.readLine(this.forwardBuf_, 0, this.forwardBuf_.length);
            if (this.forwardBuf_[0] == 45 && (s = new String(this.forwardBuf_, 0, this.forwardCount_, "ISO-8859-1")).startsWith(this.boundary_)) {
                this.endReached_ = true;
            }
            return this.endReached_;
        }

        private void refill() throws IOException {
            if (this.endReached_) {
                return;
            }
            int read = this.forwardCount_;
            int total = 0;
            byte[] buf = this.forwardBuf_;
            this.index_ = 0;
            this.endIndex_ = 0;
            if (read < buf.length) {
                this.endIndex_ = read;
                this.buf_ = buf;
                if (this.readForward() && this.buf_[read - 2] == 13 && this.buf_[read - 1] == 10) {
                    this.endIndex_ -= 2;
                }
                return;
            }
            InternalByteArrayOutputStream bout = new InternalByteArrayOutputStream(16384);
            bout.write(buf, 0, buf.length);
            total = buf.length;
            while (read == buf.length) {
                read = this.in_.readLine(buf, 0, buf.length);
                if (read > 0) {
                    bout.write(buf, 0, read);
                    total += read;
                }
                if (read == buf.length) continue;
            }
            this.endIndex_ = total;
            this.buf_ = bout.getBuffer();
            if (this.readForward() && this.buf_[read - 2] == 13 && this.buf_[read - 1] == 10) {
                this.endIndex_ -= 2;
            }
        }
    }
}

