/*
 * Decompiled with CFR 0.152.
 */
package oracle.j2ee.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

class TraceLogFormatter
extends Formatter {
    TraceLogFormatter() {
    }

    public String format(LogRecord record) {
        StringBuffer sb = new StringBuffer();
        sb.append(record.getLevel().getLocalizedName()).append(": ");
        this.appendMethodName(sb, record);
        sb.append(this.formatMessage(record));
        if (record.getThrown() != null) {
            this.appendThrowableStackTrace(sb, record);
        }
        return sb.toString();
    }

    private void appendMethodName(StringBuffer sb, LogRecord record) {
        String fullClassName = record.getSourceClassName();
        int lastDotIndex = fullClassName.lastIndexOf(46);
        if (lastDotIndex < 0) {
            sb.append(fullClassName);
        } else {
            sb.append(fullClassName.substring(lastDotIndex + 1));
        }
        sb.append('.').append(record.getSourceMethodName()).append(' ');
    }

    private void appendThrowableStackTrace(StringBuffer sb, LogRecord record) {
        try {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            record.getThrown().printStackTrace(pw);
            pw.close();
            sb.append(sw.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

