/*
 * Decompiled with CFR 0.152.
 */
package oracle.j2ee.util;

import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import oracle.dms.instrument.ExecutionContext;
import sun.reflect.Reflection;

public class ExecutionContextLogger
extends Logger {
    public static String CONTEXT_LOGGER_LEVEL_ATTRIBUTE = "logger.level";
    private static int OFF_LEVEL_VALUE = Level.OFF.intValue();
    private static int ALL_LEVEL_VALUE = Level.ALL.intValue();
    private ResourceBundle catalog;
    private String catalogName;
    private Locale catalogLocale;

    public ExecutionContextLogger(String loggerName) {
        super(loggerName, null);
    }

    public ExecutionContextLogger(String loggerName, String resourceBundleName) {
        super(loggerName, resourceBundleName);
    }

    public static synchronized Logger getLogger(String name) {
        LogManager manager = LogManager.getLogManager();
        Logger logger = manager.getLogger(name);
        if (logger == null) {
            logger = new ExecutionContextLogger(name, null);
            manager.addLogger(logger);
            logger = manager.getLogger(name);
        }
        return logger;
    }

    public static synchronized Logger getLogger(String name, String resourceBundleName) {
        LogManager manager = LogManager.getLogManager();
        Logger logger = manager.getLogger(name);
        if (logger == null) {
            logger = new ExecutionContextLogger(name, resourceBundleName);
            manager.addLogger(logger);
            logger = manager.getLogger(name);
        }
        if (!logger.getResourceBundleName().equals(resourceBundleName)) {
            throw new IllegalArgumentException(logger.getResourceBundleName() + " != " + resourceBundleName);
        }
        return logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isFiltered(LogRecord record) {
        ExecutionContextLogger executionContextLogger = this;
        synchronized (executionContextLogger) {
            Filter filter = this.getFilter();
            if (filter != null) {
                return !filter.isLoggable(record);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setContextLevel(Level level) {
        Map map;
        ExecutionContext ec = ExecutionContext.get();
        if (ec != null && (map = ec.getAttributeMap()) != null) {
            Map map2 = map;
            synchronized (map2) {
                map.put(CONTEXT_LOGGER_LEVEL_ATTRIBUTE, level);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Level getContextLevel() {
        Map map;
        Level level = null;
        ExecutionContext ec = ExecutionContext.get();
        if (ec != null && (map = ec.getAttributeMap()) != null) {
            Map map2 = map;
            synchronized (map2) {
                level = (Level)map.get(CONTEXT_LOGGER_LEVEL_ATTRIBUTE);
            }
        }
        return level;
    }

    public Level getEffectiveLevel() {
        Level loggerLevel = this.getLevel();
        for (Logger loggerParent = this.getParent(); loggerLevel == null && loggerParent != null; loggerParent = loggerParent.getParent()) {
            loggerLevel = loggerParent.getLevel();
        }
        int loggerLevelValue = loggerLevel == null ? OFF_LEVEL_VALUE : loggerLevel.intValue();
        Level contextLevel = ExecutionContextLogger.getContextLevel();
        int contextLevelValue = contextLevel == null ? OFF_LEVEL_VALUE : contextLevel.intValue();
        return contextLevelValue <= loggerLevelValue ? contextLevel : loggerLevel;
    }

    protected static boolean isLoggable(Level recordLevel, Level loggerLevel) {
        int recordLevelValue = recordLevel == null ? ALL_LEVEL_VALUE : recordLevel.intValue();
        int loggerLevelValue = loggerLevel == null ? OFF_LEVEL_VALUE : loggerLevel.intValue();
        return loggerLevelValue != OFF_LEVEL_VALUE && recordLevelValue >= loggerLevelValue;
    }

    public boolean isLoggable(Level level) {
        return ExecutionContextLogger.isLoggable(level, this.getEffectiveLevel());
    }

    protected boolean isLoggable(LogRecord record) {
        return this.isLoggable(record.getLevel()) && !this.isFiltered(record);
    }

    protected void publish(Logger logger, LogRecord record) {
        Handler[] handlers = logger.getHandlers();
        if (handlers != null) {
            for (int i = 0; i < handlers.length; ++i) {
                handlers[i].publish(record);
            }
        }
    }

    public void log(LogRecord record) {
        if (this.isLoggable(record)) {
            for (Logger logger = this; logger != null; logger = logger.getParent()) {
                this.publish(logger, record);
                if (!logger.getUseParentHandlers()) break;
            }
        }
    }

    public void log(Level level, String msg) {
        if (this.isLoggable(level)) {
            LogRecord lr = new LogRecord(level, msg);
            this.doLog(lr);
        }
    }

    public void log(Level level, String msg, Object param1) {
        if (this.isLoggable(level)) {
            LogRecord lr = new LogRecord(level, msg);
            Object[] params = new Object[]{param1};
            lr.setParameters(params);
            this.doLog(lr);
        }
    }

    public void log(Level level, String msg, Object[] params) {
        if (this.isLoggable(level)) {
            LogRecord lr = new LogRecord(level, msg);
            lr.setParameters(params);
            this.doLog(lr);
        }
    }

    public void log(Level level, String msg, Throwable thrown) {
        if (this.isLoggable(level)) {
            LogRecord lr = new LogRecord(level, msg);
            lr.setThrown(thrown);
            this.doLog(lr);
        }
    }

    public void logp(Level level, String sourceClass, String sourceMethod, String msg) {
        if (this.isLoggable(level)) {
            LogRecord lr = new LogRecord(level, msg);
            lr.setSourceClassName(sourceClass);
            lr.setSourceMethodName(sourceMethod);
            this.doLog(lr);
        }
    }

    public void logp(Level level, String sourceClass, String sourceMethod, String msg, Object param1) {
        if (this.isLoggable(level)) {
            LogRecord lr = new LogRecord(level, msg);
            lr.setSourceClassName(sourceClass);
            lr.setSourceMethodName(sourceMethod);
            Object[] params = new Object[]{param1};
            lr.setParameters(params);
            this.doLog(lr);
        }
    }

    public void logp(Level level, String sourceClass, String sourceMethod, String msg, Object[] params) {
        if (this.isLoggable(level)) {
            LogRecord lr = new LogRecord(level, msg);
            lr.setSourceClassName(sourceClass);
            lr.setSourceMethodName(sourceMethod);
            lr.setParameters(params);
            this.doLog(lr);
        }
    }

    public void logp(Level level, String sourceClass, String sourceMethod, String msg, Throwable thrown) {
        if (this.isLoggable(level)) {
            LogRecord lr = new LogRecord(level, msg);
            lr.setSourceClassName(sourceClass);
            lr.setSourceMethodName(sourceMethod);
            lr.setThrown(thrown);
            this.doLog(lr);
        }
    }

    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg) {
        if (this.isLoggable(level)) {
            LogRecord lr = new LogRecord(level, msg);
            lr.setSourceClassName(sourceClass);
            lr.setSourceMethodName(sourceMethod);
            this.doLog(lr, bundleName);
        }
    }

    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg, Object param1) {
        if (this.isLoggable(level)) {
            LogRecord lr = new LogRecord(level, msg);
            lr.setSourceClassName(sourceClass);
            lr.setSourceMethodName(sourceMethod);
            Object[] params = new Object[]{param1};
            lr.setParameters(params);
            this.doLog(lr, bundleName);
        }
    }

    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg, Object[] params) {
        if (this.isLoggable(level)) {
            LogRecord lr = new LogRecord(level, msg);
            lr.setSourceClassName(sourceClass);
            lr.setSourceMethodName(sourceMethod);
            lr.setParameters(params);
            this.doLog(lr, bundleName);
        }
    }

    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg, Throwable thrown) {
        if (this.isLoggable(level)) {
            LogRecord lr = new LogRecord(level, msg);
            lr.setSourceClassName(sourceClass);
            lr.setSourceMethodName(sourceMethod);
            lr.setThrown(thrown);
            this.doLog(lr, bundleName);
        }
    }

    public void entering(String sourceClass, String sourceMethod) {
        this.logp(Level.FINER, sourceClass, sourceMethod, "ENTRY");
    }

    public void entering(String sourceClass, String sourceMethod, Object param1) {
        if (this.isLoggable(Level.FINER)) {
            Object[] params = new Object[]{param1};
            this.logp(Level.FINER, sourceClass, sourceMethod, "ENTRY {0}", params);
        }
    }

    public void entering(String sourceClass, String sourceMethod, Object[] params) {
        if (this.isLoggable(Level.FINE)) {
            String msg = "ENTRY";
            for (int i = 0; i < params.length; ++i) {
                msg = msg + " {" + i + "}";
            }
            this.logp(Level.FINER, sourceClass, sourceMethod, msg, params);
        }
    }

    public void exiting(String sourceClass, String sourceMethod) {
        this.logp(Level.FINER, sourceClass, sourceMethod, "RETURN");
    }

    public void exiting(String sourceClass, String sourceMethod, Object result) {
        this.logp(Level.FINER, sourceClass, sourceMethod, "RETURN {0}", result);
    }

    public void throwing(String sourceClass, String sourceMethod, Throwable thrown) {
        if (this.isLoggable(Level.FINER)) {
            LogRecord lr = new LogRecord(Level.FINER, "THROW");
            lr.setSourceClassName(sourceClass);
            lr.setSourceMethodName(sourceMethod);
            lr.setThrown(thrown);
            this.doLog(lr);
        }
    }

    public void severe(String msg) {
        this.log(Level.SEVERE, msg);
    }

    public void warning(String msg) {
        this.log(Level.WARNING, msg);
    }

    public void info(String msg) {
        this.log(Level.INFO, msg);
    }

    public void config(String msg) {
        this.log(Level.CONFIG, msg);
    }

    public void fine(String msg) {
        this.log(Level.FINE, msg);
    }

    public void finer(String msg) {
        this.log(Level.FINER, msg);
    }

    public void finest(String msg) {
        this.log(Level.FINEST, msg);
    }

    private synchronized ResourceBundle findResourceBundle(String name) {
        if (name == null) {
            return null;
        }
        Locale currentLocale = Locale.getDefault();
        if (this.catalog != null && currentLocale == this.catalogLocale && name == this.catalogName) {
            return this.catalog;
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        try {
            this.catalog = ResourceBundle.getBundle(name, currentLocale, cl);
            this.catalogName = name;
            this.catalogLocale = currentLocale;
            return this.catalog;
        }
        catch (MissingResourceException ex) {
            Class clz;
            int ix = 0;
            while ((clz = Reflection.getCallerClass((int)ix)) != null) {
                ClassLoader cl2 = clz.getClassLoader();
                if (cl2 == null) {
                    cl2 = ClassLoader.getSystemClassLoader();
                }
                if (cl != cl2) {
                    cl = cl2;
                    try {
                        this.catalog = ResourceBundle.getBundle(name, currentLocale, cl);
                        this.catalogName = name;
                        this.catalogLocale = currentLocale;
                        return this.catalog;
                    }
                    catch (MissingResourceException ex2) {
                        // empty catch block
                    }
                }
                ++ix;
            }
            if (name.equals(this.catalogName)) {
                return this.catalog;
            }
            return null;
        }
    }

    private void doLog(LogRecord lr, String rbname) {
        lr.setLoggerName(this.getName());
        if (rbname != null) {
            lr.setResourceBundleName(rbname);
            lr.setResourceBundle(this.findResourceBundle(rbname));
        }
        this.log(lr);
    }

    private void doLog(LogRecord lr) {
        this.doLog(lr, this.getEffectiveResourceBundleName());
    }

    private String getEffectiveResourceBundleName() {
        for (Logger target = this; target != null; target = target.getParent()) {
            String rbn = target.getResourceBundleName();
            if (rbn == null) continue;
            return rbn;
        }
        return null;
    }
}

