/*
 * Decompiled with CFR 0.152.
 */
package oracle.j2ee.transaction;

import java.io.Serializable;
import oracle.j2ee.transaction.ThresholdEventDetail;

public class TransactionManagerConfigurationDetail
implements Serializable {
    private String m_coordinatorType;
    private String m_logType;
    private String m_logLocation;
    private String m_userName;
    private String m_password;
    private int m_minPoolSize;
    private int m_maxOpenFiles;
    private int m_oldFileReleaseSize;
    private int m_batchCreateInterval;
    private int m_batchStateInterval;
    private int m_batchPurgeInterval;
    private int m_txTimeout;
    private int m_maxTx;
    private int m_retryCount;
    private ThresholdEventDetail[] m_thresholdEventDetail;

    public TransactionManagerConfigurationDetail(String coordinatorType, String logType, String logLocation, String userName, String password, int retryCount, int txTimeout, int maxTx, ThresholdEventDetail[] thresholdDetail, int minPoolSize, int maxOpenFiles, int oldFileReleaseSize, int batchCreateInterval, int batchStateInterval, int batchPurgeInterval) {
        this.m_coordinatorType = coordinatorType;
        this.m_logType = logType;
        this.m_logLocation = logLocation;
        this.m_userName = userName;
        this.m_password = password;
        this.m_retryCount = retryCount;
        this.m_txTimeout = txTimeout;
        this.m_maxTx = maxTx;
        this.m_thresholdEventDetail = thresholdDetail;
        this.m_minPoolSize = minPoolSize;
        this.m_maxOpenFiles = maxOpenFiles;
        this.m_oldFileReleaseSize = oldFileReleaseSize;
        this.m_batchCreateInterval = batchCreateInterval;
        this.m_batchStateInterval = batchStateInterval;
        this.m_batchPurgeInterval = batchPurgeInterval;
    }

    public String getCoordinatorType() {
        return this.m_coordinatorType;
    }

    public String getLogType() {
        return this.m_logType;
    }

    public String getLogLocation() {
        return this.m_logLocation;
    }

    public String getUserName() {
        return this.m_userName;
    }

    public String getPassword() {
        return this.m_password;
    }

    public int getBatchPurgeInterval() {
        return this.m_batchPurgeInterval;
    }

    public int getMinPoolSize() {
        return this.m_minPoolSize;
    }

    public int getMaxOpenFiles() {
        return this.m_maxOpenFiles;
    }

    public int getOldFileReleaseSize() {
        return this.m_oldFileReleaseSize;
    }

    public int getBatchCreateInterval() {
        return this.m_batchCreateInterval;
    }

    public int getBatchStateInterval() {
        return this.m_batchStateInterval;
    }

    public int getTransactionTimeout() {
        return this.m_txTimeout;
    }

    public int getRetryCount() {
        return this.m_retryCount;
    }

    public int getMaxConcurrentTransactions() {
        return this.m_maxTx;
    }

    public ThresholdEventDetail[] getThresholdEvents() {
        return this.m_thresholdEventDetail;
    }

    public String toString() {
        StringBuffer res = new StringBuffer();
        res.append("transaction-timeout: ");
        res.append(this.m_txTimeout);
        res.append('\n');
        res.append("max-concurrent-transactions: ");
        res.append(this.m_maxTx == -1 ? "unlimited" : "" + this.m_maxTx);
        res.append('\n');
        res.append("commit-coordinator: ");
        res.append(this.m_coordinatorType);
        res.append('\n');
        res.append("retry-count: ");
        res.append(this.m_retryCount);
        res.append('\n');
        res.append("log type: ");
        res.append(this.m_logType);
        res.append('\n');
        res.append("log location: ");
        res.append(this.m_logLocation);
        res.append('\n');
        res.append("user: ");
        res.append(this.m_userName);
        res.append('\n');
        res.append("password: ");
        res.append(this.m_password);
        res.append("file-logging-performance: ");
        res.append("min-pool-size: ");
        res.append(this.m_minPoolSize);
        res.append("max-open-files: ");
        res.append(this.m_maxOpenFiles);
        res.append("old-file-release-size: ");
        res.append(this.m_oldFileReleaseSize);
        res.append("database-logging-performance: ");
        res.append("batch-create-interval: ");
        res.append(this.m_batchCreateInterval);
        res.append("batch-state-interval: ");
        res.append(this.m_batchStateInterval);
        res.append("batch-purge-interval: ");
        res.append(this.m_batchPurgeInterval);
        res.append('\n');
        res.append("threshold events: ");
        for (int i = 0; i < this.m_thresholdEventDetail.length; ++i) {
            res.append("threshold event detail [" + i + "]: " + this.m_thresholdEventDetail[i]);
            res.append('\n');
        }
        return res.toString();
    }
}

