/*
 * Decompiled with CFR 0.152.
 */
package oracle.j2ee.connector.work;

import com.evermind.server.ThreadState;
import com.evermind.server.connector.ApplicationConnectionManager;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.spi.XATerminator;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import oracle.as.j2ee.transaction.SubordinateTransactionManager;
import oracle.j2ee.connector.logging.JCATraceLogger;
import oracle.j2ee.connector.work.ExecutionContextManager;

public class XATerminatorImpl
implements XATerminator {
    private static Logger m_logger = JCATraceLogger.getLogger(ApplicationConnectionManager.class);
    private SubordinateTransactionManager m_tm;

    public XATerminatorImpl(SubordinateTransactionManager tm) {
        if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.finest("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "XATerminatorImpl:constructor tm = " + tm);
        }
        this.m_tm = tm;
    }

    public int prepare(Xid xid) throws XAException {
        if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.finest("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "XATerminatorImpl:prepare xid = " + xid);
        }
        this.throwExceptionIfXidActive(xid);
        this.makeBeforeCompletionNotifications(xid);
        return this.m_tm.prepare(xid);
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.finest("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "XATerminatorImpl:commit xid = " + xid + " onePhase = " + onePhase);
        }
        this.throwExceptionIfXidActive(xid);
        if (onePhase) {
            this.makeBeforeCompletionNotifications(xid);
        }
        this.m_tm.commit(xid, onePhase);
    }

    public void rollback(Xid xid) throws XAException {
        if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.finest("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "XATerminatorImpl:rollback xid = " + xid);
        }
        this.throwExceptionIfXidActive(xid);
        this.m_tm.rollback(xid);
    }

    public void forget(Xid xid) throws XAException {
        if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.finest("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "XATerminatorImpl:forget xid = " + xid);
        }
        this.m_tm.forget(xid);
    }

    public Xid[] recover(int flag) throws XAException {
        if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.finest("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "XATerminatorImpl:recover flaf = " + flag);
        }
        return this.m_tm.recover(flag);
    }

    private void throwExceptionIfXidActive(Xid xid) throws XAException {
        if (ExecutionContextManager.getInstance().isWorkTransactionActive(xid)) {
            XAException ex = new XAException("XATerminator called for an active Xid: " + xid);
            ex.errorCode = -6;
            throw ex;
        }
    }

    private void makeBeforeCompletionNotifications(Xid xid) throws XAException {
        this.setupTransaction(xid);
        this.m_tm.beforeCompletion();
        this.m_tm.end(xid, 0x4000000);
        this.tearDownTransaction();
    }

    private void setupTransaction(Xid normalizedXid) throws XAException {
        try {
            if (!this.m_tm.infectThread(normalizedXid, 0, null, false)) {
                this.throwNota();
            }
        }
        catch (NotSupportedException e) {
            XAException xae = new XAException("Unable to create transaction association. " + (Object)((Object)e));
            xae.errorCode = -3;
            xae.initCause(e);
            throw xae;
        }
        catch (SystemException e) {
            XAException xae = new XAException("Unable to create transaction association. " + (Object)((Object)e));
            xae.errorCode = -3;
            xae.initCause(e);
            throw xae;
        }
        catch (RollbackException e) {
            XAException xae = new XAException("Unable to create transaction association. " + (Object)((Object)e));
            xae.errorCode = -3;
            xae.initCause(e);
            throw xae;
        }
        catch (InvalidTransactionException e) {
            XAException xae = new XAException("Unable to create transaction association. " + (Object)((Object)e));
            xae.errorCode = -5;
            xae.initCause(e);
            throw xae;
        }
    }

    private void throwNota() throws XAException {
        XAException xae = new XAException("Unknown transaction branch");
        xae.errorCode = -4;
        throw xae;
    }

    private void tearDownTransaction() throws XAException {
        try {
            this.m_tm.endInfection();
        }
        catch (SystemException e) {
            XAException xae = new XAException("Unable to tear down current transaction association. " + (Object)((Object)e));
            xae.errorCode = -3;
            xae.initCause(e);
            throw xae;
        }
    }
}

