/*
 * Decompiled with CFR 0.152.
 */
package oracle.j2ee.connector.work;

import com.evermind.server.ThreadState;
import com.evermind.server.connector.ApplicationConnectionManager;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.spi.work.WorkEvent;
import javax.resource.spi.work.WorkListener;
import oracle.j2ee.connector.logging.JCATraceLogger;
import oracle.j2ee.connector.work.WorkWrapper;

class WorkListenerWrapper
implements WorkListener {
    private static Logger m_logger = JCATraceLogger.getLogger(ApplicationConnectionManager.class);
    WorkListener m_listener;
    boolean m_isAccepted = false;

    WorkListenerWrapper(WorkListener listener) {
        this.m_listener = listener;
    }

    public synchronized void workAccepted(WorkEvent event) {
        WorkWrapper work;
        if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.finest("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "WorkListenerWrapper:workAccepted event = " + event);
        }
        if ((work = (WorkWrapper)event.getWork()).getExContext() != null) {
            work.getExContext().setActive(true);
        }
        this.m_isAccepted = true;
        this.m_listener.workAccepted(new WorkEvent(event.getSource(), event.getType(), work.getTarget(), event.getException(), event.getStartDuration()));
    }

    public void workRejected(WorkEvent event) {
        if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.finest("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "WorkListenerWrapper:workRejected event = " + event);
        }
        this.removeId(event);
        this.m_listener.workRejected(new WorkEvent(event.getSource(), event.getType(), ((WorkWrapper)event.getWork()).getTarget(), event.getException(), event.getStartDuration()));
    }

    public void workStarted(WorkEvent event) {
        if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.finest("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "WorkListenerWrapper:workStarted event = " + event);
        }
        this.m_listener.workStarted(new WorkEvent(event.getSource(), event.getType(), ((WorkWrapper)event.getWork()).getTarget(), event.getException(), event.getStartDuration()));
    }

    public void workCompleted(WorkEvent event) {
        if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.finest("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "WorkListenerWrapper:workCompleted event = " + event);
        }
        this.removeId(event);
        this.m_listener.workCompleted(new WorkEvent(event.getSource(), event.getType(), ((WorkWrapper)event.getWork()).getTarget(), event.getException(), event.getStartDuration()));
    }

    private synchronized void removeId(WorkEvent event) {
        WorkWrapper work = (WorkWrapper)event.getWork();
        if (this.m_isAccepted && work.getExContext() != null) {
            work.getExContext().setActive(false);
        }
    }
}

