/*
 * Decompiled with CFR 0.152.
 */
package oracle.j2ee.connector.transaction;

import com.evermind.server.SinglePhaseResource;
import javax.resource.ResourceException;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class EmulatedXAResource
implements XAResource,
SinglePhaseResource {
    private ManagedConnection m_managedConnection;
    private LocalTransaction m_localTxn;
    private final String NULL_XID = "LRCO: Xid cannot be NULL!";
    private final String COMMIT_FAIL = "LRCO: 1PC commit failed!";
    private final String ROLLBACK_FAIL = "LRCO: 1PC rollback failed!";
    private final String START_FAIL = "LRCO: start failed!";
    private final String CANT_FORGET = "LRCO: Nothing to forget!";
    private final String NULL_MC = "LRCO: Managed Connection cannot be NULL!";
    private final String NO_LT_IN_PROGRESS = "LRCO: No Local Txn in progress!";

    public EmulatedXAResource(ManagedConnection mc) {
        this.reset();
        if (mc == null) {
            throw new IllegalArgumentException("LRCO: ManagedConnection cannot be null!");
        }
        this.m_managedConnection = mc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(Xid xid, boolean onePhase) throws XAException {
        if (xid == null) {
            this.ThrowXAExc("LRCO: Xid cannot be NULL!", -4);
        }
        if (onePhase) {
            if (!this.activeLT()) {
                this.ThrowXAExc("LRCO: No Local Txn in progress!", -3);
            }
            try {
                this.m_localTxn.commit();
            }
            catch (ResourceException re) {
                this.ThrowXAExc(re, "LRCO: 1PC commit failed!", -3);
            }
            finally {
                this.reset();
            }
        }
    }

    public void end(Xid xid, int flags) throws XAException {
        if (xid == null) {
            this.ThrowXAExc("LRCO: Xid cannot be NULL!", -4);
        }
    }

    public void forget(Xid xid) throws XAException {
        this.ThrowXAExc("LRCO: Nothing to forget!", -6);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int prepare(Xid xid) throws XAException {
        if (xid == null) {
            this.ThrowXAExc("LRCO: Xid cannot be NULL!", -4);
        }
        if (!this.activeLT()) {
            this.ThrowXAExc("LRCO: No Local Txn in progress!", -3);
        }
        try {
            this.m_localTxn.commit();
        }
        catch (ResourceException re) {
            this.ThrowXAExc(re, "LRCO: 1PC commit failed!", -3);
        }
        finally {
            this.reset();
        }
        return 0;
    }

    public Xid[] recover(int flag) throws XAException {
        return new Xid[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(Xid xid) throws XAException {
        if (xid == null) {
            this.ThrowXAExc("LRCO: Xid cannot be NULL!", -4);
        }
        if (!this.activeLT()) {
            this.ThrowXAExc("LRCO: No Local Txn in progress!", -3);
        }
        try {
            this.m_localTxn.rollback();
        }
        catch (ResourceException re) {
            this.ThrowXAExc(re, "LRCO: 1PC rollback failed!", -3);
        }
        finally {
            this.reset();
        }
    }

    public void start(Xid xid, int flags) throws XAException {
        if (xid == null) {
            this.ThrowXAExc("LRCO: Xid cannot be NULL!", -4);
        }
        try {
            if (flags == 0) {
                this.beginLT();
            }
        }
        catch (ResourceException re) {
            this.ThrowXAExc(re, "LRCO: start failed!", -3);
        }
    }

    public boolean setTransactionTimeout(int to) throws XAException {
        return false;
    }

    public int getTransactionTimeout() throws XAException {
        return 0;
    }

    public boolean isSameRM(XAResource xaRes) throws XAException {
        if (!(xaRes instanceof EmulatedXAResource)) {
            return false;
        }
        return this.getMC().equals(((EmulatedXAResource)xaRes).getMC());
    }

    private void ThrowXAExc(String logMsg, int errCode) throws XAException {
        this.ThrowXAExc(null, logMsg, errCode, false);
    }

    private void ThrowXAExc(ResourceException resourceException, String logMsg, int errCode) throws XAException {
        this.ThrowXAExc(resourceException, logMsg, errCode, true);
    }

    private void ThrowXAExc(ResourceException resourceException, String logMsg, int errCode, boolean isInitCause) throws XAException {
        XAException xaException = new XAException(logMsg);
        xaException.errorCode = errCode;
        if (isInitCause) {
            xaException.initCause(resourceException);
            if (resourceException != null) {
                resourceException.printStackTrace();
            }
            if (xaException != null) {
                xaException.printStackTrace();
            }
        }
        throw xaException;
    }

    ManagedConnection getMC() throws XAException {
        if (this.m_managedConnection == null) {
            this.ThrowXAExc("LRCO: Managed Connection cannot be NULL!", -3);
        }
        return this.m_managedConnection;
    }

    synchronized void beginLT() throws ResourceException {
        try {
            if (this.m_localTxn == null) {
                ManagedConnection mc = this.getMC();
                this.m_localTxn = mc.getLocalTransaction();
            }
        }
        catch (XAException xe) {
            ResourceException resourceException = new ResourceException();
            resourceException.initCause((Throwable)xe);
            throw resourceException;
        }
        this.m_localTxn.begin();
    }

    synchronized boolean activeLT() {
        return this.m_localTxn != null;
    }

    public void reset() {
        this.m_localTxn = null;
    }
}

