/*
 * Decompiled with CFR 0.152.
 */
package oracle.j2ee.connector.proxy;

import java.net.MalformedURLException;
import java.net.URL;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Principal;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.HashMap;
import oracle.classloader.ProtectionPolicy;

public class BCELProxyClassLoader
extends ClassLoader {
    private HashMap m_definedClasses = new HashMap();
    private ProtectionDomain protection;

    public BCELProxyClassLoader(ClassLoader loader) {
        super(loader);
        this.initProtection();
    }

    private void initProtection() {
        CodeSource codeSource;
        try {
            URL url = new URL("file://generated/by/oracle.j2ee.connector.proxy.BCELProxyClassLoader");
            codeSource = new CodeSource(url, (Certificate[])null);
        }
        catch (MalformedURLException ex) {
            codeSource = null;
        }
        Principal[] principals = ProtectionPolicy.MAIN_PERMISSIONS.getPrincipals();
        PermissionCollection permissions = ProtectionPolicy.MAIN_PERMISSIONS.getPermissions();
        this.protection = new ProtectionDomain(codeSource, permissions, this, principals);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class loadClass(String name) throws ClassNotFoundException {
        Class aClass = null;
        BCELProxyClassLoader bCELProxyClassLoader = this;
        synchronized (bCELProxyClassLoader) {
            aClass = (Class)this.m_definedClasses.get(name);
        }
        if (aClass != null) {
            return aClass;
        }
        return super.loadClass(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Class defineClass(String name, byte[] bytes) {
        Class<?> aClass = this.defineClass(name, bytes, 0, bytes.length, this.protection);
        BCELProxyClassLoader bCELProxyClassLoader = this;
        synchronized (bCELProxyClassLoader) {
            this.m_definedClasses.put(name, aClass);
        }
        return aClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClassDefined(String name) {
        BCELProxyClassLoader bCELProxyClassLoader = this;
        synchronized (bCELProxyClassLoader) {
            return this.m_definedClasses.containsKey(name);
        }
    }
}

