/*
 * Decompiled with CFR 0.152.
 */
package oracle.j2ee.connector;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import oracle.j2ee.connector.ConnectorProxy;
import oracle.j2ee.connector.ConnectorProxyConstructionData;
import oracle.j2ee.connector.proxy.AbstractProxy;
import oracle.j2ee.connector.proxy.BCELProxyBuilder;
import org.apache.bcel.generic.ALOAD;
import org.apache.bcel.generic.CompoundInstruction;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.INVOKESPECIAL;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionFactory;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.PUSH;
import org.apache.bcel.generic.Type;

public class ConnectorProxyBuilder
implements BCELProxyBuilder {
    private static final Class[] CONNECTORPROXY_CONSTRUCTOR_PARAMETER_TYPES = new Class[]{Object.class, ConnectorProxyConstructionData.class};
    private static final ObjectType ABSTRACTPROXY_TYPE = new ObjectType(AbstractProxy.class.getName());
    private static final String OC4J_GETPROXYIFREQUIRED_METHOD_NAME = "oc4j_getProxyForReturnedObjectIfRequired";
    private static final String OC4J_GETPROXY_METHOD_NAME = "oc4j_getProxyForReturnedObject";
    private static final String OC4J_INTERCEPT_METHOD_NAME = "oc4j_intercept";
    protected Object m_target;
    private ConnectorProxyConstructionData m_data;
    private AbstractProxy m_parent;
    protected String m_requiredTypeClassName;

    public ConnectorProxyBuilder(Object target, AbstractProxy parent, ConnectorProxyConstructionData data, String requiredTypeClassName) {
        this.m_target = target;
        this.m_data = data;
        this.m_parent = parent;
        this.m_requiredTypeClassName = requiredTypeClassName;
    }

    public MethodGen buildConstructor(String name, Class superClass, ConstantPoolGen constantPool, InstructionFactory factory) {
        InstructionList il = new InstructionList();
        il.append((Instruction)InstructionConstants.THIS);
        il.append((Instruction)new ALOAD(1));
        il.append((Instruction)new ALOAD(2));
        il.append((Instruction)new INVOKESPECIAL(constantPool.addMethodref(superClass.getName(), "<init>", "(" + Type.getType((Class)Object.class).getSignature() + Type.getType((Class)ConnectorProxyConstructionData.class).getSignature() + ")V")));
        il.append((Instruction)InstructionConstants.RETURN);
        MethodGen mg = new MethodGen(1, (Type)Type.VOID, new Type[]{Type.OBJECT, Type.getType((Class)ConnectorProxyConstructionData.class)}, null, "<init>", name, il, constantPool);
        return mg;
    }

    public MethodGen buildMethod(String name, Class intf, Method method, ConstantPoolGen constantPool, InstructionFactory instructionFactory, boolean proxyResults, Method preInvokeMethod) {
        InstructionList instructionList = new InstructionList();
        String signature = Type.getSignature((Method)method);
        Type returnType = Type.getReturnType((String)signature);
        Type[] argumentTypes = Type.getArgumentTypes((String)signature);
        ArgumentList argumentList = new ArgumentList(argumentTypes);
        MethodGen methodGen = new MethodGen(1, returnType, argumentTypes, null, method.getName(), name, instructionList, constantPool);
        this.addInterceptInvocation(instructionList, instructionFactory);
        if (proxyResults) {
            this.addTargetInvocationWithProxiedResults(instructionList, instructionFactory, constantPool, intf, method, argumentList, signature);
        } else {
            this.addTargetInvocation(instructionList, instructionFactory, intf, method, argumentList, signature);
        }
        instructionList.append((Instruction)InstructionFactory.createReturn((Type)returnType));
        return methodGen;
    }

    public AbstractProxy instantiate(Class cl) throws InstantiationException {
        try {
            Constructor constructor = cl.getConstructor(CONNECTORPROXY_CONSTRUCTOR_PARAMETER_TYPES);
            return (AbstractProxy)constructor.newInstance(null, null);
        }
        catch (Exception e) {
            throw new InstantiationException(e.toString());
        }
    }

    public Object getTarget() {
        return this.m_target;
    }

    private InstructionHandle addInterceptInvocation(InstructionList il, InstructionFactory instructionFactory) {
        InstructionHandle tryStartInstruction = il.append((Instruction)InstructionConstants.THIS);
        il.append((Instruction)instructionFactory.createInvoke(ConnectorProxy.class.getName(), OC4J_INTERCEPT_METHOD_NAME, (Type)Type.VOID, Type.NO_ARGS, (short)182));
        return tryStartInstruction;
    }

    private void addTargetInvocation(InstructionList il, InstructionFactory instructionFactory, Class intf, Method method, ArgumentList argumentList, String signature) {
        int numberOfArguments = argumentList.getNumberOfArguments();
        il.append((Instruction)InstructionConstants.THIS);
        il.append((Instruction)instructionFactory.createGetField(AbstractProxy.class.getName(), "m_target", (Type)Type.OBJECT));
        for (int i = 0; i < numberOfArguments; ++i) {
            il.append((Instruction)InstructionFactory.createLoad((Type)argumentList.getArgumentType(i), (int)argumentList.getArgumentIndex(i)));
        }
        il.append((Instruction)instructionFactory.createInvoke(intf.getName(), method.getName(), Type.getReturnType((String)signature), Type.getArgumentTypes((String)signature), (short)185));
    }

    private void addTargetInvocationWithProxiedResults(InstructionList il, InstructionFactory instructionFactory, ConstantPoolGen constantPool, Class intf, Method method, ArgumentList argumentList, String signature) {
        Class<?> methodReturnType = method.getReturnType();
        boolean returnTypeObject = methodReturnType == Object.class;
        il.append((Instruction)InstructionConstants.THIS);
        this.addTargetInvocation(il, instructionFactory, intf, method, argumentList, signature);
        il.append((CompoundInstruction)new PUSH(constantPool, methodReturnType.getName()));
        il.append((Instruction)instructionFactory.createInvoke(AbstractProxy.class.getName(), returnTypeObject ? OC4J_GETPROXYIFREQUIRED_METHOD_NAME : OC4J_GETPROXY_METHOD_NAME, (Type)(returnTypeObject ? Type.OBJECT : ABSTRACTPROXY_TYPE), new Type[]{Type.OBJECT, Type.STRING}, (short)182));
    }

    public AbstractProxy getParent() {
        return this.m_parent;
    }

    public ConnectorProxyConstructionData getData() {
        return this.m_data;
    }

    public String getRequiredTypeClassName() {
        return this.m_requiredTypeClassName;
    }

    public AbstractProxy cloneProxy(AbstractProxy proxy) {
        ConnectorProxy clonedProxy = null;
        clonedProxy = (ConnectorProxy)proxy.clone();
        clonedProxy.oc4j_setTarget(this.getTarget());
        clonedProxy.oc4j_setParent(this.getParent());
        clonedProxy.oc4j_setData(this.getData());
        return clonedProxy;
    }

    class ArgumentList {
        private Type[] m_argumentTypes;
        private int[] m_argumentIndexes;

        public ArgumentList(Type[] argumentTypes) {
            this.m_argumentTypes = argumentTypes;
            this.m_argumentIndexes = new int[this.m_argumentTypes.length];
            int nextIndex = 1;
            for (int i = 0; i < argumentTypes.length; ++i) {
                this.m_argumentIndexes[i] = nextIndex;
                nextIndex += argumentTypes[i].getSize();
            }
        }

        public Type getArgumentType(int argNumber) {
            return this.m_argumentTypes[argNumber];
        }

        public int getNumberOfArguments() {
            return this.m_argumentTypes.length;
        }

        public int getArgumentIndex(int argNumber) {
            return this.m_argumentIndexes[argNumber];
        }
    }
}

