/*
 * Decompiled with CFR 0.152.
 */
package oracle.j2ee.clustering;

import com.oracle.bricks.j2ee.JGroupConfig;
import com.oracle.jgroups.ChannelAdapter;
import com.oracle.jgroups.ObjectMarshaller;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.j2ee.clustering.ChannelAdapterFactory;
import oracle.j2ee.util.TraceLogger;
import org.jgroups.Channel;
import org.jgroups.ChannelException;
import org.jgroups.JChannel;

public class JndiChannelAdapterFactory
implements ChannelAdapterFactory {
    private static Logger m_logger = TraceLogger.getLogger(JndiChannelAdapterFactory.class);
    private Map m_mapOfGroupNamesToAdapters = new HashMap();

    public ChannelAdapter getChannelAdapter(String groupName) {
        return (ChannelAdapter)this.m_mapOfGroupNamesToAdapters.get(groupName);
    }

    public void addChannelAdapter(String groupName, JGroupConfig jGroupConfig) {
        String jndiGroupName = groupName + "-jndi";
        ChannelAdapter channelAdapter = null;
        if (this.m_mapOfGroupNamesToAdapters.get(groupName) == null) {
            try {
                JChannel channel = new JChannel((String)jGroupConfig.getJGroupsProps());
                channelAdapter = new ChannelAdapter((Channel)channel, new ObjectMarshaller(), null, null);
                channelAdapter.start(jndiGroupName, false, 0);
                this.m_mapOfGroupNamesToAdapters.put(groupName, channelAdapter);
            }
            catch (ChannelException channelException) {
                m_logger.log(Level.FINE, channelException.getMessage(), channelException);
            }
        }
    }

    public void removeChannelAdapter(String groupName) {
        this.m_mapOfGroupNamesToAdapters.remove(groupName);
    }
}

