/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.container.timer.internal;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import oracle.ias.container.logging.ContainerServiceTraceLogger;
import oracle.ias.container.timer.Timer;
import oracle.ias.container.timer.TimerEntry;
import oracle.ias.container.timer.TimerEvent;
import oracle.ias.container.timer.TimerService;
import oracle.ias.container.timer.internal.FileTimerStore;
import oracle.ias.container.timer.internal.TimerStoreInterface;

public class TimerFactory {
    TimerConfig _currentConfig = new TimerConfig();
    Object _currentConfigLock = null;
    TimerStoreInterface _timerStore;
    private static Logger m_logger = ContainerServiceTraceLogger.getTraceLogger(TimerFactory.class);
    private boolean entryIsChanged;
    public static final int k_smallest_interval = 1000;
    long _futureScheduleInterval;
    TimerService service;

    public TimerFactory() {
        TimerService.instance();
        this._timerStore = new FileTimerStore(TimerService.getContainerID());
        this.entryIsChanged = false;
        this._futureScheduleInterval = 300000L;
        this.service = TimerService.instance();
        this.initialize(new LinkedList(), new Object());
    }

    public TimerFactory(Collection entries) {
        TimerService.instance();
        this._timerStore = new FileTimerStore(TimerService.getContainerID());
        this.entryIsChanged = false;
        this._futureScheduleInterval = 300000L;
        this.service = TimerService.instance();
        this.initialize(new LinkedList(entries), new Object());
    }

    public TimerFactory(Object lockObject) {
        TimerService.instance();
        this._timerStore = new FileTimerStore(TimerService.getContainerID());
        this.entryIsChanged = false;
        this._futureScheduleInterval = 300000L;
        this.service = TimerService.instance();
        this.initialize(new LinkedList(), lockObject);
    }

    public TimerFactory(Collection entries, Object lockObject) {
        TimerService.instance();
        this._timerStore = new FileTimerStore(TimerService.getContainerID());
        this.entryIsChanged = false;
        this._futureScheduleInterval = 300000L;
        this.service = TimerService.instance();
        this.initialize(new LinkedList(entries), lockObject);
    }

    private void initialize(LinkedList entries, Object lockObject) {
        this._currentConfig = new TimerConfig(entries);
        this._currentConfigLock = lockObject;
    }

    public void writePersistentStore(Timer timer, boolean isCron) {
        this._timerStore.writePersistentStore(timer, isCron);
    }

    public Collection readPersistentStore(boolean isCron) {
        return this._timerStore.readPersistentStore(isCron);
    }

    public void rmPersistentStore(Timer timer, boolean isCron) {
        this._timerStore.rmPersistentStore(timer, isCron);
    }

    public void setFutureScheduleInterval(long time) {
        this._futureScheduleInterval = time;
    }

    public long getFutureScheduleInterval() {
        return this._futureScheduleInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this._currentConfigLock;
        synchronized (object) {
            this._currentConfig.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleEvent(long time, TimerEntry entry) {
        if (time != Long.MAX_VALUE) {
            Object object = this._currentConfigLock;
            synchronized (object) {
                this._currentConfig.schedule.add(new TimerEvent(time, entry.timer));
                entry.lastScheduled = time + 1000L;
                ++entry.numberScheduled;
                m_logger.finest("scheduleEvent" + time);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEntries(Collection entries) {
        Object object = this._currentConfigLock;
        synchronized (object) {
            this._currentConfig = new TimerConfig();
            Iterator iterator = entries.iterator();
            while (iterator.hasNext()) {
                TimerEntry entry = (TimerEntry)iterator.next();
                this._currentConfig.entries.add(entry);
            }
            this.entryIsChanged = true;
            this.service.wake();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEntry(TimerEntry entry) {
        Object object = this._currentConfigLock;
        synchronized (object) {
            this._currentConfig.entries.add(entry);
            this.entryIsChanged = true;
            this.service.wake();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rmEntry(TimerEntry entry) {
        Object object = this._currentConfigLock;
        synchronized (object) {
            this._currentConfig.entries.remove(entry);
            Iterator it = this._currentConfig.schedule.iterator();
            ArrayList<TimerEvent> rmList = new ArrayList<TimerEvent>();
            while (it.hasNext()) {
                TimerEvent te = (TimerEvent)it.next();
                if (te.getTimerEntry() != entry) continue;
                rmList.add(te);
            }
            this._currentConfig.schedule.removeAll(rmList);
            this.entryIsChanged = true;
            this.service.wake();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkedList getTimers() {
        Object object = this._currentConfigLock;
        synchronized (object) {
            return (LinkedList)this._currentConfig.entries;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long runEvents(long now) {
        Object object = this._currentConfigLock;
        synchronized (object) {
            return this.runEvents(this._currentConfig, now);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleEvents(long now) {
        boolean i = false;
        Object object = this._currentConfigLock;
        synchronized (object) {
            long scheduleUntil = now + this._futureScheduleInterval;
            Iterator it = this._currentConfig.entries.iterator();
            while (it.hasNext()) {
                TimerEntry entry = (TimerEntry)it.next();
                if (entry.timer.isPassivated()) continue;
                long nextEventTime = entry.nextEvent(entry.lastScheduled);
                if (!entry.repeats()) {
                    this.scheduleEvent(nextEventTime, entry);
                    continue;
                }
                if (nextEventTime >= scheduleUntil || entry.isScheduled()) continue;
                this.scheduleEvent(nextEventTime, entry);
                nextEventTime = entry.nextEvent(entry.lastScheduled);
                entry.setIsScheduled(true);
            }
            this.entryIsChanged = false;
        }
    }

    public boolean isEntryChanged() {
        return this.entryIsChanged;
    }

    protected long runEvents(TimerConfig conf, long now) {
        long rtn = -1L;
        Iterator it = conf.schedule.iterator();
        ArrayList<TimerEvent> done = new ArrayList<TimerEvent>();
        while (it.hasNext()) {
            TimerEvent ce = (TimerEvent)it.next();
            TimerEntry entry = ce.getTimerEntry();
            if (ce.getTime() != -1L && ce.getTime() <= now) {
                --entry.numberScheduled;
                done.add(ce);
                try {
                    this.service.publish(ce);
                }
                catch (Throwable e) {
                    this.service.error("TimerFactory", "Event Failed: " + e.toString());
                }
                continue;
            }
            if (rtn != -1L && ce.getTime() >= rtn) continue;
            rtn = ce.getTime();
        }
        conf.schedule.removeAll(done);
        if (rtn == -1L) {
            if (conf.schedule.isEmpty()) {
                if (!conf.entries.isEmpty()) {
                    rtn = now + this._futureScheduleInterval;
                }
            } else {
                rtn = now;
            }
        }
        return rtn;
    }

    public void log(String message, long time) {
        Calendar tmp = Calendar.getInstance();
        tmp.setTime(new Date(time));
        this.service.debug("TimerFactory", message + " @ " + tmp.getTime() + " " + tmp.get(14));
    }

    public String toString() {
        String rtn = "";
        Iterator it = this._currentConfig.entries.iterator();
        while (it.hasNext()) {
            rtn = rtn + it.next().toString() + "\n";
        }
        return rtn;
    }

    public class TimerConfig {
        List entries;
        List schedule = new LinkedList();

        TimerConfig(List entries) {
            this.entries = entries;
        }

        public TimerConfig() {
            this.entries = new LinkedList();
        }

        public void clear() {
            this.entries.clear();
            this.schedule.clear();
        }
    }
}

