/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.container.timer;

import com.evermind.server.ApplicationServer;
import com.evermind.server.OC4JServer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.logging.Logger;
import javax.ejb.NoSuchObjectLocalException;
import javax.transaction.SystemException;
import oracle.ias.container.ContainerService;
import oracle.ias.container.event.Event;
import oracle.ias.container.event.EventService;
import oracle.ias.container.event.Publisher;
import oracle.ias.container.logging.ContainerServiceTraceLogger;
import oracle.ias.container.timer.Timer;
import oracle.ias.container.timer.TimerCallbacks;
import oracle.ias.container.timer.TimerEmptyException;
import oracle.ias.container.timer.TimerEntry;
import oracle.ias.container.timer.TimerEvent;
import oracle.ias.container.timer.TimerParseException;
import oracle.ias.container.timer.TimerServiceMBeanProxy;
import oracle.ias.container.timer.internal.CronEntry;
import oracle.ias.container.timer.internal.DateUtil;
import oracle.ias.container.timer.internal.TimeBasedEntry;
import oracle.ias.container.timer.internal.TimerFactory;

public class TimerService
extends ContainerService
implements Publisher {
    TimerFactory _cronFactory = null;
    TimerFactory _timeBasedFactory = null;
    public static int k_timerServiceId = 1402;
    private static Logger m_logger = ContainerServiceTraceLogger.getTraceLogger(TimerService.class);
    private static TimerService _instance = null;
    private String tempDir = ".";
    private char space = (char)32;
    private static long _timerIdCounter = System.currentTimeMillis();
    private static long _containerID = OC4JServer.getNodeId();
    private Object lock = new Object();

    protected TimerService() {
        super("Timer Service");
        _instance = this;
        this.m_serviceId = k_timerServiceId;
    }

    public static TimerService instance() {
        if (_instance == null) {
            _instance = new TimerService();
        }
        return _instance;
    }

    public ApplicationServer getAppServer() {
        return ApplicationServer.getInstance();
    }

    public String getTempDir() {
        return this.tempDir;
    }

    public void setTempDir(String dir) {
        this.tempDir = dir;
    }

    public Timer createTimer(long duration, String className, Serializable info) throws IllegalArgumentException, IllegalStateException {
        return this._createTimer(duration, className, info, null);
    }

    protected Timer _createTimer(long duration, String className, Serializable info, TimerCallbacks timerCallbacks) throws IllegalArgumentException, IllegalStateException {
        this.checkCallPermission();
        if (duration < 0L) {
            throw new IllegalArgumentException("invalid duration=" + duration);
        }
        TimeBasedEntry entry = new TimeBasedEntry(duration, className, info);
        Timer timer = new Timer(entry, timerCallbacks);
        this.schedule(timer);
        return timer;
    }

    protected void schedule(Timer timer) {
        TimerEntry entry = timer.getTimerEntry();
        m_logger.finest("Timer Schedule " + entry.toString());
        if (entry.getTimeRemaining() < 0L) {
            throw new IllegalStateException("Timer has been scheduled in the past");
        }
        entry.lastScheduled = System.currentTimeMillis();
        if (entry instanceof TimeBasedEntry) {
            this._timeBasedFactory.addEntry(entry);
        } else {
            this._cronFactory.addEntry(entry);
        }
        if (timer.getState() == 1) {
            return;
        }
        ApplicationServer appServer = ApplicationServer.getInstance();
        if (appServer == null) {
            entry.timer.setState(1);
        } else {
            try {
                if (appServer.getTransactionManager().getTransaction() == null) {
                    entry.timer.setState(1);
                    this.writePersistentStore(entry.timer);
                    m_logger.finest("TimerService -- Timer scheduled!");
                }
            }
            catch (SystemException systemException) {
                m_logger.finest("TimerService -- getTransaction threw SystemException " + (Object)((Object)systemException));
            }
        }
    }

    public Timer createTimer(long initialDuration, long intervalDuration, String className, Serializable info) throws IllegalArgumentException, IllegalStateException {
        return this._createTimer(initialDuration, intervalDuration, className, info, null);
    }

    protected Timer _createTimer(long initialDuration, long intervalDuration, String className, Serializable info, TimerCallbacks timerCallbacks) throws IllegalArgumentException, IllegalStateException {
        this.checkCallPermission();
        if (initialDuration < 0L) {
            throw new IllegalArgumentException("invalid initial duration = " + initialDuration);
        }
        if (intervalDuration < 0L) {
            throw new IllegalArgumentException("invalid interval duration = " + intervalDuration);
        }
        TimeBasedEntry entry = new TimeBasedEntry(initialDuration, intervalDuration, className, info);
        Timer timer = new Timer(entry, timerCallbacks);
        this.schedule(timer);
        return timer;
    }

    public Timer createTimer(Date expiration, String className, Serializable info) throws IllegalArgumentException, IllegalStateException {
        return this._createTimer(expiration, className, info, null);
    }

    protected Timer _createTimer(Date expiration, String className, Serializable info, TimerCallbacks timerCallbacks) throws IllegalArgumentException, IllegalStateException {
        this.checkCallPermission();
        if (expiration == null) {
            throw new IllegalArgumentException("null expiration");
        }
        TimeBasedEntry entry = new TimeBasedEntry(expiration, className, info);
        Timer timer = new Timer(entry, timerCallbacks);
        this.schedule(timer);
        return timer;
    }

    public Timer createTimer(Date initialExpiration, long intervalDuration, String className, Serializable info) throws IllegalArgumentException, IllegalStateException {
        return this._createTimer(initialExpiration, intervalDuration, className, info, null);
    }

    protected Timer _createTimer(Date initialExpiration, long intervalDuration, String className, Serializable info, TimerCallbacks timerCallbacks) throws IllegalArgumentException, IllegalStateException {
        this.checkCallPermission();
        if (initialExpiration == null) {
            throw new IllegalArgumentException("null expiration");
        }
        if (intervalDuration < 0L) {
            throw new IllegalArgumentException("invalid interval duration = " + intervalDuration);
        }
        TimeBasedEntry entry = new TimeBasedEntry(initialExpiration, intervalDuration, className, info);
        Timer timer = new Timer(entry, timerCallbacks);
        this.schedule(timer);
        return timer;
    }

    public Timer createTimer(int minute, int hour, int dayOfMonth, int month, int dayOfWeek, String className, Serializable info) throws IllegalArgumentException, IllegalStateException {
        return this._createTimer(minute, hour, dayOfMonth, month, dayOfWeek, className, info, null);
    }

    public Timer _createTimer(int minute, int hour, int dayOfMonth, int month, int dayOfWeek, String className, Serializable info, TimerCallbacks timerCallbacks) throws IllegalArgumentException, IllegalStateException {
        String cronStr = "" + minute + this.space + hour + this.space + dayOfMonth + this.space + month + this.space + dayOfWeek + this.space + "Timer createTimer";
        return this.createCronTimer(cronStr, false, className, info, timerCallbacks);
    }

    public Timer createTimer(String minute, String hour, String dayOfMonth, String month, String dayOfWeek, String className, Serializable info) throws IllegalArgumentException, IllegalStateException {
        return this._createTimer(minute, hour, dayOfMonth, month, dayOfWeek, className, info, null);
    }

    protected Timer _createTimer(String minute, String hour, String dayOfMonth, String month, String dayOfWeek, String className, Serializable info, TimerCallbacks timerCallbacks) throws IllegalArgumentException, IllegalStateException {
        String cronStr = "" + minute + this.space + hour + this.space + dayOfMonth + this.space + month + this.space + dayOfWeek + this.space + "Timer createTimer";
        return this.createCronTimer(cronStr, false, className, info, timerCallbacks);
    }

    public Timer createTimer(int minute, int hour, int dayOfMonth, int month, int dayOfWeek, int year, String className, Serializable info) throws IllegalArgumentException, IllegalStateException {
        return this._createTimer(minute, hour, dayOfMonth, month, dayOfWeek, year, className, info, null);
    }

    protected Timer _createTimer(int minute, int hour, int dayOfMonth, int month, int dayOfWeek, int year, String className, Serializable info, TimerCallbacks timerCallbacks) throws IllegalArgumentException, IllegalStateException {
        String cronStr = "" + minute + this.space + hour + this.space + dayOfMonth + this.space + month + this.space + year + this.space + dayOfWeek + this.space + "Timer createTimer";
        return this.createCronTimer(cronStr, true, className, info, timerCallbacks);
    }

    public Timer createTimer(String minute, String hour, String dayOfMonth, String month, String dayOfWeek, String year, String className, Serializable info) throws IllegalArgumentException, IllegalStateException {
        return this._createTimer(minute, hour, dayOfMonth, month, dayOfWeek, year, className, info, null);
    }

    protected Timer _createTimer(String minute, String hour, String dayOfMonth, String month, String dayOfWeek, String year, String className, Serializable info, TimerCallbacks timerCallbacks) throws IllegalArgumentException, IllegalStateException {
        String cronStr = "" + minute + this.space + hour + this.space + dayOfMonth + this.space + month + this.space + year + this.space + dayOfWeek + this.space + "Timer createTimer";
        return this.createCronTimer(cronStr, true, className, info, timerCallbacks);
    }

    public Timer createTimer(String cronline, String className, Serializable info) throws IllegalArgumentException, IllegalStateException {
        return this.createCronTimer(cronline, false, className, info, null);
    }

    protected Timer _createTimer(String cronline, String className, Serializable info, TimerCallbacks timerCallbacks) throws IllegalArgumentException, IllegalStateException {
        return this.createCronTimer(cronline, false, className, info, timerCallbacks);
    }

    private Timer createCronTimer(String cronStr, boolean asYears, String className, Serializable info, TimerCallbacks timerCallbacks) throws IllegalArgumentException, IllegalStateException {
        CronEntry entry = null;
        this.checkCallPermission();
        try {
            entry = asYears ? new CronEntry(cronStr, DateUtil.CRON_STYLE_AND_YEARS) : new CronEntry(cronStr, DateUtil.CRON_STYLE);
            entry.setClass(className);
            entry._info = info;
        }
        catch (TimerEmptyException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        catch (TimerParseException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        Timer timer = new Timer(entry, timerCallbacks);
        this.schedule(timer);
        return timer;
    }

    public Collection getTimers() throws IllegalStateException {
        this.checkCallPermission();
        ArrayList list = new ArrayList();
        if (this._timeBasedFactory.getTimers() != null) {
            m_logger.finest("TS:getTimers(): Adding timers..." + this._timeBasedFactory.getTimers().size());
            list.addAll(this._timeBasedFactory.getTimers());
        }
        if (this._cronFactory.getTimers() != null) {
            m_logger.finest("TS:getTimers(): Adding cron timers..." + this._cronFactory.getTimers().size());
            list.addAll(this._cronFactory.getTimers());
        }
        ArrayList<Timer> listTimers = new ArrayList<Timer>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            TimerEntry entry = (TimerEntry)iterator.next();
            if (listTimers.contains(entry.timer)) continue;
            listTimers.add(entry.timer);
        }
        return listTimers;
    }

    public Collection getTimeBasedTimers() throws IllegalStateException {
        this.checkCallPermission();
        ArrayList list = new ArrayList();
        if (this._timeBasedFactory.getTimers() != null) {
            m_logger.finest("TS:getTimers(): Adding timers...");
            list.addAll(this._timeBasedFactory.getTimers());
        }
        ArrayList<Timer> listTimers = new ArrayList<Timer>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            TimerEntry entry = (TimerEntry)iterator.next();
            if (listTimers.contains(entry.timer)) continue;
            listTimers.add(entry.timer);
        }
        return listTimers;
    }

    private void checkCallPermission() throws IllegalStateException {
    }

    public boolean initialize() {
        this.m_status = 0;
        this._cronFactory = new TimerFactory(this.lockObject);
        this._timeBasedFactory = new TimerFactory(this.lockObject);
        TimerServiceMBeanProxy.instance().registerTimerServiceMbean();
        this.schedulePersistedTimers();
        return true;
    }

    public boolean shutdown() {
        this._cronFactory.shutdown();
        this._timeBasedFactory.shutdown();
        return super.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRun() throws InterruptedException {
        m_logger.finest("doRun " + this);
        long now = System.currentTimeMillis();
        this._cronFactory.scheduleEvents(now);
        long nextCronEventTime = this._cronFactory.runEvents(now);
        long cronsleepTime = nextCronEventTime < 0L ? Long.MAX_VALUE : nextCronEventTime - now;
        this._timeBasedFactory.scheduleEvents(now);
        long nextTBEventTime = this._timeBasedFactory.runEvents(now);
        long tbsleepTime = nextTBEventTime < 0L ? Long.MAX_VALUE : nextTBEventTime - now;
        long sleepTime = Math.min(tbsleepTime, cronsleepTime);
        Object object = this.lockObject;
        synchronized (object) {
            if (!this._cronFactory.isEntryChanged() && !this._timeBasedFactory.isEntryChanged()) {
                m_logger.finest("TimerService -- Cron: " + cronsleepTime / 1000L + " TB: " + tbsleepTime / 1000L + " --> " + sleepTime / 1000L);
                this.sleep(sleepTime);
            }
        }
    }

    public void doStop() throws InterruptedException {
        m_logger.finest("doStop " + this);
    }

    public void doPause() throws InterruptedException {
        m_logger.finest("doPause " + this);
    }

    public void error(String s, String s1) {
        m_logger.finest("Error: " + s + " - " + s1);
    }

    public void debug(String s, String s1) {
        m_logger.finest("Debug: " + s + " - " + s1);
    }

    public void cancel(CronEntry crontabEntry) {
    }

    public static synchronized long getNextTimerID() {
        return _timerIdCounter++;
    }

    public static long getContainerID() {
        return _containerID;
    }

    public Timer getTimerFromId(long timerID) throws NoSuchObjectLocalException {
        return this.getTimerFromId(this.getContainerID(), timerID);
    }

    public Timer getTimerFromId(long cID, long tID) throws NoSuchObjectLocalException {
        Timer retTimer = null;
        Collection col = this.getTimers();
        Iterator iterator = col.iterator();
        while (iterator.hasNext()) {
            m_logger.finest("TimerService -- getTimerFromId: Enter");
            Timer timer = (Timer)iterator.next();
            if (timer.getContainerId() != cID || timer.getTimerId() != tID) continue;
            m_logger.finest("TimerService -- getTimerFromId: Found a matching Timer!");
            timer.checkActiveState();
            retTimer = timer;
            break;
        }
        if (retTimer == null) {
            m_logger.finest("Found No matching timer!");
            throw new NoSuchObjectLocalException("Found No matching timer!");
        }
        return retTimer;
    }

    public void rmTimer(Timer timer) {
        if (timer.getTimerEntry() instanceof TimeBasedEntry) {
            this._timeBasedFactory.rmEntry(timer.getTimerEntry());
        } else {
            this._cronFactory.rmEntry(timer.getTimerEntry());
        }
        m_logger.finest("TimerService -- rmTimer: End");
    }

    public void writePersistentStore(Timer timer) {
        m_logger.finest("TimerService -- writePersistentStore: " + timer.getContainerId() + "." + timer.getTimerId());
        if (timer.getTimerEntry() instanceof TimeBasedEntry) {
            this._timeBasedFactory.writePersistentStore(timer, false);
        } else {
            this._cronFactory.writePersistentStore(timer, true);
        }
    }

    public void rmPersistentStore(Timer timer) {
        m_logger.finest("TimerService -- rmPersistentStore: " + timer.getContainerId() + "." + timer.getTimerId());
        if (timer.getTimerEntry() instanceof TimeBasedEntry) {
            this._timeBasedFactory.rmPersistentStore(timer, false);
        } else {
            this._cronFactory.rmPersistentStore(timer, true);
        }
    }

    public void schedulePersistedTimers() {
        m_logger.finest("TimerServices -- SchedulePersistedTimers: Enter");
        Collection ejbTimers = this._timeBasedFactory.readPersistentStore(false);
        Iterator iterator = ejbTimers.iterator();
        while (iterator.hasNext()) {
            Timer t = (Timer)iterator.next();
            this.passivateTimerOnRestore(t);
            this.schedulePersistedTimer(t, false);
        }
        Collection cronTimers = this._cronFactory.readPersistentStore(true);
        iterator = cronTimers.iterator();
        while (iterator.hasNext()) {
            Timer c = (Timer)iterator.next();
            this.passivateTimerOnRestore(c);
            this.schedulePersistedTimer(c, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedulePersistedTimer(Timer timer, boolean isCron) {
        block12: {
            boolean fail = false;
            try {
                block11: {
                    try {
                        if (timer.getNextTimeout() == null) {
                            m_logger.finest("TimerService -- schedulePersistedTimer: Persisted Timer " + timer.getContainerId() + "." + timer.getTimerId() + " Expired. Removing...");
                            this.rmPersistentStore(timer);
                        }
                        m_logger.finest("TimerService -- schedulePersistedTimer: " + timer.getContainerId() + "." + timer.getTimerId());
                        if (timer.getState() == 1) {
                            this.schedule(timer);
                            break block11;
                        }
                        m_logger.finest("TimerService -- schedulePersistedTimer: " + timer.getContainerId() + "." + timer.getTimerId() + " state: " + timer.getState());
                    }
                    catch (IllegalStateException exc) {
                        fail = true;
                        Object var6_5 = null;
                        if (fail) {
                            m_logger.finest("TimerService -- Persisted timer expired: " + timer.getContainerId() + "." + timer.getTimerId());
                            this.rmPersistentStore(timer);
                        }
                        break block12;
                    }
                    catch (NoSuchObjectLocalException exc) {
                        fail = true;
                        Object var6_6 = null;
                        if (fail) {
                            m_logger.finest("TimerService -- Persisted timer expired: " + timer.getContainerId() + "." + timer.getTimerId());
                            this.rmPersistentStore(timer);
                        }
                    }
                }
                Object var6_4 = null;
                if (fail) {
                    m_logger.finest("TimerService -- Persisted timer expired: " + timer.getContainerId() + "." + timer.getTimerId());
                    this.rmPersistentStore(timer);
                }
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                if (fail) {
                    m_logger.finest("TimerService -- Persisted timer expired: " + timer.getContainerId() + "." + timer.getTimerId());
                    this.rmPersistentStore(timer);
                }
                throw throwable;
            }
        }
    }

    private void passivateTimerOnRestore(Timer timer) {
        if (timer.isBeanCreated()) {
            timer.passivate();
        }
    }

    public EventService getEventService() {
        return EventService.instance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean publish(Event event) {
        Object object = this.lock;
        synchronized (object) {
            TimerEvent tevent = (TimerEvent)event;
            if (tevent.getState() == 0) {
                tevent.setState(1, false);
            }
            m_logger.finest("Published Event " + event);
            return EventService.instance().push(event);
        }
    }

    public int id() {
        return k_timerServiceId;
    }

    public boolean isPush() {
        return true;
    }
}

