/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.container.timer;

import com.evermind.security.User;
import com.evermind.server.rmi.ObjectEncoder;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ias.container.logging.ContainerServiceMessages;
import oracle.ias.container.logging.ContainerServiceTraceLogger;
import oracle.ias.container.timer.Timer;
import oracle.ias.container.timer.TimerService;

public abstract class TimerEntry {
    private static Logger m_logger = ContainerServiceTraceLogger.getTraceLogger(TimerEntry.class);
    private long _creationTime;
    protected Serializable _info;
    private String _classRef;
    protected long lastExecuted = 0L;
    public long lastScheduled;
    public int numberScheduled = 0;
    public Timer timer = null;
    protected boolean _isBeanCreated = false;
    protected Object _pk = null;
    protected boolean _isLocal = false;
    protected int _beanType;
    protected boolean _saveCreator = false;
    protected User _creator = null;
    private transient byte[] _pk_bytes = null;
    private transient byte[] _info_bytes = null;
    private transient byte[] _creator_bytes = null;
    private transient ClassLoader readObjectClassLoader;
    private boolean passivate = false;
    private boolean scheduled = false;
    TimerService service = TimerService.instance();

    protected TimerEntry() {
        this._creationTime = System.currentTimeMillis();
        this.lastScheduled = System.currentTimeMillis();
    }

    public long getCreationTime() {
        return this._creationTime;
    }

    public abstract boolean repeats();

    public Serializable getInfo() throws IllegalStateException {
        if (this._info == null) {
            this._info = (Serializable)this.readObjFromBytes(this._info_bytes);
        }
        return this._info;
    }

    public Object getPK() {
        if (this._pk == null) {
            this._pk = this.readObjFromBytes(this._pk_bytes);
        }
        return this._pk;
    }

    public User getCreator() {
        if (this._creator == null) {
            this._creator = (User)this.readObjFromBytes(this._creator_bytes);
        }
        return this._creator;
    }

    public void setInfo(Serializable info) throws IllegalStateException {
        this._info = info;
    }

    public void setClass(String className) throws IllegalStateException {
        this._classRef = className;
    }

    public String getFullClassName() {
        return this._classRef;
    }

    public abstract long getTimeRemaining() throws IllegalStateException;

    public abstract Date getNextTimeout() throws IllegalStateException;

    public abstract long nextEvent(long var1);

    public void execute() {
        m_logger.finest("executed " + this);
        this.lastExecuted = System.currentTimeMillis();
    }

    protected long getLastExecution() {
        return this.lastExecuted;
    }

    public void rewindLastScheduled() {
        this.lastScheduled = this.lastExecuted != 0L ? this.lastExecuted : this._creationTime;
    }

    public String toString() {
        return "@: " + this._creationTime + " nextTimeout " + this.getNextTimeout() + " lastScheduled " + new Date(this.lastScheduled) + " timer " + this.timer;
    }

    public abstract void readEntry(ObjectInputStream var1) throws ClassNotFoundException, IOException;

    public abstract void writeEntry(ObjectOutputStream var1) throws IOException;

    protected void read(ObjectInputStream in) throws ClassNotFoundException, IOException {
        this._creationTime = in.readLong();
        this.lastExecuted = in.readLong();
        this.lastScheduled = in.readLong();
        this._beanType = in.readInt();
        this._classRef = in.readUTF();
        this._isBeanCreated = in.readBoolean();
        this._isLocal = in.readBoolean();
        this._pk = null;
        this._pk_bytes = this.readObjBytes(in);
        this._info = null;
        this._info_bytes = this.readObjBytes(in);
        this._saveCreator = in.readBoolean();
        if (this._saveCreator) {
            this._creator = null;
            this._creator_bytes = this.readObjBytes(in);
        }
    }

    protected void write(ObjectOutputStream out) throws IOException {
        out.writeLong(this._creationTime);
        out.writeLong(this.lastExecuted);
        out.writeLong(this.lastScheduled);
        out.writeInt(this._beanType);
        out.writeUTF(this._classRef);
        out.writeBoolean(this._isBeanCreated);
        out.writeBoolean(this._isLocal);
        this.writeObjAsBytes(out, this._pk, this._pk_bytes);
        this.writeObjAsBytes(out, this._info, this._info_bytes);
        out.writeBoolean(this._saveCreator);
        if (this._saveCreator) {
            this.writeObjAsBytes(out, this._creator, this._creator_bytes);
        }
    }

    private byte[] readObjBytes(ObjectInput in) throws IOException {
        int buf_length = in.readInt();
        byte[] buf = null;
        if (buf_length > 0) {
            buf = new byte[buf_length];
            in.read(buf, 0, buf_length);
        }
        return buf;
    }

    private void writeObjAsBytes(ObjectOutput out, Object obj, byte[] obj_bytes) throws IOException {
        int buf_length = 0;
        byte[] buf = null;
        if (obj != null) {
            buf = ObjectEncoder.objectToBytes(obj);
        } else if (obj_bytes != null) {
            buf = obj_bytes;
        }
        if (buf != null) {
            buf_length = buf.length;
        }
        out.writeInt(buf_length);
        if (buf != null) {
            out.write(buf, 0, buf_length);
        }
    }

    private Object readObjFromBytes(byte[] buf) {
        Object obj;
        block5: {
            obj = null;
            try {
                if (buf != null) {
                    obj = this.readObjectClassLoader == null ? ObjectEncoder.bytesToObject(buf) : ObjectEncoder.bytesToObject(buf, this.readObjectClassLoader);
                }
            }
            catch (IOException e) {
                ContainerServiceMessages.warningException(e);
                if (m_logger.isLoggable(Level.FINEST)) {
                    m_logger.log(Level.FINEST, e.getMessage(), e);
                }
            }
            catch (ClassNotFoundException e) {
                ContainerServiceMessages.warningException(e);
                if (!m_logger.isLoggable(Level.FINEST)) break block5;
                m_logger.log(Level.FINEST, e.getMessage(), e);
            }
        }
        return obj;
    }

    public String getApplication() {
        String appName = null;
        if (this._isBeanCreated) {
            StringTokenizer st = new StringTokenizer(this._classRef, "|");
            appName = st.nextToken();
        }
        return appName;
    }

    public String getJar() {
        String jarName = null;
        if (this._isBeanCreated) {
            StringTokenizer st = new StringTokenizer(this._classRef, "|");
            String appName = st.nextToken();
            jarName = st.nextToken();
        }
        return jarName;
    }

    public String getBeanName() {
        String beanName = null;
        if (this._isBeanCreated) {
            StringTokenizer st = new StringTokenizer(this._classRef, "|");
            String appName = st.nextToken();
            String jarName = st.nextToken();
            beanName = st.nextToken();
        }
        return beanName;
    }

    protected void passivate() {
        this.passivate = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void activate() {
        Object object = this.service.getLockObject();
        synchronized (object) {
            this.passivate = false;
            this.service.wake();
        }
    }

    protected boolean isPassivated() {
        return this.passivate;
    }

    public void setReadObjectClassLoader(ClassLoader classLoader) {
        this.readObjectClassLoader = classLoader;
    }

    public synchronized void setIsScheduled(boolean state) {
        this.scheduled = state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reSchedule() {
        Object object = this.service.getLockObject();
        synchronized (object) {
            this.setIsScheduled(false);
            if (!this.passivate) {
                this.service.wake();
            }
        }
    }

    public boolean isScheduled() {
        return this.scheduled;
    }
}

