/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.container.persistence;

import com.evermind.util.ServerProperties;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.HashMap;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import oracle.ias.container.persistence.InternalPM;
import oracle.ias.container.persistence.InternalPersistenceException;
import oracle.toplink.exceptions.DatabaseException;
import oracle.toplink.exceptions.TopLinkException;
import oracle.toplink.expressions.Expression;
import oracle.toplink.expressions.ExpressionBuilder;
import oracle.toplink.jndi.JNDIConnector;
import oracle.toplink.platform.database.DatabasePlatform;
import oracle.toplink.platform.database.oracle.Oracle9Platform;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.publicinterface.UnitOfWork;
import oracle.toplink.queryframework.DatabaseQuery;
import oracle.toplink.queryframework.ReadObjectQuery;
import oracle.toplink.sessions.Connector;
import oracle.toplink.sessions.DatabaseLogin;
import oracle.toplink.sessions.DatabaseSession;
import oracle.toplink.sessions.Login;
import oracle.toplink.sessions.Project;
import oracle.toplink.threetier.ClientSession;
import oracle.toplink.threetier.ServerSession;
import oracle.toplink.tools.schemaframework.TableCreator;
import oracle.toplink.tools.workbench.XMLProjectReader;

public class NonTransactionalInternalPM
implements InternalPM {
    ServerSession serverSession;
    ClassLoader classloader;
    String applicationName;
    boolean initialized = false;
    boolean debugFlag = true;
    String defaultDataSourceName;
    private HashMap transactions = new HashMap();

    protected NonTransactionalInternalPM(String applicationName, ClassLoader classloader) {
        this.classloader = classloader;
        this.applicationName = applicationName;
    }

    public void initSession(String projectFileName, String defaultDataSourceName, boolean debugFlag) {
        this.defaultDataSourceName = defaultDataSourceName;
        this.debugFlag = debugFlag;
        new XMLProjectReader();
        Project project = XMLProjectReader.read((String)projectFileName, (ClassLoader)this.getClass().getClassLoader());
        DatabaseLogin login = project.getLogin();
        login.setUserName(null);
        login.setEncryptedPassword(null);
        login.setEncryptionClassName("oracle.toplink.internal.security.JCEEncryptor");
        login.useOracleThinJDBCDriver();
        login.usePlatform((oracle.toplink.internal.databaseaccess.DatabasePlatform)this.createDatabasePlatform());
        login.setUsesByteArrayBinding(true);
        login.setUsesStreamsForBinding(true);
        login.useExternalConnectionPooling();
        try {
            JNDIConnector connector = new JNDIConnector((Context)new InitialContext(), this.defaultDataSourceName);
            login.setConnector((Connector)connector);
        }
        catch (NamingException e) {
            new InternalPersistenceException("Error creating namingcontext: " + e.getMessage());
        }
        project.setDatasourceLogin((Login)login);
        this.serverSession = (ServerSession)project.createServerSession();
        int logLevel = this.debugFlag ? 0 : 8;
        this.serverSession.setLogLevel(logLevel);
        this.serverSession.getDatasourcePlatform().getConversionManager().setLoader(this.classloader);
        if (ServerProperties.getClusterDbreplicationSybaseManuallyhandletrans()) {
            this.serverSession.getLogin().handleTransactionsManuallyForSybaseJConnect();
        }
        this.serverSession.login();
        this.initialized = true;
    }

    public final void delete(Collection objects) {
        this.delete(this.acquireHandle(), objects);
    }

    public final void delete(Object handle, Collection objects) {
        try {
            if (handle == null) {
                this.getClientSession().deleteAllObjects(objects);
            } else {
                ((oracle.toplink.sessions.UnitOfWork)handle).deleteAllObjects(objects);
            }
        }
        catch (DatabaseException e) {
            String sError = "TOPLink exception deleting objects: " + e.getMessage();
            throw e;
        }
    }

    public final void delete(Object object) {
        this.delete(this.acquireHandle(), object);
    }

    public final void delete(Object handle, Object object) {
        try {
            if (handle == null) {
                handle = this.acquireHandle();
            }
            ((oracle.toplink.sessions.UnitOfWork)handle).deleteObject(object);
        }
        catch (TopLinkException e) {
            String sError = "DatabaseException deleting objects: " + e.getMessage();
            throw e;
        }
    }

    protected final ServerSession getServerSession() {
        return this.serverSession;
    }

    public ClientSession getClientSession() {
        return this.getServerSession().acquireClientSession();
    }

    public Object registerObject(Object handle, Object object) {
        Object newObject = ((oracle.toplink.sessions.UnitOfWork)handle).registerObject(object);
        return newObject;
    }

    public Collection registerObjects(Object handle, Collection objects) {
        return ((oracle.toplink.sessions.UnitOfWork)handle).registerAllObjects(objects);
    }

    public Object createNewInstance(Object handle, Class domainClass) {
        Object newObject = ((oracle.toplink.sessions.UnitOfWork)handle).newInstance(domainClass);
        return newObject;
    }

    public Object mergeObject(Object handle, Object object) {
        Object newObject = ((oracle.toplink.sessions.UnitOfWork)handle).mergeClone(object);
        return newObject;
    }

    public Object deepMergeObject(Object handle, Object object) {
        Object newObject = ((oracle.toplink.sessions.UnitOfWork)handle).refreshObject(object);
        newObject = ((oracle.toplink.sessions.UnitOfWork)handle).deepMergeClone(object);
        return newObject;
    }

    public Object refreshObject(Object object) {
        return this.getClientSession().refreshObject(object);
    }

    public Object insert(Object object) {
        Object newObject = this.registerObject(this.acquireHandle(), object);
        return newObject;
    }

    public Object update(Object object) {
        Object newObject = this.mergeObject(this.acquireHandle(), object);
        return newObject;
    }

    protected final Object acquireHandle() {
        return this.getClientSession().acquireUnitOfWork();
    }

    protected final Object acquireHandle(String id) {
        Object aHandle = null;
        aHandle = this.transactions.get(id);
        if (aHandle == null) {
            aHandle = this.acquireHandle();
            this.transactions.put(id, aHandle);
        }
        return this.acquireHandle();
    }

    public void commit(Object handle) {
        ((oracle.toplink.sessions.UnitOfWork)handle).commit();
    }

    public void writeObject(Object object) {
        UnitOfWork uow = this.getClientSession().acquireUnitOfWork();
        uow.deepMergeClone(object);
        uow.commit();
    }

    public void deleteObject(Object object) {
        UnitOfWork uow = this.getClientSession().acquireUnitOfWork();
        uow.deleteObject(object);
        uow.commit();
    }

    public final void writeObject(String id, Object object) {
        Object aHandle = this.acquireHandle(id);
        this.mergeObject(aHandle, object);
        this.commit(aHandle);
        this.transactions.remove(id);
    }

    public final void deleteObject(String id, Object object) {
        Object aHandle = this.acquireHandle(id);
        this.delete(aHandle, object);
        this.commit(aHandle);
        this.transactions.remove(id);
    }

    public final Object selectById(Class domainClass, Object key) {
        return this.selectById(null, domainClass, key);
    }

    public final Object selectById(String id, Class domainClass, Object key) {
        return this.selectById(this.acquireHandle(), domainClass, key);
    }

    public final Object selectById(Object handle, Class domainClass, Object key) {
        return this.selectById(handle, domainClass, "id", key);
    }

    public final Object selectById(Object handle, Class domainClass, String attributeName, Object key) {
        try {
            Object object = null;
            ExpressionBuilder builder = new ExpressionBuilder();
            Expression expression = builder.get(attributeName).equal(key);
            ReadObjectQuery query = new ReadObjectQuery(domainClass);
            if (handle == null) {
                query.dontCheckCache();
                query.setSelectionCriteria(expression);
                object = this.getClientSession().executeQuery((DatabaseQuery)query);
            } else {
                query.setSelectionCriteria(expression);
                object = ((oracle.toplink.sessions.UnitOfWork)handle).executeQuery((DatabaseQuery)query);
            }
            return object;
        }
        catch (TopLinkException e) {
            String sError = "TOPLinkException reading object: " + e.getMessage();
            throw e;
        }
    }

    public void createTables(TableCreator tableCreator) throws InternalPersistenceException {
        try {
            tableCreator.createTables((DatabaseSession)this.getServerSession());
        }
        catch (Exception e) {
            new InternalPersistenceException("Error creating tables: " + e.getMessage());
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public boolean isDebug() {
        return this.debugFlag;
    }

    public boolean isTransactional() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (this.serverSession == null || !this.isInitialized()) {
            return;
        }
        ServerSession serverSession = this.serverSession;
        synchronized (serverSession) {
            if (this.serverSession != null) {
                this.serverSession.logout();
                this.serverSession = null;
                this.initialized = false;
            }
        }
    }

    public String getDefaultDataSourceName() {
        return this.defaultDataSourceName;
    }

    public String getSessionName() {
        if (this.initialized) {
            return this.serverSession.getName();
        }
        return null;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public Timestamp getDatabaseTimeStamp() {
        if (this.isInitialized()) {
            return this.getClientSession().getPlatform().getTimestampFromServer((Session)this.getClientSession(), this.getClientSession().getName());
        }
        throw new InternalPersistenceException("The Persistence Manager Session has not be initialized");
    }

    public DatabasePlatform createDatabasePlatform() {
        String dbPlatformStr = ServerProperties.getClusterDbreplicationPlatform();
        DatabasePlatform dbPlatform = null;
        try {
            Class<?> c = Class.forName(dbPlatformStr);
            dbPlatform = (DatabasePlatform)c.newInstance();
        }
        catch (Exception e) {
            try {
                dbPlatform = new Oracle9Platform();
            }
            catch (Exception ex) {
                new InternalPersistenceException("Error instantiating the default DB Platform for clustering: " + e.getMessage());
            }
        }
        return dbPlatform;
    }
}

