/*
 * Decompiled with CFR 0.152.
 */
package oracle.as.j2ee.transaction.tpc;

import java.io.File;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import javax.transaction.xa.Xid;
import oracle.as.j2ee.transaction.propagation.ParentReference;
import oracle.as.j2ee.transaction.tpc.Branch;
import oracle.as.j2ee.transaction.tpc.FileStorePooledFileChannel;
import oracle.as.j2ee.transaction.tpc.GlobalTransaction;
import oracle.as.j2ee.transaction.tpc.RMId;
import oracle.as.j2ee.transaction.tpc.Store;

public class FileStoreWriteUtils {
    static final String S_NULL = "\"\"";
    static final int BLANK_SPACE = 32;
    static final char NEW_LINE = '\n';
    static final String PARENT = "PARENT";
    static final String TRANS = "TRANS";
    static final String BRANCH = "BRANCH";
    static final String STATE = "STATE";

    File createFile(String logFilePath, boolean isDir) throws Store.StoreException {
        File file = new File(logFilePath);
        if (!file.exists()) {
            if (isDir && !file.mkdirs()) {
                throw new Store.StoreException("Could not create directory : " + file.getAbsolutePath());
            }
            if (!isDir) {
                try {
                    file.createNewFile();
                }
                catch (IOException ioe) {
                    Store.StoreException storeEx = new Store.StoreException("Could not create file : " + file.getAbsolutePath());
                    storeEx.initCause(ioe);
                    throw storeEx;
                }
            }
        }
        return file;
    }

    void noteStateWithoutForce(ArrayList buffers, int state) throws Store.StoreException {
        this.write(STATE, buffers);
        this.write(state, buffers);
        this.putNewLine(buffers);
    }

    void noteTransactionXid(ArrayList buffers, GlobalTransaction transaction) throws Store.StoreException {
        this.write(TRANS, buffers);
        this.writeXid(transaction.getXid(), buffers);
        String type = transaction.getType();
        this.write(type == null ? S_NULL : type, buffers);
        this.putNewLine(buffers);
    }

    void noteParentReference(ArrayList buffers, GlobalTransaction transaction) throws Store.StoreException {
        this.write(PARENT, buffers);
        this.writeParentReference(transaction.getParentReference(), buffers);
        this.putNewLine(buffers);
    }

    void noteBranches(ArrayList buffers, GlobalTransaction transaction) throws Store.StoreException {
        for (int xBranch = 0; xBranch < transaction.numberOfBranches(); ++xBranch) {
            this.writeBranch(buffers, transaction.getBranch(xBranch));
        }
    }

    void writeBranch(ArrayList buffers, Branch branch) throws Store.StoreException {
        if (!branch.supportsRecovery()) {
            return;
        }
        this.write(BRANCH, buffers);
        this.writeXid(branch.getXid(), buffers);
        RMId rmId = branch.getRmId();
        Store.validateRMId(rmId, branch);
        this.writeRMId(rmId, buffers);
        this.putNewLine(buffers);
    }

    void write(String fieldName, ArrayList buffers) {
        ByteBuffer buf = this.getEligibleBuffer(buffers, fieldName.getBytes().length + 1);
        buf.put(fieldName.getBytes()).put((byte)32);
    }

    private ByteBuffer newByteBuffer(ArrayList buffers, int fieldLength) {
        ByteBuffer buf = ByteBuffer.allocate(this.calculateBufferSize(fieldLength));
        buffers.add(buf);
        return buf;
    }

    int calculateBufferSize(int fieldSize) {
        return fieldSize <= 512 ? 512 : (fieldSize + 511) / 512 * 512;
    }

    void write(int field, ArrayList buffers) {
        this.getEligibleBuffer(buffers, 4).putInt(field);
    }

    private ByteBuffer getEligibleBuffer(ArrayList bufferArrayList, int fieldLength) {
        Buffer buffer = null;
        if (bufferArrayList.size() != 0) {
            buffer = (ByteBuffer)bufferArrayList.get(bufferArrayList.size() - 1);
        }
        if (buffer == null || buffer.remaining() < fieldLength) {
            return this.newByteBuffer(bufferArrayList, fieldLength);
        }
        return buffer;
    }

    private void write(byte[] bytes, int beg, int end, ArrayList buffers) {
        int length = end - beg;
        this.write(length, buffers);
        this.getEligibleBuffer(buffers, length).put(bytes, beg, end);
    }

    void write(byte[] bytes, ArrayList buffers) throws Store.StoreException {
        this.write(bytes, 0, bytes.length, buffers);
    }

    void writeXid(Xid xid, ArrayList buffers) throws Store.StoreException {
        this.write(xid.getGlobalTransactionId(), buffers);
        this.write(xid.getFormatId(), buffers);
        this.write(this.getBranchQualifier(xid), buffers);
    }

    void writeParentReference(ParentReference parentReference, ArrayList buffers) throws Store.StoreException {
        if (parentReference == null) {
            this.write(S_NULL, buffers);
            this.write(S_NULL, buffers);
        } else {
            this.write(parentReference.getProtocol(), buffers);
            this.write(parentReference.getEndpoint(), buffers);
        }
    }

    private byte[] getBranchQualifier(Xid xid) {
        byte[] bq = xid.getBranchQualifier();
        if (bq == null) {
            return new byte[0];
        }
        return bq;
    }

    void writeRMId(RMId rmId, ArrayList buffers) throws Store.StoreException {
        this.write(rmId.getRMFactoryJndiLocation().getJndiLocation(), buffers);
        String arg = rmId.getRMFactoryArg();
        this.write(arg == null ? S_NULL : arg, buffers);
    }

    void writeRMIdWithRLRCName(RMId rmId, String rlrcName, ArrayList buffers) throws Store.StoreException {
        this.write(rmId.getRMFactoryJndiLocation().getJndiLocation(), buffers);
        String arg = rmId.getRMFactoryArg();
        this.write(arg == null ? S_NULL : arg, buffers);
        this.write(rlrcName == null ? S_NULL : rlrcName, buffers);
    }

    void putNewLine(ArrayList buffers) throws Store.StoreException {
        this.getEligibleBuffer(buffers, 1).put((byte)10);
    }

    void forceToDisk(ArrayList buffers, FileStorePooledFileChannel channel) throws Store.StoreException {
        try {
            ByteBuffer[] bufArray = buffers.toArray(new ByteBuffer[0]);
            this.flipAll(bufArray);
            channel.write(bufArray);
            channel.force(false);
        }
        catch (IOException ex) {
            Store.StoreException se = new Store.StoreException("IOException while writing information for xid : " + channel.getXid() + " to file : " + channel.getFileName());
            se.initCause(ex);
            throw se;
        }
    }

    void forceResourceEntryToDisk(ArrayList buffers, FileChannel channel) throws Store.StoreException {
        try {
            ByteBuffer[] bufArray = buffers.toArray(new ByteBuffer[0]);
            this.flipAll(bufArray);
            channel.write(bufArray);
            channel.force(false);
        }
        catch (IOException ex) {
            Store.StoreException se = new Store.StoreException("IOException while writing resource information");
            se.initCause(ex);
            throw se;
        }
    }

    private void flipAll(ByteBuffer[] bufArray) {
        for (int i = 0; i < bufArray.length; ++i) {
            bufArray[i].flip();
        }
    }
}

