/*
 * Decompiled with CFR 0.152.
 */
package oracle.as.j2ee.transaction.tpc;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.xa.Xid;
import oracle.as.j2ee.transaction.propagation.ParentReference;
import oracle.as.j2ee.transaction.tpc.NormalXid;
import oracle.as.j2ee.transaction.tpc.RMId;
import oracle.as.j2ee.transaction.tpc.RecoveredRMId;
import oracle.j2ee.util.TraceLogger;
import oracle.oc4j.security.OC4JSecurity;

class FileStoreInputStream {
    private static Logger m_logger = TraceLogger.getLogger(FileStoreInputStream.class);
    private InputStream m_in;
    private String m_fileName = "unknown";
    private boolean m_atBOL;
    private boolean m_atEOF;
    private int m_kind;

    FileStoreInputStream(File file) throws IOException {
        this.m_in = OC4JSecurity.newFileInputStream(file);
        this.m_fileName = file.getName();
        this.m_atBOL = true;
    }

    boolean atEOF() {
        return this.m_atEOF;
    }

    private int nextChar() throws IOException {
        int c;
        if (this.m_atEOF) {
            c = -1;
        } else {
            try {
                c = this.m_in.read();
            }
            catch (EOFException eofex) {
                c = -1;
                this.m_atEOF = true;
            }
        }
        if (c == -1) {
            this.m_atEOF = true;
        }
        return c;
    }

    int nextLineType() throws IOException {
        this.skipToBeginningOfNextLine();
        this.m_atBOL = false;
        do {
            int char0 = this.m_in.read();
            while (char0 != -1 && Character.isWhitespace((char)char0)) {
                char0 = this.m_in.read();
            }
            switch (char0) {
                case -1: {
                    this.m_kind = -1;
                    this.m_atEOF = true;
                    break;
                }
                case 10: {
                    this.m_kind = 0;
                    break;
                }
                case 0: {
                    m_logger.log(Level.FINER, "FileStoreInputStream.nextLineType was 0, disregarding...");
                    this.m_kind = 0;
                    break;
                }
                case 66: {
                    this.m_kind = 3;
                    this.skipTo(32);
                    break;
                }
                case 80: {
                    this.m_kind = 1;
                    this.skipTo(32);
                    break;
                }
                case 83: {
                    this.m_kind = 4;
                    this.skipTo(32);
                    break;
                }
                case 84: {
                    this.m_kind = 2;
                    this.skipTo(32);
                    break;
                }
                default: {
                    throw new IOException("Bad record type: '" + char0 + "' found in file " + this.m_fileName);
                }
            }
        } while (this.m_kind == 0);
        return this.m_kind;
    }

    void skipToBeginningOfNextLine() throws IOException {
        if (!this.m_atBOL) {
            this.skipTo(10);
        }
        this.m_atBOL = true;
    }

    void skipTo(int delim) throws IOException {
        int c;
        while ((c = this.nextChar()) != delim && c != -1) {
        }
    }

    String readToken() throws IOException {
        int c;
        StringBuffer tok = new StringBuffer();
        while ((c = this.nextChar()) != -1 && Character.isWhitespace((char)c)) {
        }
        int i = 0;
        while (c != 32 && c != -1) {
            if (++i > 512) {
                throw new IOException("Field exceeded allowable length of 512, the transaction log may be corrupted in file " + this.m_fileName);
            }
            tok.append((char)c);
            c = this.nextChar();
        }
        return tok.toString();
    }

    int readInt(int maxLength) throws IOException {
        int i;
        ByteBuffer buf = ByteBuffer.allocate(512);
        for (i = 0; i < 4; ++i) {
            buf.put(this.readByte());
        }
        buf.flip();
        i = buf.getInt();
        if (i > maxLength) {
            throw new IOException("Error reading record, transaction log may be corrupt");
        }
        return i;
    }

    byte readByte() throws IOException {
        return (byte)(this.m_in.read() & 0xFF);
    }

    byte[] readBytes() throws IOException {
        int len = this.readInt(4096);
        byte[] bytes = new byte[]{};
        bytes = new byte[len];
        for (int xByte = 0; xByte < len; ++xByte) {
            bytes[xByte] = this.readByte();
        }
        return bytes;
    }

    Xid readXid() throws IOException {
        return new NormalXid(this.readBytes(), this.readInt(Integer.MAX_VALUE), this.readBytes());
    }

    String readTransactionType() throws IOException {
        return this.readToken();
    }

    RMId readRMId() throws IOException {
        String arg = null;
        String location = this.readToken();
        if (!"\"\"".equals(location) && "\"\"".equals(arg = this.readToken())) {
            arg = null;
        }
        return new RecoveredRMId(location, arg, null);
    }

    RecoveredRMId readRecoveredRMId() throws IOException {
        String arg = null;
        String rlrcName = null;
        String location = this.readToken();
        if (!"\"\"".equals(location) && "\"\"".equals(arg = this.readToken())) {
            arg = null;
        }
        if (!"\"\"".equals(location) && "\"\"".equals(rlrcName = this.readToken())) {
            rlrcName = null;
        }
        return new RecoveredRMId(location, arg, rlrcName);
    }

    ParentReference readParentReference() throws IOException {
        String protocol = this.readToken();
        String endpoint = this.readToken();
        if (!"\"\"".equals(protocol)) {
            return null;
        }
        return new ParentReference(protocol, endpoint);
    }

    void close() throws IOException {
        this.m_in.close();
    }
}

