/*
 * Decompiled with CFR 0.152.
 */
package oracle.as.j2ee.transaction.propagation;

import com.evermind.server.ApplicationServer;
import com.evermind.server.ApplicationServerTransaction;
import com.evermind.server.ApplicationServerTransactionManager;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import oracle.as.j2ee.transaction.SubordinateTransactionManager;
import oracle.as.j2ee.transaction.tpc.ProtocolErrorWithNotification;

public class AbstractHandler {
    private static ThreadLocal m_returnResource = new ThreadLocal();
    private static ThreadLocal m_suspendedTx = new ThreadLocal();

    protected static ThreadLocal getReturnResource() {
        return m_returnResource;
    }

    protected static void setReturnResource(ThreadLocal returnResource) {
        m_returnResource = returnResource;
    }

    protected static ThreadLocal getSuspendedTx() {
        return m_suspendedTx;
    }

    protected static void setSuspendedTx(ThreadLocal suspendedTx) {
        m_suspendedTx = suspendedTx;
    }

    protected ApplicationServerTransaction getCallerTransactionForPropagation() throws SystemException {
        ApplicationServerTransaction tx = this.getCurrentTransaction();
        if (tx != null) {
            if (tx.enteredCompletionProtocol()) {
                return null;
            }
            this.suspendTransaction(tx);
        }
        return tx;
    }

    private ApplicationServerTransaction getCurrentTransaction() {
        return (ApplicationServerTransaction)((ApplicationServerTransactionManager)this.getTransactionManager()).getTransaction();
    }

    private void suspendTransaction(ApplicationServerTransaction tx) throws SystemException {
        tx.setAllowRollbackByTimeout(false);
        this.getTransactionManager().endInfection();
        AbstractHandler.getSuspendedTx().set(tx);
    }

    protected SubordinateTransactionManager getTransactionManager() {
        return (ApplicationServerTransactionManager)ApplicationServer.getInstance().getTransactionManager();
    }

    protected void infectThreadWithTransaction(Xid xid, int timeout) throws InvalidTransactionException, RollbackException, SystemException, NotSupportedException {
        if (this.getTransactionManager().infectThread(xid, timeout, null, true)) {
            AbstractHandler.getReturnResource().set(Boolean.FALSE);
        }
    }

    protected void inflowTransaction(Xid xid, int timeout) throws RollbackException, InvalidTransactionException, SystemException, NotSupportedException {
        this.infectThreadWithTransaction(xid, timeout);
    }

    private void resetReturnResourceFlag() {
        if (AbstractHandler.getReturnResource().get() != null) {
            AbstractHandler.getReturnResource().set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean terminateInfection(ApplicationServerTransaction tx) throws SystemException {
        try {
            if (tx == null) {
                boolean bl = false;
                return bl;
            }
            this.getTransactionManager().endInfection();
            boolean bl = this.shouldResourceBeReturned();
            return bl;
        }
        finally {
            this.resetReturnResourceFlag();
        }
    }

    protected boolean shouldResourceBeReturned() {
        return AbstractHandler.getReturnResource().get() == null;
    }

    protected ApplicationServerTransaction resumeTransaction() throws InvalidTransactionException, SystemException {
        ApplicationServerTransaction tx = (ApplicationServerTransaction)AbstractHandler.getSuspendedTx().get();
        if (tx == null) {
            return null;
        }
        ((ApplicationServerTransactionManager)this.getTransactionManager()).resume(tx);
        tx.setAllowRollbackByTimeout(true);
        AbstractHandler.getSuspendedTx().set(null);
        return tx;
    }

    protected void enlistRemoteResourceFromResponse(XAResource subordinateResource, byte[] bqual) throws RollbackException, SystemException {
        ApplicationServerTransaction txn = null;
        try {
            txn = this.resumeTransaction();
            if (txn == null || txn.getStatus() == 1 || subordinateResource == null) {
                return;
            }
            txn.enlistResource(subordinateResource, bqual);
        }
        catch (IllegalStateException e) {
            this.throwProtocolError(e);
        }
        catch (InvalidTransactionException e) {
            this.throwProtocolError((Exception)((Object)e));
        }
        if (subordinateResource instanceof Synchronization) {
            txn.registerSynchronization((Synchronization)subordinateResource);
        }
    }

    private void throwProtocolError(Exception e) {
        ProtocolErrorWithNotification error = new ProtocolErrorWithNotification("Unable to enlist subordinate resource." + e);
        error.initCause(e);
        throw error;
    }
}

