/*
 * Decompiled with CFR 0.152.
 */
package oracle.as.j2ee.transaction;

import com.evermind.security.SecuritySensitive;
import com.evermind.server.InvalidConfigurationException;
import oracle.as.j2ee.transaction.CommitCoordinatorConfiguration;
import oracle.j2ee.transaction.TransactionMessages;
import oracle.j2ee.transaction.recovery.RecoveryAbandonmentDetail;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MiddleTierCoordinatorConfiguration
extends CommitCoordinatorConfiguration {
    public static final int FILE_LOG = 0;
    public static final int DATABASE_LOG = 1;
    public static final int NULL_LOG = 2;
    public static final String FILE_LOG_STRING = "file";
    public static final String DATABASE_LOG_STRING = "database";
    public static final String NULL_LOG_STRING = "none";
    private int m_logType;
    private int m_recoveryRetryInterval = 300;
    private int m_rlrcPurgeInterval = 10;
    private int m_rlrcMinPurgeSize = 1000;
    private RecoveryAbandonmentDetail[] m_recoveryAbandonmentDetail = new RecoveryAbandonmentDetail[0];
    private int m_minPoolSize = 40;
    private int m_maxOpenFiles = 250;
    private int m_oldFileReleaseSize = 20;
    private int m_batchCreateInterval = 10;
    private int m_batchStateInterval = 10;
    private int m_batchPurgeInterval = 100;
    private int m_retryCount = 1;
    private String LOG_TYPE_ERROR_MSG = "Log type missing or invalid , 'file', 'database', or 'none' must be specified in transaction-manager.xml";

    public MiddleTierCoordinatorConfiguration(Node root) throws InvalidConfigurationException {
        super(root);
        NodeList elements = ((Element)root).getElementsByTagName("commit-coordinator");
        Element ce = (Element)elements.item(0);
        if (ce != null) {
            String attribute = null;
            try {
                attribute = ce.getAttribute("retry-count");
                this.m_retryCount = Integer.parseInt(attribute);
            }
            catch (NumberFormatException e) {
                throw new InvalidConfigurationException("Invalid retry-count specified, must be a numeric value of 0 or greater but was " + attribute);
            }
        }
        this.processMiddleTierTag(root);
    }

    public MiddleTierCoordinatorConfiguration() {
        this.m_logType = 2;
    }

    public MiddleTierCoordinatorConfiguration(String logType, String location, String userName, String password) throws InvalidConfigurationException {
        this.m_location = location == null ? "" : location;
        this.m_logType = this.getLogTypeForString(logType);
        if (this.m_logType == 1 && this.m_location.equals("")) {
            throw new InvalidConfigurationException("location must be specified in transaction-manager.xml for database logging");
        }
        this.m_userName = userName;
        this.m_password = password;
    }

    public MiddleTierCoordinatorConfiguration(CommitCoordinatorConfiguration oldConfig, int minPoolSize, int maxOpenFiles, int oldFileReleaseSize, int batchCreateInterval, int batchStateInterval, int batchPurgeInterval) throws InvalidConfigurationException {
        this.m_location = oldConfig.getLocation();
        this.m_logType = this.getLogTypeForString(oldConfig.getLogTypeString());
        this.m_userName = oldConfig.getUserName();
        this.m_password = oldConfig.getPassword();
        this.m_minPoolSize = minPoolSize;
        this.m_maxOpenFiles = maxOpenFiles;
        this.m_oldFileReleaseSize = oldFileReleaseSize;
        this.m_batchCreateInterval = batchCreateInterval;
        this.m_batchStateInterval = batchStateInterval;
        this.m_batchPurgeInterval = batchPurgeInterval;
    }

    public MiddleTierCoordinatorConfiguration(MiddleTierCoordinatorConfiguration currentConfig) {
        this.m_location = currentConfig.getLocation();
        this.m_userName = currentConfig.getUserName();
        this.m_password = currentConfig.getPassword();
        this.m_logType = currentConfig.getLogType();
        this.m_minPoolSize = currentConfig.getMinPoolSize();
        this.m_maxOpenFiles = currentConfig.getMaxOpenFiles();
        this.m_oldFileReleaseSize = currentConfig.getOldFileReleaseSize();
        this.m_batchCreateInterval = currentConfig.getBatchCreateInterval();
        this.m_batchStateInterval = currentConfig.getBatchStateInterval();
        this.m_batchPurgeInterval = currentConfig.getBatchPurgeInterval();
        this.m_retryCount = currentConfig.getRetryCount();
    }

    public String getCommitCoordinatorType() {
        return "middle-tier";
    }

    private void processMiddleTierTag(Node root) throws InvalidConfigurationException {
        NodeList elements = ((Element)root).getElementsByTagName("middle-tier");
        Element ce = (Element)elements.item(0);
        if (ce == null) {
            throw new InvalidConfigurationException(this.LOG_TYPE_ERROR_MSG);
        }
        this.processLogElement(ce);
        this.processRecoveryElement(ce);
    }

    private void processLogElement(Element ce) throws InvalidConfigurationException {
        NodeList melements = ce.getElementsByTagName("log");
        if ((ce = (Element)melements.item(0)) == null) {
            throw new InvalidConfigurationException(this.LOG_TYPE_ERROR_MSG);
        }
        this.m_location = ce.getAttribute("location");
        this.m_logType = this.getLogTypeForString(ce.getAttribute("type"));
        if (this.m_logType == 0) {
            this.processFileLoggingElement(ce);
        } else if (this.m_logType == 1) {
            this.processDBLoggingElement(ce);
        } else {
            TransactionMessages.config("No logging configured in transaction-manager.xml  Transactions will not be recoverable.");
        }
    }

    private void processRecoveryElement(Element ce) throws InvalidConfigurationException {
        NodeList melements = ce.getElementsByTagName("recovery");
        if ((ce = (Element)melements.item(0)) != null) {
            this.m_recoveryRetryInterval = this.setRecoveryAttributeFromConfig(ce, "retry-interval", 300);
            this.m_rlrcPurgeInterval = this.setRecoveryAttributeFromConfig(ce, "rlrc-purge-interval", 10);
            this.m_rlrcMinPurgeSize = this.setRecoveryAttributeFromConfig(ce, "rlrc-min-purge-size", 1000);
            NodeList abandonMentElements = ce.getElementsByTagName("abandonment");
            this.m_recoveryAbandonmentDetail = new RecoveryAbandonmentDetail[abandonMentElements.getLength()];
            for (int i = 0; i < abandonMentElements.getLength(); ++i) {
                Element element = (Element)abandonMentElements.item(i);
                this.m_recoveryAbandonmentDetail[i] = new RecoveryAbandonmentDetail(element.getAttribute("type"), element.getAttribute("participant-location"), Integer.parseInt(element.getAttribute("count")), Integer.parseInt(element.getAttribute("time")));
            }
        }
    }

    private int setRecoveryAttributeFromConfig(Element ce, String attributeName, int defaultValue) throws InvalidConfigurationException {
        String recoveryRetry = ce.getAttribute(attributeName);
        try {
            return recoveryRetry == null || recoveryRetry.equals("") ? defaultValue : Integer.parseInt(recoveryRetry);
        }
        catch (NumberFormatException e) {
            InvalidConfigurationException ex = new InvalidConfigurationException("Invalid number format [" + recoveryRetry + "] for " + attributeName);
            ex.initCause(ex);
            throw ex;
        }
    }

    private void processFileLoggingElement(Element ce) {
        NodeList melements = ce.getElementsByTagName("file-logging-performance");
        if (melements != null && (ce = (Element)melements.item(0)) != null) {
            this.m_minPoolSize = this.getValidAttributeInt(ce, "min-pool-size");
            this.m_maxOpenFiles = this.getValidAttributeInt(ce, "max-open-files");
            this.m_oldFileReleaseSize = this.getValidAttributeInt(ce, "old-file-release-size");
        }
    }

    private void processDBLoggingElement(Element ce) throws InvalidConfigurationException {
        if (this.m_location == null && this.m_location.equals("")) {
            throw new InvalidConfigurationException("location must be specified in transaction-manager.xml for database logging");
        }
        NodeList melements = ce.getElementsByTagName("identity");
        Element identityElement = (Element)melements.item(0);
        if (identityElement != null) {
            this.m_userName = identityElement.getAttribute("user");
            this.m_password = SecuritySensitive.global().decode(identityElement.getAttribute("password"));
            if (this.m_userName == null || this.m_userName.equals("")) {
                throw new InvalidConfigurationException("user must be specified in transaction-manager.xml for database logging if the identity tag is used");
            }
        }
        if ((melements = ce.getElementsByTagName("database-logging-performance")) != null && (ce = (Element)melements.item(0)) != null) {
            this.m_batchCreateInterval = this.getValidAttributeInt(ce, "batch-create-interval");
            this.m_batchStateInterval = this.getValidAttributeInt(ce, "batch-state-interval");
            this.m_batchPurgeInterval = this.getValidAttributeInt(ce, "batch-purge-interval");
        }
    }

    private int getValidAttributeInt(Element element, String attribute) {
        try {
            return new Integer(element.getAttribute(attribute));
        }
        catch (NumberFormatException nfe) {
            if (attribute.equals("min-pool-size")) {
                return 40;
            }
            if (attribute.equals("max-open-files")) {
                return 250;
            }
            if (attribute.equals("old-file-release-size")) {
                return 20;
            }
            if (attribute.equals("batch-create-interval")) {
                return 10;
            }
            if (attribute.equals("batch-state-interval")) {
                return 10;
            }
            if (attribute.equals("batch-purge-interval")) {
                return 100;
            }
            return 0;
        }
    }

    public void setRetryCount(int retryCount) {
        this.m_retryCount = retryCount;
    }

    public int getRetryCount() {
        return this.m_retryCount;
    }

    public int getLogType() {
        return this.m_logType;
    }

    private int getLogTypeForString(String type) throws InvalidConfigurationException {
        if (type == null) {
            throw new InvalidConfigurationException(this.LOG_TYPE_ERROR_MSG);
        }
        if (type.startsWith("n")) {
            return 2;
        }
        if (type.startsWith("data")) {
            return 1;
        }
        if (type.startsWith(FILE_LOG_STRING)) {
            return 0;
        }
        throw new InvalidConfigurationException(this.LOG_TYPE_ERROR_MSG);
    }

    public String getLogTypeString() {
        String logType = "invalid";
        if (this.m_logType == 0) {
            logType = FILE_LOG_STRING;
        } else if (this.m_logType == 1) {
            logType = DATABASE_LOG_STRING;
        } else if (this.m_logType == 2) {
            logType = NULL_LOG_STRING;
        }
        return logType;
    }

    boolean equals(CommitCoordinatorConfiguration changedConfig, CommitCoordinatorConfiguration originalConfig) {
        return super.equals(changedConfig, originalConfig) && this.equals((MiddleTierCoordinatorConfiguration)changedConfig, (MiddleTierCoordinatorConfiguration)originalConfig);
    }

    public boolean equals(Object obj) {
        return obj instanceof MiddleTierCoordinatorConfiguration && this.equals(this, (MiddleTierCoordinatorConfiguration)obj);
    }

    private boolean equals(MiddleTierCoordinatorConfiguration changedConfig, MiddleTierCoordinatorConfiguration originalConfig) {
        RecoveryAbandonmentDetail[] originalRecoveryAbandonmentDetail;
        boolean isAllButAbandonmentEqual;
        boolean bl = isAllButAbandonmentEqual = changedConfig.getRetryCount() == originalConfig.getRetryCount() && changedConfig.getMaxOpenFiles() == originalConfig.getMaxOpenFiles() && changedConfig.getMinPoolSize() == originalConfig.getMinPoolSize() && changedConfig.getOldFileReleaseSize() == originalConfig.getOldFileReleaseSize() && changedConfig.getBatchCreateInterval() == originalConfig.getBatchCreateInterval() && changedConfig.getBatchStateInterval() == originalConfig.getBatchStateInterval() && changedConfig.getBatchPurgeInterval() == originalConfig.getBatchPurgeInterval() && changedConfig.getRecoveryRetryInterval() == originalConfig.getRecoveryRetryInterval() && changedConfig.getRLRCPurgeInterval() == originalConfig.getRLRCPurgeInterval() && changedConfig.getRLRCMinPurgeSize() == originalConfig.getRLRCMinPurgeSize();
        if (!isAllButAbandonmentEqual) {
            return false;
        }
        RecoveryAbandonmentDetail[] changedRecoveryAbandonmentDetail = changedConfig.getRecoveryAbandonmentDetail();
        if (changedRecoveryAbandonmentDetail.length != (originalRecoveryAbandonmentDetail = originalConfig.getRecoveryAbandonmentDetail()).length) {
            return false;
        }
        for (int i = 0; i < originalRecoveryAbandonmentDetail.length; ++i) {
            if (originalRecoveryAbandonmentDetail[i].equals(changedRecoveryAbandonmentDetail[i])) continue;
            return false;
        }
        return true;
    }

    public int getMinPoolSize() {
        return this.m_minPoolSize;
    }

    public int getMaxOpenFiles() {
        return this.m_maxOpenFiles;
    }

    public int getOldFileReleaseSize() {
        return this.m_oldFileReleaseSize;
    }

    public int getBatchCreateInterval() {
        return this.m_batchCreateInterval;
    }

    public int getBatchStateInterval() {
        return this.m_batchStateInterval;
    }

    public int getBatchPurgeInterval() {
        return this.m_batchPurgeInterval;
    }

    public void setMinPoolSize(int minPoolSize) {
        this.m_minPoolSize = minPoolSize;
    }

    public void setMaxOpenFiles(int maxOpenFiles) {
        this.m_maxOpenFiles = maxOpenFiles;
    }

    public void setOldFileReleaseSize(int oldFileReleaseSize) {
        this.m_oldFileReleaseSize = oldFileReleaseSize;
    }

    public void setBatchCreateInterval(int batchCreateInterval) {
        this.m_batchCreateInterval = batchCreateInterval;
    }

    public void setBatchStateInterval(int batchStateInterval) {
        this.m_batchStateInterval = batchStateInterval;
    }

    public void setBatchPurgeInterval(int batchPurgeInterval) {
        this.m_batchPurgeInterval = batchPurgeInterval;
    }

    public RecoveryAbandonmentDetail[] getRecoveryAbandonmentDetail() {
        return this.m_recoveryAbandonmentDetail;
    }

    public void setRecoveryAbandonmentDetail(RecoveryAbandonmentDetail[] recoveryAbandonmentDetail) {
        this.m_recoveryAbandonmentDetail = recoveryAbandonmentDetail;
    }

    public int getRecoveryRetryInterval() {
        return this.m_recoveryRetryInterval;
    }

    public int getRLRCPurgeInterval() {
        return this.m_rlrcPurgeInterval;
    }

    public int getRLRCMinPurgeSize() {
        return this.m_rlrcMinPurgeSize;
    }

    public void setRecoveryRetryInterval(int recoveryRetryInterval) {
        this.m_recoveryRetryInterval = recoveryRetryInterval;
    }

    public void setRLRCPurgeInterval(int rlrcPurgeInterval) {
        this.m_rlrcPurgeInterval = rlrcPurgeInterval;
    }

    public void setRLRCMinPurgeSize(int rlrcMinPurgeSize) {
        this.m_rlrcMinPurgeSize = rlrcMinPurgeSize;
    }
}

