/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.xml;

import com.sun.enterprise.deployment.xml.ParseException;
import com.sun.enterprise.deployment.xml.XMLValidationHandler;
import com.sun.enterprise.util.FileUtil;
import com.sun.enterprise.util.Utility;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.UnknownHostException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import oracle.xml.parser.v2.XMLParser;
import org.apache.crimson.tree.ElementFactory;
import org.apache.crimson.tree.ElementNode;
import org.apache.crimson.tree.SimpleElementFactory;
import org.apache.crimson.tree.TreeWalker;
import org.apache.crimson.tree.XmlDocument;
import org.apache.crimson.tree.XmlDocumentBuilder;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class XMLUtils {
    private static final boolean debug = false;
    private Document document;
    static String VALIDATING_PARSER = "validating.parser";
    private static boolean validatingParse = false;
    static String WEB_DTD = "web-app_2_3.dtd";
    static String TAGLIB_DTD_11 = "web-jsptaglibrary_1_1.dtd";
    static String TAGLIB_DTD_12 = "web-jsptaglibrary_1_2.dtd";

    public XMLUtils(Document document) {
        if (document == null) {
            throw new IllegalArgumentException("Document was null");
        }
        this.document = document;
        validatingParse = false;
    }

    private XMLUtils() {
        validatingParse = false;
    }

    public static void writeDocument(Document documentToWrite, OutputStream out) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out, "UTF-8"));
        ((XmlDocument)documentToWrite).write((Writer)writer, "UTF-8");
    }

    public static void writeDocumentToFile(Document document, File file) throws IOException {
        if (file.getParent() != null) {
            boolean ok = new File(file.getParent()).mkdirs();
        }
        FileOutputStream out = new FileOutputStream(file);
        XMLUtils.writeDocument(document, out);
        out.close();
    }

    public static String documentToString(Document document) throws IOException {
        StringWriter writer = new StringWriter();
        ((XmlDocument)document).write((Writer)writer, "UTF-8");
        return writer.toString();
    }

    public ElementNode getNode(String tag) {
        ElementNode n = (ElementNode)this.document.createElement(tag);
        return n;
    }

    public ElementNode getNode(String tag, String valueName, String value) {
        ElementNode n = this.getNode(tag);
        if (value != null) {
            n.setAttribute(valueName, value);
        }
        return n;
    }

    public ElementNode getNode(String tag, String valueName1, String value1, String valueName2, String value2) {
        ElementNode n = this.getNode(tag);
        n.setAttribute(valueName1, value1);
        n.setAttribute(valueName2, value2);
        return n;
    }

    public ElementNode getPropertiesNode(String tag, String propertyTagName, Properties p) {
        ElementNode root = this.getNode(tag);
        Enumeration<?> e = p.propertyNames();
        while (e.hasMoreElements()) {
            String nextKey = (String)e.nextElement();
            String nextValue = (String)p.get(nextKey);
            ElementNode nextPropertyNode = this.getNode(propertyTagName);
            nextPropertyNode.setAttribute("name", nextKey);
            nextPropertyNode.setAttribute("value", nextValue);
            root.appendChild((Node)nextPropertyNode);
        }
        return root;
    }

    public ElementNode getTextNode(String tag, String text) {
        ElementNode en = this.getNode(tag);
        en.appendChild((Node)this.document.createTextNode(text));
        return en;
    }

    public static Properties getProperties(ElementNode root, String tag, String propertyNameTag) {
        Properties p = new Properties();
        TreeWalker tw = new TreeWalker((Node)root);
        Element startPropertiesNode = tw.getNextElement(tag);
        tw = new TreeWalker((Node)startPropertiesNode);
        Element nextNode = null;
        while ((nextNode = tw.getNextElement(propertyNameTag)) != null) {
            ElementNode propertyNode = (ElementNode)nextNode;
            String nextKey = propertyNode.getAttribute("name");
            String nextValue = propertyNode.getAttribute("value");
            p.put(nextKey, nextValue);
        }
        return p;
    }

    public static String getValueOf(Node root, String tag, String key) {
        Node theNode = null;
        if (root instanceof Element && ((Element)root).getTagName().equals(tag)) {
            theNode = root;
        } else {
            TreeWalker tw = new TreeWalker(root);
            theNode = tw.getNextElement(tag);
        }
        if (theNode == null) {
            throw new RuntimeException("can't find a node under " + root + " with tag " + tag);
        }
        Attr n = (Attr)theNode.getAttributes().getNamedItem(key);
        return n.getNodeValue();
    }

    private static String getTextFor_Lib(ElementNode root, String tag) {
        if (root.getTagName().equals(tag) && root.getFirstChild() instanceof Text) {
            return ((Text)root.getFirstChild()).getNodeValue();
        }
        TreeWalker tw = new TreeWalker((Node)root);
        ElementNode n = (ElementNode)tw.getNextElement(tag);
        if (n == null) {
            if (tag.equals("ejb-relationship-role-name")) {
                return "";
            }
            throw new IllegalArgumentException(root + " has no sub nodes with tag " + tag);
        }
        Text tn = (Text)n.getFirstChild();
        if (tn == null) {
            return "";
        }
        return tn.getNodeValue();
    }

    public static String getTextFor(ElementNode root, String tag) {
        return XMLUtils.getTextFor_Lib(root, tag);
    }

    public static ElementNode getFirstNodeUnder(Node root, String tag) {
        TreeWalker tw = new TreeWalker(root);
        Element node = tw.getNextElement(tag);
        if (node != null) {
            return (ElementNode)node;
        }
        return null;
    }

    public static boolean hasImmediateElementChildFor(ElementNode node, String tag) {
        NodeList nl = node.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            ElementNode nextElementNode;
            Node next = nl.item(i);
            if (!(next instanceof ElementNode) || !(nextElementNode = (ElementNode)next).getTagName().equals(tag)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasNodesUnder(Node root, String tag) {
        return XMLUtils.getFirstNodeUnder(root, tag) != null;
    }

    public static Enumeration getNodesUnder(Node root, String tag) {
        return XMLUtils.getVectorOfNodesUnder(root, tag).elements();
    }

    public static Enumeration getNodesUnder(Node root, String[] tags) {
        Vector nodes = new Vector();
        for (int i = 0; i < tags.length; ++i) {
            nodes.addAll(XMLUtils.getVectorOfNodesUnder(root, tags[i]));
        }
        return nodes.elements();
    }

    public static Vector getVectorOfNodesUnder(Node root, String tag) {
        Vector<Element> nodes = new Vector<Element>();
        Element next = null;
        TreeWalker tw = new TreeWalker(root);
        while ((next = tw.getNextElement(tag)) != null) {
            nodes.addElement(next);
        }
        return nodes;
    }

    public static Vector getNodesByType(Class type, Dictionary nodeToClassMap, InputStream is) throws Throwable {
        Vector<Document> nodes = new Vector<Document>();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(is);
            TreeWalker tw = new TreeWalker((Node)document);
            Node next = document;
            while (next != null) {
                if (type.isInstance(next)) {
                    nodes.addElement((Document)next);
                }
                next = tw.getNext();
            }
        }
        catch (SAXException se) {
        }
        catch (IOException ioe) {
            throw new ParseException("Neither this XML document's public nor system id's could be resolved: " + ioe + " " + ioe.getMessage() + "\n on parsing the doucment corresponding to " + type);
        }
        catch (ParserConfigurationException pce) {
            // empty catch block
        }
        return nodes;
    }

    public static Vector getNodesByType(Class type, Dictionary nodeToClassMap, InputStream is, EntityResolver er) throws Throwable {
        Vector<XmlDocument> nodes = new Vector<XmlDocument>();
        SimpleElementFactory elementFactory = new SimpleElementFactory();
        elementFactory.addMapping(nodeToClassMap, XMLUtils.class.getClassLoader());
        XmlDocumentBuilder builder = new XmlDocumentBuilder();
        builder.setIgnoringLexicalInfo(true);
        builder.setElementFactory((ElementFactory)elementFactory);
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setValidating(validatingParse);
        XMLReader parser = spf.newSAXParser().getXMLReader();
        parser.setFeature("http://xml.org/sax/features/validation", false);
        if (parser instanceof XMLParser) {
            ((XMLParser)parser).setAttribute("oracle.xml.parser.XMLParser.Standalone", (Object)new Boolean(true));
        }
        String lexHandler = "http://xml.org/sax/properties/lexical-handler";
        parser.setProperty(lexHandler, builder);
        XMLValidationHandler dh = null;
        try {
            dh = new XMLValidationHandler(false);
        }
        catch (Exception edh) {
            edh.printStackTrace(System.out);
        }
        parser.setEntityResolver(er);
        parser.setErrorHandler(dh);
        parser.setContentHandler((ContentHandler)builder);
        try {
            parser.parse(new InputSource(is));
        }
        catch (UnknownHostException uhe) {
            throw new ParseException("Neither this XML document's public nor system id's could be resolved: " + uhe + " " + uhe.getMessage() + "\n on parsing the doucment corresponding to " + type);
        }
        XmlDocument document = builder.getDocument();
        TreeWalker tw = new TreeWalker((Node)document);
        Object next = document;
        while (next != null) {
            if (type.isInstance(next)) {
                nodes.addElement((XmlDocument)next);
            }
            next = tw.getNext();
        }
        return nodes;
    }

    public static String getAbsoluteFilenameURLForDTD(String dtdFilename) throws Exception {
        String j2ee13 = FileUtil.getAbsolutePath("lib/dtds");
        File f = new File(j2ee13 + File.separator + dtdFilename);
        return f.toURL().toString();
    }

    static {
        String validation = null;
        try {
            Properties config = Utility.getPropertiesFromFile("default.properties");
            validation = config.getProperty("validating.parser");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        validatingParse = "true".equals(validation);
    }
}

