/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.ContainerTransaction;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleArchivist;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.Hashtable;
import java.util.Vector;

public final class EjbSessionDescriptor
extends EjbDescriptor {
    private boolean isStateless = false;
    private int timeout = 0;
    public static String TYPE = "Session";
    public static String STATELESS = "Stateless";
    public static String STATEFUL = "Stateful";
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$deployment$EjbSessionDescriptor == null ? (class$com$sun$enterprise$deployment$EjbSessionDescriptor = EjbSessionDescriptor.class$("com.sun.enterprise.deployment.EjbSessionDescriptor")) : class$com$sun$enterprise$deployment$EjbSessionDescriptor);
    static /* synthetic */ Class class$com$sun$enterprise$deployment$EjbSessionDescriptor;
    static /* synthetic */ Class class$javax$ejb$SessionSynchronization;

    public EjbSessionDescriptor() {
    }

    public EjbSessionDescriptor(EjbDescriptor other) {
        super(other);
        if (other instanceof EjbSessionDescriptor) {
            EjbSessionDescriptor session = (EjbSessionDescriptor)other;
            this.isStateless = session.isStateless;
            this.timeout = session.timeout;
        }
    }

    public String getType() {
        return TYPE;
    }

    public String getSessionTypeString() {
        if (this.isStateless()) {
            return STATELESS;
        }
        return STATEFUL;
    }

    public void setSessionTypeString(String sessionType) {
        if (STATELESS.equals(sessionType)) {
            this.setStateless(true);
            return;
        }
        if (STATEFUL.equals(sessionType)) {
            this.setStateless(false);
            return;
        }
        if (Descriptor.isBoundsChecking()) {
            throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptionsessiontypenotlegaltype", "{0} is not a legal session type for session ejbs. The type must be {1} or {2}", new Object[]{sessionType, STATEFUL, STATELESS}));
        }
    }

    public void setType(String type) {
        throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptioncannotsettypeofsessionbean", "Cannot set the type of a session bean"));
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTransactionType(String transactionType) {
        boolean isValidType;
        boolean bl = isValidType = EjbDescriptor.BEAN_TRANSACTION_TYPE.equals(transactionType) || EjbDescriptor.CONTAINER_TRANSACTION_TYPE.equals(transactionType);
        if (!isValidType && Descriptor.isBoundsChecking()) {
            throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment..exceptointxtypenotlegaltype", "{0} is not a legal transaction type for session beans", new Object[]{transactionType}));
        }
        this.transactionType = transactionType;
        super.setMethodContainerTransactions(new Hashtable());
        super.changed();
    }

    public boolean isStateless() {
        return this.isStateless;
    }

    public boolean isStateful() {
        return !this.isStateless();
    }

    public void setStateless(boolean isStateless) {
        this.isStateless = isStateless;
        super.changed();
    }

    public Vector getPossibleTransactionAttributes() {
        Vector<ContainerTransaction> txAttributes = super.getPossibleTransactionAttributes();
        if (this.isStateful()) {
            try {
                Class sessionSynchClass;
                EjbBundleDescriptor ejbBundle = this.getEjbBundleDescriptor();
                EjbBundleArchivist archivist = (EjbBundleArchivist)ejbBundle.getArchivist();
                ClassLoader classLoader = archivist.getClassLoader();
                Class<?> ejbClass = classLoader.loadClass(this.getEjbClassName());
                Class clazz = sessionSynchClass = class$javax$ejb$SessionSynchronization == null ? (class$javax$ejb$SessionSynchronization = EjbSessionDescriptor.class$("javax.ejb.SessionSynchronization")) : class$javax$ejb$SessionSynchronization;
                if (sessionSynchClass.isAssignableFrom(ejbClass)) {
                    txAttributes = new Vector<ContainerTransaction>();
                    txAttributes.add(new ContainerTransaction(ContainerTransaction.REQUIRED, ""));
                    txAttributes.add(new ContainerTransaction(ContainerTransaction.REQUIRES_NEW, ""));
                    txAttributes.add(new ContainerTransaction(ContainerTransaction.MANDATORY, ""));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return txAttributes;
    }

    public String toString() {
        String s = super.toString();
        s = s + "Session descriptor";
        s = s + "\n isStateless " + this.isStateless;
        return s;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

