/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.ejbql;

import com.sun.ejb.ejbql.Expression;
import com.sun.ejb.ejbql.OperatorBase;
import com.sun.ejb.ejbql.OperatorExpression;
import com.sun.ejb.ejbql.Visitor;
import java.util.Iterator;
import java.util.Vector;

public abstract class NaryOperator
extends OperatorBase {
    public static final NaryOperator LIKE = new Like(false);
    public static final NaryOperator NOT_LIKE = new Like(true);
    public static final NaryOperator AND = new And();
    public static final NaryOperator OR = new Or();
    public static final NaryOperator BETWEEN = new Between(false);
    public static final NaryOperator NOT_BETWEEN = new Between(true);
    public static final NaryOperator LOCATE = new Locate();
    public static final NaryOperator SUBSTRING = new Substring();
    public static final NaryOperator STRING_AGGREGATOR = new StringAggregator();

    public boolean isNary() {
        return true;
    }

    public String getResultType(Vector expressions) {
        if (!this.operatesOn(expressions)) {
            throw new IllegalArgumentException("Wrong expr type");
        }
        return BOOLEAN_OBJECT_TYPE_NAME;
    }

    protected Iterator buildPrintStrings(String printString, int num) {
        Vector<String> printStrings = new Vector<String>();
        for (int i = 0; i < num; ++i) {
            printStrings.add(printString);
        }
        return printStrings.iterator();
    }

    private static class StringAggregator
    extends NaryOperator {
        private StringAggregator() {
        }

        public boolean operatesOn(Vector expressions) {
            boolean accepted = true;
            Iterator iter = expressions.iterator();
            while (iter.hasNext()) {
                Expression next = (Expression)iter.next();
                if (StringAggregator.hasStringType(next)) continue;
                accepted = false;
                break;
            }
            return accepted;
        }

        public String getResultType(Vector expressions) {
            return STRING_TYPE_NAME;
        }

        public boolean isFunction() {
            return true;
        }

        public Iterator getPrintStrings(Vector expressions) {
            return this.buildPrintStrings("", 1);
        }
    }

    private static class Substring
    extends NaryOperator {
        private Substring() {
        }

        public boolean operatesOn(Vector expressions) {
            Expression expr1 = (Expression)expressions.elementAt(0);
            Expression expr2 = (Expression)expressions.elementAt(1);
            Expression expr3 = (Expression)expressions.elementAt(2);
            return Substring.hasStringType(expr1) && expr2.getJavaType().equals(INTEGER_PRIMITIVE_TYPE_NAME) && expr3.getJavaType().equals(INTEGER_PRIMITIVE_TYPE_NAME);
        }

        public String getResultType(Vector expressions) {
            return STRING_TYPE_NAME;
        }

        public boolean isFunction() {
            return true;
        }

        public Iterator getPrintStrings(Vector expressions) {
            return this.buildPrintStrings("SUBSTRING", 1);
        }
    }

    private static class Locate
    extends NaryOperator {
        private Locate() {
        }

        public boolean operatesOn(Vector expressions) {
            boolean accepted = false;
            Expression expr1 = (Expression)expressions.elementAt(0);
            Expression expr2 = (Expression)expressions.elementAt(1);
            boolean bl = accepted = Locate.hasStringType(expr1) && Locate.hasStringType(expr2);
            if (accepted && expressions.size() == 3) {
                Expression expr3 = (Expression)expressions.elementAt(2);
                accepted = expr3.getJavaType().equals(INTEGER_PRIMITIVE_TYPE_NAME);
            }
            return accepted;
        }

        public String getResultType(Vector expressions) {
            return INTEGER_PRIMITIVE_TYPE_NAME;
        }

        public boolean isFunction() {
            return true;
        }

        public Iterator getPrintStrings(Vector expressions) {
            return this.buildPrintStrings("LOCATE", 1);
        }
    }

    private static class Between
    extends NaryOperator {
        private boolean not_;

        public Between(boolean not) {
            this.not_ = not;
        }

        public void acceptOperatorExpression(Visitor visitor, OperatorExpression operatorExpr) {
            visitor.visitBetweenExpression(operatorExpr);
        }

        public boolean operatesOn(Vector expressions) {
            Expression expr1 = (Expression)expressions.elementAt(0);
            Expression expr2 = (Expression)expressions.elementAt(1);
            Expression expr3 = (Expression)expressions.elementAt(2);
            return Between.hasNumericType(expr1) && Between.hasNumericType(expr2) && Between.hasNumericType(expr3);
        }

        public Iterator getPrintStrings(Vector expressions) {
            Vector<String> printStrings = new Vector<String>();
            printStrings.add(this.not_ ? "NOT BETWEEN" : "BETWEEN");
            printStrings.add("AND");
            return printStrings.iterator();
        }
    }

    private static class Like
    extends NaryOperator {
        private boolean not_;

        public Like(boolean not) {
            this.not_ = not;
        }

        public void acceptOperatorExpression(Visitor visitor, OperatorExpression operatorExpr) {
            visitor.visitLikeExpression(operatorExpr);
        }

        public boolean operatesOn(Vector expressions) {
            boolean accepted = true;
            Iterator iter = expressions.iterator();
            while (iter.hasNext()) {
                Expression next = (Expression)iter.next();
                if (Like.hasStringType(next)) continue;
                accepted = false;
                break;
            }
            return accepted;
        }

        public Iterator getPrintStrings(Vector expressions) {
            Vector<String> printStrings = new Vector<String>();
            printStrings.add(this.not_ ? "NOT LIKE" : "LIKE");
            if (expressions.size() == 3) {
                printStrings.add("ESCAPE");
            }
            return printStrings.iterator();
        }
    }

    private static class Or
    extends NaryOperator {
        private Or() {
        }

        public boolean operatesOn(Vector expressions) {
            Iterator iter = expressions.iterator();
            while (iter.hasNext()) {
                Expression next = (Expression)iter.next();
                if (Or.hasBooleanType(next)) continue;
                return false;
            }
            return true;
        }

        public Iterator getPrintStrings(Vector expressions) {
            return this.buildPrintStrings("OR", expressions.size() - 1);
        }
    }

    private static class And
    extends NaryOperator {
        private And() {
        }

        public boolean operatesOn(Vector expressions) {
            Iterator iter = expressions.iterator();
            while (iter.hasNext()) {
                Expression next = (Expression)iter.next();
                if (And.hasBooleanType(next)) continue;
                return false;
            }
            return true;
        }

        public Iterator getPrintStrings(Vector expressions) {
            return this.buildPrintStrings("AND", expressions.size() - 1);
        }
    }
}

