/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jgroups;

import EDU.oswego.cs.dl.util.concurrent.ReentrantWriterPreferenceReadWriteLock;
import EDU.oswego.cs.dl.util.concurrent.Sync;

public class TestAndWaitLock {
    protected String name;
    private final ReentrantWriterPreferenceReadWriteLock readWriteLock = new ReentrantWriterPreferenceReadWriteLock();
    protected final Sync readLock = this.readWriteLock.readLock();
    private final Sync writeLock = this.readWriteLock.writeLock();
    private final Object freezeLock = new Object();

    public TestAndWaitLock(String name) {
        this.name = name;
    }

    public TestAndWaitLock() {
        this("unamed");
    }

    public void acquire() throws InterruptedException {
        if (Thread.holdsLock(this.freezeLock)) {
            return;
        }
        this.doAcquire();
    }

    protected void doAcquire() throws InterruptedException {
        this.readLock.acquire();
    }

    public boolean attempt(long msecs) throws InterruptedException {
        if (Thread.holdsLock(this.freezeLock)) {
            return true;
        }
        return this.doAttempt(msecs);
    }

    protected boolean doAttempt(long msecs) throws InterruptedException {
        return this.readLock.attempt(msecs);
    }

    public void release() {
        if (Thread.holdsLock(this.freezeLock)) {
            return;
        }
        this.doRelease();
    }

    protected void doRelease() {
        this.readLock.release();
    }

    public synchronized Object freeze() throws InterruptedException {
        this.writeLock.acquire();
        return this.freezeLock;
    }

    public void thaw() {
        this.writeLock.release();
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }
}

