/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.xml;

import com.evermind.xml.BasicEntityResolver;
import com.evermind.xml.ConfiguredEntityResolver;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.logging.Logger;
import oracle.j2ee.xml.XMLMessages;
import org.xml.sax.SAXException;

public class EntityResolverUtil {
    private static final String ENTITY_RESOLVER_CONFIG_FILE = "entity-resolver-config.xml";
    private static final String CWD = "user.dir";
    private static Logger LOGGER = Logger.getLogger("com.evermind.xml.EntityResolverUtil");
    private static ConfiguredEntityResolver m_ConfiguredEntityResolver;

    static synchronized void clearSingleton() {
        m_ConfiguredEntityResolver = null;
    }

    public static synchronized boolean init(String configDirName) {
        boolean retVal = false;
        if (m_ConfiguredEntityResolver == null) {
            String entityResolverConfigFile = configDirName + File.separator + ENTITY_RESOLVER_CONFIG_FILE;
            if (new File(entityResolverConfigFile).canRead()) {
                retVal = EntityResolverUtil.createEntityResolver(entityResolverConfigFile);
            } else {
                entityResolverConfigFile = System.getProperty(CWD) + File.separator + "config" + File.separator + ENTITY_RESOLVER_CONFIG_FILE;
                retVal = EntityResolverUtil.createEntityResolver(entityResolverConfigFile);
            }
        }
        if (m_ConfiguredEntityResolver == null) {
            EntityResolverUtil.initDefault();
        }
        return retVal;
    }

    private static boolean createEntityResolver(String entityResolverConfigFile) {
        boolean retVal = false;
        if (new File(entityResolverConfigFile).canRead()) {
            m_ConfiguredEntityResolver = new ConfiguredEntityResolver(entityResolverConfigFile);
            XMLMessages.finerCreatedEntityResolver(entityResolverConfigFile);
            retVal = true;
        }
        return retVal;
    }

    public static ConfiguredEntityResolver getConfiguredEntityResolver() {
        return m_ConfiguredEntityResolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized boolean initDefault() {
        InputStream stream;
        URL url;
        boolean retVal;
        block10: {
            String resource;
            retVal = false;
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            url = loader.getResource(resource = "META-INF/entity-resolver-config.xml");
            if (url == null) return retVal;
            stream = null;
            stream = url.openStream();
            if (stream == null) break block10;
            m_ConfiguredEntityResolver = new ConfiguredEntityResolver(BasicEntityResolver.parse(stream, url.toExternalForm()));
            retVal = true;
            XMLMessages.finerCreatedEntityResolverFromClasspath(url.toExternalForm());
        }
        Object var7_5 = null;
        if (stream == null) return retVal;
        try {
            stream.close();
            return retVal;
        }
        catch (IOException e2) {
            XMLMessages.finestIOEClosingEntityResolverConfigStream(e2, url);
        }
        return retVal;
        {
            catch (IOException e) {
                XMLMessages.configIOEInEntityResolverConfig(url, e);
                Object var7_6 = null;
                if (stream == null) return retVal;
                try {
                    stream.close();
                    return retVal;
                }
                catch (IOException e2) {
                    XMLMessages.finestIOEClosingEntityResolverConfigStream(e2, url);
                }
                return retVal;
            }
            catch (SAXException e) {
                XMLMessages.configSAXEInEntityResolverConfig(url, e);
                Object var7_7 = null;
                if (stream == null) return retVal;
                try {
                    stream.close();
                    return retVal;
                }
                catch (IOException e2) {
                    XMLMessages.finestIOEClosingEntityResolverConfigStream(e2, url);
                }
                return retVal;
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (stream == null) throw throwable;
            try {
                stream.close();
                throw throwable;
            }
            catch (IOException e2) {
                XMLMessages.finestIOEClosingEntityResolverConfigStream(e2, url);
            }
            throw throwable;
        }
    }
}

