/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.util;

import com.evermind.util.DelegatingClassLoader;
import com.evermind.util.ThreadPool;

public class ThreadPoolThread
extends Thread {
    ThreadPool _pool;
    long lastUsed;
    boolean disable = false;
    int threadsRunning;
    protected long _id;
    private boolean isDelegatingLoader;

    public ThreadPoolThread(ThreadPool pool, String name, boolean daemon) {
        super(pool.getThreadGroup(), name);
        this._pool = pool;
        if (daemon) {
            this.setDaemon(true);
        }
        this.initContextClassLoader();
    }

    public ThreadPoolThread(ThreadPool pool, Runnable runnable, String name, boolean daemon, long stackSize) {
        super(pool != null ? pool.getThreadGroup() : null, runnable, name, stackSize);
        this._pool = pool;
        if (daemon) {
            this.setDaemon(true);
        }
        this.initContextClassLoader();
    }

    protected ThreadPoolThread(ThreadPool pool, Runnable runnable, String name, ThreadGroup group, long stackSize) {
        super(group, runnable, name, stackSize);
        this._pool = pool;
        this.initContextClassLoader();
    }

    public void setContextClassLoader(ClassLoader cl) {
        super.setContextClassLoader(cl);
        this.initContextClassLoader();
    }

    private void initContextClassLoader() {
        ClassLoader cl = super.getContextClassLoader();
        this.isDelegatingLoader = cl instanceof DelegatingClassLoader;
    }

    public ClassLoader getResettableContextClassLoader() {
        return super.getContextClassLoader();
    }

    public ClassLoader getContextClassLoader() {
        ClassLoader loader = super.getContextClassLoader();
        if (this.isDelegatingLoader) {
            try {
                loader = ((DelegatingClassLoader)((Object)loader)).getDelegatedLoader();
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return loader;
    }

    public long getInternalId() {
        return this._id;
    }

    public void setInternalId(long id) {
        this._id = id;
    }
}

