/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.util;

import com.evermind.xml.XMLUtils;
import com.evermind.xml.XMLizable;
import java.io.PrintWriter;
import java.util.Properties;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LoggerConfiguration
implements XMLizable {
    private boolean initialized;
    private String className;
    private Properties properties;

    public LoggerConfiguration(Node parent) throws InstantiationException {
        this.className = XMLUtils.getNodeAttribute(parent, "class");
        if (this.className == null) {
            throw new InstantiationException("logger tag with missing class attribute");
        }
        NodeList list = parent.getChildNodes();
        if (list != null) {
            for (int i = 0; i < list.getLength(); ++i) {
                String value;
                String propertyName;
                Node node = list.item(i);
                String name = node.getNodeName();
                if (name.equals("property")) {
                    propertyName = XMLUtils.getNodeAttribute(node, "name");
                    value = XMLUtils.getNodeAttribute(node, "value");
                    if (name == null) {
                        throw new InstantiationException("property tag with missing name attribute");
                    }
                    if (value == null) {
                        throw new InstantiationException("property tag '" + propertyName + "' is missing a value attribute");
                    }
                } else {
                    throw new InstantiationException("Unknown logger subtag: " + name);
                }
                this.addProperty(propertyName, value);
            }
        }
    }

    public String getClassName() {
        return this.className;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void addProperty(String name, String value) {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        this.properties.put(name, value);
    }

    public void writeXML(PrintWriter out, String indention) {
        out.println(indention + "<logger class=\"" + XMLUtils.encode(this.className) + "\">");
        if (this.properties != null) {
            XMLUtils.writeCompressedMap(this.properties, "property", out, "name", "value", indention + "\t");
        }
        out.println(indention + "</logger>");
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }
}

