/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.util;

import com.evermind.util.ByteString;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class ByteStringTokenizer
implements Enumeration {
    private static final byte[] SPACE_DELIMETER = " ".getBytes();
    private byte[] data;
    private int start;
    private int end;
    private byte[] delimeterData;
    private int delimeterStart;
    private int delimeterEnd;
    private ByteString token;

    public ByteStringTokenizer(ByteString string) {
        this(string, SPACE_DELIMETER);
    }

    public ByteStringTokenizer(ByteString string, ByteString delimeter) {
        this(string.data, string.offset, string.length, delimeter.data, delimeter.offset, delimeter.length);
    }

    public ByteStringTokenizer(ByteString string, byte[] delimeter) {
        this(string.data, string.offset, string.length, delimeter, 0, delimeter.length);
    }

    public ByteStringTokenizer(byte[] string, byte[] delimeter) {
        this(string, 0, string.length, delimeter, 0, delimeter.length);
    }

    public ByteStringTokenizer(byte[] string, ByteString delimeter) {
        this(string, 0, string.length, delimeter.data, delimeter.offset, delimeter.length);
    }

    private ByteStringTokenizer(byte[] data, int offset, int length, byte[] delimeterData, int delimeterOffset, int delimeterLength) {
        this.data = data;
        this.start = offset;
        this.end = offset + length;
        this.delimeterData = delimeterData;
        this.delimeterStart = delimeterOffset;
        this.delimeterEnd = delimeterOffset + delimeterLength;
        if (length > 0) {
            this.registerNextToken();
        }
    }

    public ByteString nextToken() {
        if (this.token == null) {
            throw new NoSuchElementException();
        }
        ByteString token = this.token;
        this.registerNextToken();
        return token;
    }

    public void registerNextToken() {
        byte[] data = this.data;
        byte[] delimeterData = this.delimeterData;
        if (this.start >= this.end) {
            this.token = null;
            return;
        }
        for (int i = this.delimeterStart; i < this.delimeterEnd; ++i) {
            if (data[this.start] != delimeterData[i]) continue;
            ++this.start;
            i = -1;
            if (this.start < this.end) continue;
            this.token = null;
            return;
        }
        if (this.start < this.end) {
            int chunkStart = this.start++;
            while (this.start < this.end) {
                for (int i = this.delimeterStart; i < this.delimeterEnd; ++i) {
                    if (data[this.start] != delimeterData[i]) continue;
                    this.token = new ByteString(data, chunkStart, this.start - chunkStart);
                    ++this.start;
                    return;
                }
                ++this.start;
            }
            this.token = new ByteString(data, chunkStart, this.start - chunkStart);
            ++this.start;
            return;
        }
        this.token = null;
    }

    public boolean hasMoreTokens() {
        return this.token != null;
    }

    public boolean hasMoreElements() {
        return this.token != null;
    }

    public Object nextElement() {
        return this.nextToken();
    }
}

