/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.rmi;

import com.evermind.server.rmi.RMILocation;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import javax.naming.NamingException;
import oracle.oc4j.rmi.ClientRmiTransport;
import oracle.oc4j.rmi.tunnelling.TunnelledRmiTransport;

class TunnelledRmiLocation
extends RMILocation {
    private String m_url;

    static boolean isTunnelingUrl(String protocol, String details) {
        return protocol.equals("ormi") && details.startsWith("http") && details.indexOf("://") > 0;
    }

    TunnelledRmiLocation(RMILocation.DnsClient dnsClient, String details) throws NamingException {
        super(dnsClient);
        try {
            this.m_url = details;
            URL url = new URL(details);
            this.secure = url.getProtocol().equals("https");
            this.urlInstance = url.getHost();
            if (this.urlInstance == null || this.urlInstance.length() == 0) {
                throw new NamingException("Illegal ormi tunneling location: host not specified");
            }
            String path = url.getPath();
            if (!path.endsWith("/")) {
                path = path + '/';
            }
            this.application = this.getApplication(path);
            this.m_url = new URL(url, TunnelledRmiTransport.getRequestPath(this.application)).toExternalForm();
        }
        catch (MalformedURLException e) {
            NamingException ne = new NamingException("Illegal ormi tunneling location");
            ne.setRootCause(e);
            throw ne;
        }
    }

    private String getApplication(String path) throws NamingException {
        StringTokenizer st = new StringTokenizer(path, "/");
        if (!st.hasMoreTokens()) {
            return null;
        }
        if (st.countTokens() > 1) {
            throw new NamingException("Illegal ormi tunneling location: format is ormi:http[s]://host[:port]/[app-name]");
        }
        String token = st.nextToken();
        return token.equals("default") ? null : token;
    }

    protected int getDefaultPort() {
        throw new RuntimeException("Should never ask for default port for a tunneling location");
    }

    protected ClientRmiTransport getTransport() throws UnknownHostException, MalformedURLException {
        return ClientRmiTransport.createTunnelledTransport(this.m_url);
    }
}

