/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.rmi;

import com.evermind.io.IOUtils;
import com.evermind.net.AccessRegionSet;
import com.evermind.net.NetworkConnection;
import com.evermind.net.SocketNetworkConnection;
import com.evermind.security.User;
import com.evermind.security.UserManager;
import com.evermind.server.Application;
import com.evermind.server.ApplicationServer;
import com.evermind.server.ExecutionContext;
import com.evermind.server.SubjectPropagationInterceptor;
import com.evermind.server.SubordinateXAResource;
import com.evermind.server.ThreadState;
import com.evermind.server.administration.ApplicationClientConnector;
import com.evermind.server.administration.ApplicationServerAdministrator;
import com.evermind.server.administration.DefaultApplicationServerAdministrator;
import com.evermind.server.administration.ResourceFinder;
import com.evermind.server.cluster.ServerIdentification;
import com.evermind.server.rmi.JndiNamespaceReplicationService;
import com.evermind.server.rmi.RMIBinding;
import com.evermind.server.rmi.RMIClient;
import com.evermind.server.rmi.RMIClientContext;
import com.evermind.server.rmi.RMIContext;
import com.evermind.server.rmi.RMIInterceptor;
import com.evermind.server.rmi.RMILocation;
import com.evermind.server.rmi.RMILoginFailedException;
import com.evermind.server.rmi.RMIProtocol;
import com.evermind.server.rmi.RMIServerApplicationThreadMediator;
import com.evermind.server.rmi.RMIServerConfig;
import com.evermind.server.rmi.RMIServerConnection;
import com.evermind.server.rmi.RMIServerContext;
import com.evermind.server.rmi.RMIServerInfo;
import com.evermind.server.rmi.RMIServerThreadMediator;
import com.evermind.server.rmi.ServerRmiMessageHandler;
import com.evermind.ssl.SSLConfig;
import com.evermind.util.ServerProperties;
import com.evermind.util.ThreadPool;
import com.oracle.bricks.Manager;
import com.oracle.bricks.SessionManagerFactory;
import com.oracle.naming.LookupFactory;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLServerSocket;
import oracle.j2ee.rmi.RMIInitialContextFactory;
import oracle.j2ee.rmi.RMIMessages;
import oracle.j2ee.util.TraceLogger;
import oracle.oc4j.rmi.ClientRmiTransport;
import oracle.oc4j.rmi.LocalClientRmiTransport;
import oracle.oc4j.rmi.OracleRemoteException;
import oracle.oc4j.rmi.interceptors.IdentityPropagationInterceptor;
import oracle.oc4j.security.OC4JSecurity;
import oracle.oc4j.transaction.TransactionInterceptor;
import oracle.oc4j.util.LRUMap;

public class RMIServer
extends RMIClient {
    static final int DEFAULT_SOCKET_BACKLOG = 30;
    public static final int IDLE_TIMEOUT = 0;
    private static int configCount_ = 0;
    private static Logger m_logger = TraceLogger.getLogger(RMIServer.class);
    public static final InetAddress LOCAL_ADDRESS = RMIServer.getLocalAddress();
    private final ApplicationServer m_appServer;
    private boolean initialized = false;
    private RMIServerConfig config;
    private ServerSocket socket;
    private SSLServerSocket sslSocket;
    private InetAddress address;
    private int port = -1;
    private int sslPort = -1;
    private boolean alive = true;
    private boolean m_stopped = false;
    private List serverConnections = new ArrayList();
    private boolean local = false;
    private RMIServerThreadMediator m_threadMediator = new RMIServerApplicationThreadMediator();
    private JndiNamespaceReplicationService clusterManager;
    private boolean notLaunched_ = true;
    private UserManager userManager = null;
    private Listener nonSecureListener;
    private Listener secureListener;
    private Exception lastCaughtException;
    private RMIContext defaultContext;
    private Map contexts = new HashMap();
    private final LRUMap m_rawConnectionsLRUMap = new LRUMap();
    private final Map m_connectionsLRUMap = Collections.synchronizedMap(this.m_rawConnectionsLRUMap);

    public RMIServer(ApplicationServer server) {
        this(server, new RMIInterceptor[]{new TransactionInterceptor(), new IdentityPropagationInterceptor(), new SubjectPropagationInterceptor()});
    }

    protected RMIServer(ApplicationServer server, RMIInterceptor[] interceptors) {
        super(interceptors);
        this.m_appServer = server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RMIServer getInstance(ApplicationServer appServer) {
        OC4JSecurity.assertIsSafe();
        Class clazz = RMIClient.class;
        synchronized (clazz) {
            if (instance != null && !(instance instanceof RMIServer)) {
                throw new IllegalStateException("Singleton instance " + instance + " is not an RMIServer");
            }
            if (instance == null) {
                instance = new RMIServer(appServer);
            }
            return (RMIServer)instance;
        }
    }

    public void publishRemoteServers(RMIContext context, ResourceFinder resourceFinder, ApplicationClientConnector applicationClientConnector) throws NamingException {
        context.rebind("java:comp/ResourceFinder", resourceFinder, 0);
        context.rebind("oc4j:internal/ResourceFinder", LookupFactory.createBinding(ResourceFinder.class, "java:comp/ResourceFinder"), 0);
        context.rebind("java:comp/ApplicationClientConnector", applicationClientConnector, 0);
    }

    public static RMIServer newLocalServer(ApplicationServer appServer) {
        OC4JSecurity.assertIsSafe();
        RMIServer server = new RMIServer(appServer);
        server.local = true;
        return server;
    }

    protected void bindDfltCntxtServerAdmin(ApplicationServerAdministrator serverAdministrator) throws NamingException {
        this.getDefaultContext().rebind("java:comp/ServerAdministrator", serverAdministrator, 0);
    }

    protected void bindDfltCntxtSubXAResource(SubordinateXAResource serverXaResource) throws NamingException {
        this.getDefaultContext().rebind("oc4j:internal/serverXAResource", serverXaResource, 0);
    }

    public void publishServerAdministrator(ApplicationServer server) {
        try {
            this.bindDfltCntxtServerAdmin(new DefaultApplicationServerAdministrator(server));
        }
        catch (NamingException e) {
            super.log("Severe error: unable to register ServerAdministrator", e);
        }
    }

    public void publishSubordinateXAResource(SubordinateXAResource serverXaResource) {
        try {
            this.bindDfltCntxtSubXAResource(serverXaResource);
        }
        catch (NamingException e) {
            super.log("Severe error: unable to register SubordinateXAResource", e);
        }
    }

    public int getMaxServerSockets() {
        return this.getConfig().getMaxServerSockets();
    }

    public int getCurrentServerSockets() {
        return this.m_connectionsLRUMap.size();
    }

    public void setConfig(RMIServerConfig config) throws InstantiationException {
        try {
            super.setConfig(config);
            this.initialized = false;
            this.config = config;
            this.m_rawConnectionsLRUMap.setMaxSize(this.getMaxServerSockets());
            if (this.port == -1) {
                this.setLocation(config.getAddress(), config.getPort(), config.getSslPort());
            }
            List nodes = config.getNodes();
            for (int i = 0; i < nodes.size(); ++i) {
                RMIServerInfo node = (RMIServerInfo)nodes.get(i);
                if (this.isAtLocation(node.address, node.port)) continue;
                Hashtable<String, String> environment = new Hashtable<String, String>();
                environment.put("java.naming.provider.url", node.getOrmiUrl());
                this.addNewConnection(ClientRmiTransport.createDirectTransport(node.address, node.port, node.secure), node.username, node.password, this.getContext(environment));
            }
            this.createNonSecureSocket(config);
            this.createSecureSocket(config);
            ++configCount_;
            if (this.notLaunched_) {
                m_logger.log(Level.FINER, "Launching RMIServer threads");
                this.launchNonSecureListener();
                this.launchSecureServerListener();
                this.notLaunched_ = false;
            } else {
                this.ready();
            }
        }
        catch (NamingException e) {
            throw new InstantiationException(e.toString());
        }
    }

    public void stop(String reason) {
        this.m_stopped = true;
        this.disconnectRMIConnections(this.serverConnections, reason);
    }

    AccessRegionSet getAccessRegionSet() {
        if (null == this.getConfig()) {
            return null;
        }
        return this.getConfig().getAccessRegionSet();
    }

    public synchronized void unsetContext(String domain, boolean dedicated) throws NamingException {
        RMIContext ctx;
        if (!dedicated && this.defaultContext != (ctx = (RMIContext)this.contexts.remove(domain))) {
            this.defaultContext.unbind(domain);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeContext(RMIContext context, String reason) {
        super.closeContext(context, reason);
        List list = this.serverConnections;
        synchronized (list) {
            Iterator iterator = this.serverConnections.iterator();
            while (iterator.hasNext()) {
                RMIServerConnection connection = (RMIServerConnection)iterator.next();
                connection.closeContext(context, reason);
            }
        }
    }

    RMIClientContext createLocalClientContext(Map environment) throws NamingException {
        if (RMIContext.isGlobalJNDILookupEnabled()) {
            String domain = RMIServer.getLocalClientDomain(environment);
            return new LocalRmiClientContext(this, domain, environment);
        }
        throw new NamingException("ORMI Local Client Context creation not allowed when Global Lookup is not enabled");
    }

    private void launchNonSecureListener() {
        if (null != this.getSocket()) {
            this.nonSecureListener = new Listener(this, new ListenerConfig(){

                public int getPort() {
                    return RMIServer.this.getPort();
                }

                public ServerSocket getServerSocket() {
                    return RMIServer.this.getSocket();
                }

                public String getName() {
                    return "ormi listener";
                }
            });
            this.getConnectionThreadPool().launch(this.nonSecureListener);
        }
    }

    private void launchSecureServerListener() {
        if (null != this.getSslSocket()) {
            this.secureListener = new Listener(this, new ListenerConfig(){

                public int getPort() {
                    return RMIServer.this.getSslPort();
                }

                public ServerSocket getServerSocket() {
                    return RMIServer.this.getSslSocket();
                }

                public String getName() {
                    return "ormis listener";
                }
            });
            this.getConnectionThreadPool().launch(this.secureListener);
        }
    }

    private void createNonSecureSocket(RMIServerConfig config) throws InstantiationException {
        if (config.getPort() < 0) {
            return;
        }
        if (this.socket != null && !this.isAtLocation(this.socket.getInetAddress(), this.socket.getLocalPort()) && this.local && !LOCAL_ADDRESS.equals(this.socket.getInetAddress())) {
            this.closeSocket(this.socket);
            this.socket = null;
        }
        try {
            if (this.socket == null) {
                this.socket = this.createServerSocket(config);
                if (config.getPort() == 0) {
                    this.port = this.socket.getLocalPort();
                    config.setPort(this.port);
                }
            }
        }
        catch (IOException e) {
            this.handleCreateServerSocketException(e, config.getPort());
        }
    }

    private void createSecureSocket(RMIServerConfig config) throws InstantiationException {
        if (config.getSslPort() < 0 || null == config.getSslConfig()) {
            return;
        }
        if (this.sslSocket != null && !this.isAtLocation(this.sslSocket.getInetAddress(), this.sslSocket.getLocalPort()) && this.local && !LOCAL_ADDRESS.equals(this.sslSocket.getInetAddress())) {
            this.closeSocket(this.sslSocket);
            this.sslSocket = null;
        }
        try {
            if (this.sslSocket == null) {
                this.sslSocket = (SSLServerSocket)this.createSslServerSocket(config);
                this.sslPort = this.sslSocket.getLocalPort();
                config.setSslPort(this.sslPort);
            }
        }
        catch (IOException e) {
            this.handleCreateServerSocketException(e, config.getSslPort());
        }
    }

    private void closeSocket(ServerSocket socket) {
        if (null == socket) {
            return;
        }
        try {
            m_logger.log(Level.FINE, "RMIServer.DEBUG: closing local RMIServer's socket " + socket);
            socket.close();
        }
        catch (IOException e) {
            RMIMessages.finerThrowable("Error closing socket: " + e.getMessage(), e);
        }
    }

    private void handleCreateServerSocketException(Exception e, int port) throws InstantiationException {
        this.lastCaughtException = e;
        String hostname = "localhost";
        try {
            hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException uhe) {
            // empty catch block
        }
        RMIMessages.severeUnableToCreateSocket(hostname, port, e);
        if (ServerProperties.getRunningInIAS()) {
            throw new InstantiationException(hostname + ":" + port + ", error: " + e.getMessage());
        }
        this.exit(7);
    }

    void exit(int statusCode) {
        OC4JSecurity.assertIsSafe();
        m_logger.log(Level.FINE, "RMIServer.DEBUG: exiting with code {0}", String.valueOf(statusCode));
        System.exit(statusCode);
    }

    private ServerSocket createServerSocket(RMIServerConfig config) throws IOException {
        InetAddress bindAddress = this.determineBindAddress();
        if (m_logger.isLoggable(Level.FINER)) {
            m_logger.log(Level.FINER, "creating RMIServer ServerSocket for address: " + bindAddress + " port: " + config.getPort());
        }
        return new ServerSocket(config.getPort(), 30, bindAddress);
    }

    private ServerSocket createSslServerSocket(RMIServerConfig config) throws IOException {
        SSLConfig sslConfig = config.getSslConfig();
        if (null == sslConfig || config.getSslPort() < 0) {
            return null;
        }
        InetAddress bindAddress = this.determineBindAddress();
        if (m_logger.isLoggable(Level.FINER)) {
            m_logger.log(Level.FINER, "creating RMIServer SSLServerSocket for address: " + bindAddress + " port: " + config.getSslPort());
        }
        return this.createSslServerSocket(sslConfig, bindAddress, config.getSslPort(), 30);
    }

    ServerSocket createSslServerSocket(SSLConfig sslConfig, InetAddress address, int port, int backlog) throws IOException {
        return sslConfig.createServerSocket(this.getClassLoader(), address, this.config.getSslPort(), 30);
    }

    private InetAddress determineBindAddress() throws IOException {
        InetAddress bindAddress = !this.local ? this.config.getAddress() : LOCAL_ADDRESS;
        return bindAddress;
    }

    private ClassLoader getClassLoader() {
        if (null != this.m_appServer && null != this.m_appServer.getDefaultApplication()) {
            return this.m_appServer.getDefaultApplication().getBeansClassLoader();
        }
        return this.getClass().getClassLoader();
    }

    void writePeerServerIdentifications(OutputStream outputStream, String applicationName) throws IOException {
        ServerIdentification[] peers = this.getKnownPeers(applicationName);
        IOUtils.writeCompressedInt(outputStream, peers == null ? 1 : peers.length + 1);
        if (peers != null) {
            for (int i = 0; i < peers.length; ++i) {
                peers[i].write(outputStream);
            }
        }
        new ServerIdentification(RMIServer.getLocalHostAddress().getHostAddress(), this.getConfig().getPort()).write(outputStream);
        outputStream.flush();
    }

    protected static InetAddress getLocalHostAddress() throws UnknownHostException {
        return InetAddress.getLocalHost();
    }

    protected ServerIdentification[] getKnownPeers(String applicationName) {
        Manager sessionManager;
        ServerIdentification[] peers = null;
        String groupName = this.m_appServer.getGroupName(applicationName);
        if (groupName != null && (sessionManager = SessionManagerFactory.getManager(groupName)) != null) {
            peers = sessionManager.getNonSecurePeers();
        }
        return peers;
    }

    void logError(String method, Exception e) {
        if (null != e) {
            this.lastCaughtException = e;
        }
        if (m_logger.isLoggable(Level.FINER)) {
            m_logger.log(Level.FINER, "RMIServer " + method + " exception: " + e);
        }
    }

    Exception getLastCaughtException() {
        return this.lastCaughtException;
    }

    public boolean isLiving() {
        return this.alive;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    private synchronized void waitForInitializationComplete() throws InitializationAborted {
        try {
            while (!this.isInitialized() && this.isLiving()) {
                if (this.m_appServer != null && !this.m_appServer.isAlive()) {
                    throw new InitializationAborted();
                }
                this.wait();
            }
        }
        catch (InterruptedException e) {
            throw new InitializationAborted();
        }
        this.notify();
    }

    public JndiNamespaceReplicationService getClusterManager() {
        return this.clusterManager;
    }

    public void setClusterManager(JndiNamespaceReplicationService clusterManager) {
        this.clusterManager = clusterManager;
    }

    void rebind(RMIContext context, String name, RMIBinding binding) throws RemoteException, NamingException {
        super.rebind(context, name, binding);
        if (binding.isDistributeToCluster()) {
            this.bindInCluster(context, name, binding);
        }
    }

    private void bindInCluster(RMIContext context, String name, RMIBinding binding) throws NamingException, OracleRemoteException {
        if (this.clusterManager == null) {
            return;
        }
        try {
            this.clusterManager.sendContextValueUpdate(context.getName(), name, binding);
        }
        catch (IOException e) {
            throw new OracleRemoteException("IO Error: Error sending to cluster: " + e.getMessage(), e);
        }
    }

    void unbind(RMIContext context, String name, int distribution) throws IOException, NamingException {
        super.unbind(context, name, distribution);
        if (RMIBinding.isDistributeToCluster(distribution)) {
            this.unbindFromCluster(context, name);
        }
    }

    private void unbindFromCluster(RMIContext context, String name) throws NamingException, OracleRemoteException {
        if (this.clusterManager == null) {
            return;
        }
        try {
            this.clusterManager.sendUnbind(context.getName(), name);
        }
        catch (IOException e) {
            throw new OracleRemoteException("IO Error: Error sending to cluster: " + e.getMessage(), e);
        }
    }

    void rename(RMIContext rmiContext, String oldname, String newname, RMIBinding binding, boolean remoteOnly) throws IOException, NamingException {
        if (!remoteOnly && binding.isDistributeToCluster()) {
            this.renameInCluster(rmiContext, oldname, newname);
        }
        super.rename(rmiContext, oldname, newname, binding, remoteOnly);
    }

    private void renameInCluster(RMIContext context, String oldName, String newName) {
        if (this.clusterManager == null) {
            return;
        }
        try {
            this.clusterManager.sendRename(context.getName(), oldName, newName);
        }
        catch (IOException ioException) {
            m_logger.log(Level.FINEST, "Error in sending Rename msg", ioException);
        }
        catch (NamingException namingException) {
            m_logger.log(Level.FINEST, "Error in sending Rename msg", namingException);
        }
    }

    public RMIServerContext getServerContext(String domain, boolean force) {
        try {
            this.getDefaultContext();
            if (domain == null || domain.equals("") || this.getDefaultApplicationDomain().equalsIgnoreCase(domain)) {
                return (RMIServerContext)this.getDefaultContext();
            }
            RMIServerContext context = (RMIServerContext)this.contexts.get(domain);
            if (context != null) {
                return context;
            }
            if (!force && this.isUndefinedDomain(domain)) {
                return null;
            }
            context = new RMIServerContext(this, domain);
            this.contexts.put(domain, context);
            this.onContextCreated(domain, context);
            return context;
        }
        catch (NullPointerException e) {
            m_logger.warning("RMIServer.getServerContext.NullPointerException: " + e.getMessage());
            e.printStackTrace();
            throw e;
        }
    }

    void connect(NetworkConnection connection) throws IOException, NamingException {
        AccessRegionSet accessRegionSet = this.getAccessRegionSet();
        if (this.m_stopped) {
            connection.close();
        } else if (null != accessRegionSet && !accessRegionSet.allow("ormi", connection.getInetAddress())) {
            OutputStream out = connection.getOutputStream();
            ObjectOutputStream objectOut = new ObjectOutputStream(out);
            objectOut.writeInt(20);
            objectOut.close();
            connection.close();
        } else {
            this.createRMIServerConnection(connection);
        }
    }

    RMIServerConnection createRMIServerConnection(NetworkConnection connection) throws IOException {
        RMIServerConnection handler = new RMIServerConnection(this, connection);
        handler.startConnection();
        this.m_connectionsLRUMap.put(handler, handler);
        handler.setLRUMapMembership(this.m_connectionsLRUMap);
        return handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHandler(RMIServerConnection handler) {
        List list = this.serverConnections;
        synchronized (list) {
            this.serverConnections.add(handler);
        }
    }

    public synchronized void ready() {
        this.initialized = true;
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy(String reason) {
        if (m_logger.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "RMIServer.DEBUG: in RMIServer.destroy(String reason) With reason: " + reason + " this: " + this);
        }
        RMIServer rMIServer = this;
        synchronized (rMIServer) {
            this.alive = false;
            if (instance == this) {
                instance = null;
            }
        }
        this.disconnectRMIConnections(this.serverConnections, reason);
        rMIServer = this;
        synchronized (rMIServer) {
            this.closeSocket(this.socket);
            this.socket = null;
            this.closeSocket(this.sslSocket);
            this.sslSocket = null;
            super.destroy(reason);
        }
    }

    int getPort() {
        return this.port;
    }

    int getSslPort() {
        return this.sslPort;
    }

    void setLocation(InetAddress address, int port, int sslPort) {
        this.port = port;
        this.sslPort = sslPort;
        this.address = address;
    }

    boolean isAtLocation(InetAddress address, int port) {
        return address.equals(this.address) && this.isListeningToPort(port);
    }

    boolean isListeningToPort(int port) {
        return port > 0 && (port == this.getPort() || port == this.getSslPort());
    }

    boolean isMatchingApplication(String targetApplicationName) {
        ThreadState threadState = ThreadState.getCurrentState();
        if (threadState != null && threadState.getContextContainer() != null) {
            try {
                if (threadState.getContextContainer().getApplication() != null) {
                    String callerApplicationName = threadState.getContextContainer().getApplication().getName();
                    if (this.isDefaultApplicationName(callerApplicationName) && this.isDefaultApplicationName(targetApplicationName)) {
                        return true;
                    }
                    if (callerApplicationName != null && callerApplicationName.equals(targetApplicationName)) {
                        return true;
                    }
                }
            }
            catch (NamingException namingException) {
                return false;
            }
        }
        return false;
    }

    public void setThreadMediator(RMIServerThreadMediator threadMediator) {
        this.m_threadMediator = threadMediator;
    }

    public RMIServerThreadMediator getThreadMediator() {
        return this.m_threadMediator;
    }

    private boolean isDefaultApplicationName(String applicationName) {
        return applicationName == null || applicationName.length() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeHandler(RMIServerConnection handler) {
        List list = this.serverConnections;
        synchronized (list) {
            this.serverConnections.remove(handler);
        }
    }

    public int getNumHandlers() {
        return this.serverConnections.size();
    }

    UserManager getUserManager() {
        if (this.userManager == null) {
            this.userManager = this.getApplicationServer().getDefaultApplication().getConfig().getUserManager();
        }
        return this.userManager;
    }

    ApplicationServer getApplicationServer() {
        return this.m_appServer;
    }

    public RMIContext getDefaultContext() {
        if (this.defaultContext == null) {
            this.defaultContext = new RMIServerContext(this, null);
        }
        return this.defaultContext;
    }

    boolean isClientInstance() {
        return false;
    }

    public RMIServerConfig getConfig() {
        return this.config;
    }

    protected String getVersion() {
        return ApplicationServer.VERSION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getConnections() {
        List list = this.serverConnections;
        synchronized (list) {
            return new ArrayList(this.serverConnections);
        }
    }

    public ServerSocket getSocket() {
        return this.socket;
    }

    public SSLServerSocket getSslSocket() {
        return this.sslSocket;
    }

    private static InetAddress getLocalAddress() {
        try {
            return InetAddress.getByName("127.0.0.1");
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    public ThreadPool getThreadPool() {
        return this.m_appServer == null ? super.getThreadPool() : this.m_appServer.getThreadPool();
    }

    ThreadPool getRequestThreadPool() {
        return this.m_appServer == null ? super.getThreadPool() : this.m_appServer.getRMIRequestThreadPool();
    }

    ThreadPool getConnectionThreadPool() {
        return this.m_appServer == null ? super.getConnectionThreadPool() : this.m_appServer.getConnectionThreadPool();
    }

    /*
     * WARNING - void declaration
     */
    User getUserByName(String domain, String username) throws IOException {
        void var3_3;
        User newUser;
        if (username.equals("")) {
            newUser = this.m_appServer.getAnonymousUser();
            if (newUser == null) {
                throw new IOException("No anonymous user");
            }
        } else {
            try {
                Application application = this.m_appServer.getApplication(domain);
                if (application == null) {
                    throw new IOException("No such application: " + domain);
                }
                newUser = application.getUserManager().getUser(username);
                if (newUser == null) {
                    throw new IOException("No such user: " + username);
                }
            }
            catch (InstantiationException e) {
                throw new IOException("Error instantiating application " + domain + ": " + e.getMessage());
            }
        }
        return var3_3;
    }

    ExecutionContext getExecutionContext(RMIContext context) throws InstantiationException {
        return context == this.defaultContext ? this.m_appServer.getDefaultApplication() : this.m_appServer.getApplication(context.domain);
    }

    boolean isLocalhostAdmin() {
        return this.m_appServer.getConfig().isLocalhostIsAdmin();
    }

    boolean isAnonymousUser(User user) {
        return user == null || this.m_appServer != null && user == this.m_appServer.getAnonymousUser();
    }

    protected boolean isUndefinedDomain(String domain) {
        if (this.m_appServer == null) {
            return false;
        }
        try {
            return !this.m_appServer.applicationExists(domain);
        }
        catch (InstantiationException e) {
            return true;
        }
    }

    protected String getDefaultApplicationDomain() {
        try {
            return this.m_appServer == null ? "" : this.m_appServer.getConfig().getDefaultApplicationConfig().getName();
        }
        catch (InstantiationException e) {
            return "";
        }
    }

    private void onContextCreated(String domain, RMIContext context) {
        RMIServer localRmiServer;
        if (this.m_appServer != null && this != (localRmiServer = this.m_appServer.getLocalRmiServer()) && localRmiServer != null) {
            localRmiServer.addContext(domain, context);
        }
    }

    private void addContext(String domain, RMIContext context) {
        if (this.contexts.get(domain) == null) {
            this.contexts.put(domain, context);
        }
    }

    RMIBinding newBinding(Object value, int distributionMode) {
        return new RMIBinding(value, distributionMode);
    }

    Object lookupAcrossContexts(RMIContext callingContext, String name) {
        Object objToReturn = null;
        Iterator iterator = this.contexts.values().iterator();
        while (iterator.hasNext()) {
            RMIContext context = (RMIContext)iterator.next();
            if (context.equals(callingContext)) continue;
            try {
                Object lookupResult = context.lookupLocalObject(name);
                if (lookupResult == null) continue;
                if (RMIServer.isLocalObject(lookupResult)) {
                    return lookupResult;
                }
                objToReturn = this.attemptLocalLookup(context.getName(), name);
                if (objToReturn == null) continue;
                break;
            }
            catch (NamingException e) {
                objToReturn = null;
            }
        }
        return objToReturn;
    }

    private static boolean isLocalObject(Object lookupResult) {
        return !(lookupResult instanceof Serializable) && !(lookupResult instanceof Remote);
    }

    private Object attemptLocalLookup(String domain, String name) {
        Hashtable<String, String> environment = new Hashtable<String, String>();
        environment.put("java.naming.factory.initial", RMIInitialContextFactory.class.getName());
        environment.put("java.naming.provider.url", "local://" + domain);
        try {
            InitialContext initialContext = new InitialContext(environment);
            return initialContext.lookup(name);
        }
        catch (NamingException namingException) {
            return null;
        }
    }

    private static String getLocalClientDomain(Map environment) {
        String providerURL = (String)environment.get("java.naming.provider.url");
        String localURLFormat = "local://";
        int protocolPosition = providerURL.indexOf("local://");
        if (protocolPosition > -1) {
            String domainName = providerURL.substring("local://".length());
            return domainName;
        }
        return null;
    }

    private static class LocalRmiClientContext
    extends RMIClientContext {
        private final RMIServer m_rmiServer;

        public LocalRmiClientContext(RMIServer rmiServer, String domain, Map environment) {
            super(rmiServer, domain, environment);
            this.m_rmiServer = rmiServer;
        }

        void establishLookupConnections(RMILocation location, RMIClient rmiClient, String userName, String password) throws IOException {
        }

        void establishRemoteConnections() throws NamingException {
            try {
                ServerRmiMessageHandler msgHandler = ServerRmiMessageHandler.createMessageHandler(this.m_rmiServer, this.domain, new RMIProtocol(this.m_rmiServer.getInterceptorManager()), this.m_rmiServer.getThreadPool(), true, this.m_rmiServer.getUserManager().getAdminUser());
                LocalClientRmiTransport localTransport = new LocalClientRmiTransport(this.m_rmiServer, msgHandler);
                this.m_rmiServer.getConnection(localTransport, null, null, this);
            }
            catch (RMILoginFailedException rmiLoginFailedException) {
                m_logger.fine("RMIServer.LocalRmiClientContext - Error in setting up local context connection");
                m_logger.log(Level.FINER, "", rmiLoginFailedException);
            }
        }
    }

    static class InitializationAborted
    extends Exception {
        InitializationAborted() {
        }
    }

    protected static final class Listener
    implements Runnable {
        private RMIServer m_rmiServer;
        private ListenerConfig m_listenerConfig;

        public Listener(RMIServer rmiServer, ListenerConfig listenerConfig) {
            this.m_rmiServer = rmiServer;
            this.m_listenerConfig = listenerConfig;
        }

        public void run() {
            if (m_logger.isLoggable(Level.FINEST)) {
                m_logger.log(Level.FINER, "launching thread: " + this.m_listenerConfig.getName());
            }
            try {
                while (this.m_rmiServer.isLiving()) {
                    this.renameThread();
                    this.m_rmiServer.waitForInitializationComplete();
                    while (this.m_rmiServer.isLiving() && this.m_rmiServer.isInitialized()) {
                        this.acceptNewConnection();
                    }
                }
            }
            catch (InitializationAborted initializationAborted) {
                // empty catch block
            }
            if (m_logger.isLoggable(Level.FINEST)) {
                m_logger.log(Level.FINER, "stopping thread: " + this.m_listenerConfig.getName());
            }
        }

        private void acceptNewConnection() {
            try {
                Socket clientSocket = this.m_listenerConfig.getServerSocket().accept();
                clientSocket.setTcpNoDelay(true);
                this.m_rmiServer.connect(new SocketNetworkConnection(clientSocket));
            }
            catch (SSLException e) {
                if (Listener.isUnrecoverableSSLException(e)) {
                    try {
                        this.m_rmiServer.handleCreateServerSocketException(e, this.m_listenerConfig.getPort());
                    }
                    catch (Exception exception) {}
                } else {
                    this.m_rmiServer.logError("acceptNewConnection()", e);
                }
            }
            catch (IOException e) {
                this.m_rmiServer.logError("acceptNewConnection()", e);
            }
            catch (NamingException e) {
                this.m_rmiServer.logError("acceptNewConnection()", e);
            }
        }

        static boolean isUnrecoverableSSLException(SSLException e) {
            String msg = e.getMessage();
            return null != msg && msg.startsWith("No available certificate");
        }

        private void renameThread() {
            String threadName = "RMIServer [" + this.getLocationString() + "] count:" + configCount_;
            Thread.currentThread().setName(threadName);
            if (m_logger.isLoggable(Level.FINER)) {
                m_logger.log(Level.FINER, "RMIServer thread renamed: " + threadName);
            }
        }

        String getLocationString() {
            return this.m_rmiServer.getAddress() + ":" + this.m_listenerConfig.getPort();
        }
    }

    protected static abstract class ListenerConfig {
        protected ListenerConfig() {
        }

        abstract int getPort();

        abstract ServerSocket getServerSocket();

        abstract String getName();
    }
}

