/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.multicastjms;

import com.evermind.compiler.CompilationException;
import com.evermind.parser.AddExpressionType;
import com.evermind.parser.AndExpressionType;
import com.evermind.parser.ConstantBooleanExpressionType;
import com.evermind.parser.ConstantNumberExpressionType;
import com.evermind.parser.DivideExpressionType;
import com.evermind.parser.EqualsExpressionType;
import com.evermind.parser.ExpressionParser;
import com.evermind.parser.ExpressionType;
import com.evermind.parser.LessExpressionType;
import com.evermind.parser.LessOrEqualsExpressionType;
import com.evermind.parser.LiteralStringExpressionType;
import com.evermind.parser.MoreExpressionType;
import com.evermind.parser.MoreOrEqualsExpressionType;
import com.evermind.parser.MultiplicationExpressionType;
import com.evermind.parser.NotEqualsExpressionType;
import com.evermind.parser.NotExpressionType;
import com.evermind.parser.OrExpressionType;
import com.evermind.parser.ParameterExpressionType;
import com.evermind.parser.PowerExpressionType;
import com.evermind.parser.SubExpressionType;
import com.evermind.parser.SubtractExpressionType;
import com.evermind.server.multicastjms.BetweenExpressionType;
import java.util.List;

public class JMSExpressionParser
extends ExpressionParser {
    private static final ExpressionType[] JMS_TYPES = new ExpressionType[]{new NotExpressionType("NOT"), new AndExpressionType("AND"), new OrExpressionType("OR"), new EqualsExpressionType("="), new MoreExpressionType(">"), new MoreOrEqualsExpressionType(">="), new LessExpressionType("<"), new LessOrEqualsExpressionType("<="), new NotEqualsExpressionType("<>"), new PowerExpressionType("^"), new AddExpressionType("+"), new SubtractExpressionType("-"), new DivideExpressionType("/"), new MultiplicationExpressionType("*"), new SubExpressionType("(", ")"), new ConstantBooleanExpressionType("true", true, 1), new ConstantBooleanExpressionType("false", true, 0), new BetweenExpressionType("BETWEEN "), new ConstantNumberExpressionType(), new LiteralStringExpressionType(), new ParameterExpressionType()};

    public JMSExpressionParser() {
        this.types = JMS_TYPES;
    }

    protected List processParts(List parts) throws CompilationException {
        for (int i = 0; i < parts.size(); ++i) {
            String part = (String)parts.get(i);
            if (part.equalsIgnoreCase("BETWEEN")) {
                if (i + 3 >= parts.size()) {
                    throw new CompilationException("Syntax error in BETWEEN statement");
                }
                StringBuffer buffer = new StringBuffer();
                buffer.append(part);
                buffer.append(' ');
                buffer.append((String)parts.remove(i + 1));
                buffer.append(' ');
                buffer.append((String)parts.remove(i + 1));
                buffer.append(' ');
                buffer.append((String)parts.remove(i + 1));
                continue;
            }
            if (!part.equalsIgnoreCase("LIKE") && !part.equalsIgnoreCase("IS")) continue;
        }
        return parts;
    }
}

