/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.jms.filter;

import com.evermind.server.jms.filter.AssertException;
import com.evermind.server.jms.filter.Expression;
import com.evermind.server.jms.filter.ExpressionVector;
import com.evermind.server.jms.filter.GeneralException;
import com.evermind.server.jms.filter.IBooleanExpression;
import com.evermind.server.jms.filter.QueryMap;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

final class QueryVector {
    private Hashtable maps = new Hashtable();
    private Hashtable objects = new Hashtable();

    QueryVector() {
    }

    void addQuery(IBooleanExpression booleanExpr, Object obj) throws AssertException {
        if (this.objects.containsKey(obj)) {
            throw new AssertException("object not unique", null);
        }
        this.objects.put(obj, booleanExpr);
        QueryMap qmap = (QueryMap)this.maps.get(booleanExpr);
        if (qmap == null) {
            Expression be = (Expression)((Object)booleanExpr);
            qmap = new QueryMap(booleanExpr);
            this.maps.put(booleanExpr, qmap);
        }
        qmap.addObject(obj);
    }

    boolean removeQuery(Object obj, ExpressionVector exprs) throws GeneralException {
        IBooleanExpression expr = (IBooleanExpression)this.objects.remove(obj);
        if (expr == null) {
            return false;
        }
        QueryMap qmap = (QueryMap)this.maps.get(expr);
        if (qmap == null) {
            return false;
        }
        if (qmap.removeObject(obj)) {
            this.maps.remove(expr);
        }
        exprs.removeExpr(expr);
        return true;
    }

    void eval(Vector trueObjects) {
        trueObjects.removeAllElements();
        Enumeration enum5 = this.maps.elements();
        while (enum5.hasMoreElements()) {
            QueryMap qm = (QueryMap)enum5.nextElement();
            qm.evalExpr(trueObjects);
        }
    }

    public String toString() {
        String mstr = "";
        String ostr = "";
        Enumeration enum5 = this.maps.elements();
        while (enum5.hasMoreElements()) {
            mstr = mstr + ((QueryMap)enum5.nextElement()).toString();
        }
        enum5 = this.objects.elements();
        while (enum5.hasMoreElements()) {
            ostr = ostr + enum5.nextElement().toString() + " ";
        }
        return " maps: " + mstr + " objects: " + ostr + " ";
    }
}

